#include <stdlib.h>
#include <string.h>
#include <nds.h>
#include <nds/arm9/sound.h>
#include <nds/interrupts.h>
#include "game.h"
#include "ihm.h"
#include "intro.h"
#include "persistent.h"
#include "splash.h"
#include "scores.h"
#include "bottom_game_over_gfx.h"
#include "wav_game_over.h"
#include "wav_next_level.h"
#include "wav_intro.h"
#include "bottom_got_highscore_gfx.h"



void vblank_handler ()
{
}





int main (void)
{
  struct game *game ;
  enum game_type game_type = Game_Original ;
  u16 level = 0 ;
  bool go_on ;

  powerON (POWER_ALL_2D) ;
  IPC->soundData = 0 ;

  vramSetMainBanks (VRAM_A_LCD, VRAM_B_LCD, VRAM_C_LCD, VRAM_D_LCD) ;
  vramSetBankA (VRAM_A_MAIN_BG_0x6000000);    // Bg 0x06000000 - 0x06020000
  vramSetBankC (VRAM_C_SUB_BG_0x6200000);     // Bg 0x06200000 - 0x06040000
  vramSetBankD (VRAM_D_SUB_SPRITE);           // Objs tiles 0x6600000

  irqInit () ;
  irqSet (IRQ_VBLANK, vblank_handler) ;
  irqEnable (IRQ_VBLANK) ;

  setGenericSound (11025,  /* Sample rate. */
		   127,	   /* Volume. */
		   64,	   /* Panning. */
		   1) ;	   /* Sound format. */
  lcdSwap () ;
  splash_neo () ;

  /* Un petit son de bienvenue. */
  playGenericSound (g_wav_intro, WAV_INTRO_LENGTH * sizeof (u32)) ;

  srand ((unsigned) DISP_Y) ;

  /* Rcupration des donnes persistentes. */
  read_scores () ;
  game = load_hibernated () ;
  if (game != NULL) {
    go_on = true ;
    setup_gfx () ;
    redraw_all (game) ;
    goto direct_run_hibernated ;     /* Oh que c'est crado :))) */
  }

  for (;;) {
    game_type = intro () ;
    go_on = true ;
    /* Boucle qui tourne jusqu' la fin de la partie. */
    while (go_on) {
      setup_gfx () ;
      game = new_game (level, game_type) ;
    direct_run_hibernated:
      switch (mainloop (game)) {
      case Main_End_Lost: level = 0 ; go_on = false ; break ;
      case Main_End_Next:
	playGenericSound
	  (g_wav_next_level, WAV_NEXT_LEVEL_LENGTH * sizeof (u32)) ;
	level = !0 ;
	break ;
      }       /* Fin de switch (mainloop (game)). */
    }         /* Fin de  while (go_on). */

    /* Affichage du game over... */
    playGenericSound
      (g_wav_game_over, WAV_GAME_OVER_LENGTH * sizeof (u32)) ;
    splash_on_bottom_bg0 ((u16*) CHAR_BASE_BLOCK_SUB (1),
			  (u16*) SCREEN_BASE_BLOCK_SUB (0),
			  BOTTOM_GAME_OVER_PALETTE_SIZE,
			  bottom_game_over_palette,
			  NB_BOTTOM_GAME_OVER_TILES,
			  bottom_game_over_tiles,
			  BOTTOM_GAME_OVER_MAP_WIDTH,
			  BOTTOM_GAME_OVER_MAP_HEIGHT,
			  bottom_game_over_map) ;

    if (check_if_highscore (game_type, game->score, game->level)) {
      /* On a fait un highscore. */
      save_scores () ;
      /* Petit cran de flicitation. */
      splash_on_bottom_bg0 ((u16*) CHAR_BASE_BLOCK_SUB (1),
			    (u16*) SCREEN_BASE_BLOCK_SUB (0),
			    BOTTOM_GOT_HIGHSCORE_PALETTE_SIZE,
			    bottom_got_highscore_palette,
			    NB_BOTTOM_GOT_HIGHSCORE_TILES,
			    bottom_got_highscore_tiles,
			    BOTTOM_GOT_HIGHSCORE_MAP_WIDTH,
			    BOTTOM_GOT_HIGHSCORE_MAP_HEIGHT,
			    bottom_got_highscore_map) ;
      show_scores () ;
    }         /* Fin de if (check_if_highscore (game_type, ... */
  }           /* Fin de for (;;). */

  powerOFF (POWER_ALL) ;
  return (0) ;
}
