#ifndef __BOTTOM_GAME_BG_GFX_H__
#define __BOTTOM_GAME_BG_GFX_H__

#define BOTTOM_GAME_BG_PALETTE_SIZE 256
#define NB_BOTTOM_GAME_BG_TILES 121
#define BOTTOM_GAME_BG_MAP_HEIGHT 24
#define BOTTOM_GAME_BG_MAP_WIDTH 32

extern const u16 bottom_game_bg_palette[BOTTOM_GAME_BG_PALETTE_SIZE]
  __attribute__ ((section (".rodata"))) ;
extern const u8 bottom_game_bg_tiles[NB_BOTTOM_GAME_BG_TILES * 64]
  __attribute__ ((section (".rodata"))) ;
extern const u16 bottom_game_bg_map[BOTTOM_GAME_BG_MAP_HEIGHT * BOTTOM_GAME_BG_MAP_WIDTH]
  __attribute__ ((section (".rodata"))) ;

#define HOLE_TILES_LOADING_OFFSET (((NB_BOTTOM_GAME_BG_TILES) * 64) / 2)
#define HOLE_FIRST_TILE_INDEX (NB_BOTTOM_GAME_BG_TILES)
#define NB_HOLE_TILES 4

extern const u8 hole_tiles[NB_HOLE_TILES * 64]
   __attribute__ ((section (".rodata"))) ;

#define BOARD_X_OFFSET 3
#define BOARD_Y_OFFSET 4

#define SHAPE_POOL_X_AS_PIXELS (26 * 8)
#define SHAPE_POOL_Y_AS_PIXELS (6 * 8)

#define SHAPE_THROW_X_AS_PIXELS (25 * 8)
#define SHAPE_THROW_Y_AS_PIXELS (13 * 8)
#define SHAPE_THROW_WIDTH_AS_PIXELS 32
#define SHAPE_THROW_HEIGHT_AS_PIXELS 32

#define BUTTON_HIDE_X_AS_PIXELS (29 * 8)
#define BUTTON_HIDE_Y_AS_PIXELS (0 * 8)
#define BUTTON_HIDE_WIDTH_AS_PIXELS 24
#define BUTTON_HIDE_HEIGHT_AS_PIXELS 24

#endif
