#include <nds.h>
#include <stdlib.h>
#include <nds/arm9/sound.h>
#include "game.h"
#include "ihm.h"
#include "bottom_game_bg_gfx.h"
#include "top_game_bg_gfx.h"
#include "top_fonts_gfx.h"
#include "printing.h"
#include "wav_place_ok.h"
#include "wav_place_ok2.h"
#include "wav_place_ok3.h"
#include "wav_place_ok4.h"
#include "wav_place_ok5.h"
#include "wav_place_ok6.h"
#include "wav_place_ok7.h"
#include "wav_place_ko.h"
#include "wav_destruct.h"
#include "wav_throw.h"
#include "pause.h"
#include "wav_can_t_throw.h"



struct game global_game ;





static bool is_compatible (shape handled, shape s2)
{
  enum shape_type t_handled = GET_TYPE (handled) ;
  enum shape_color c_handled = GET_COLOR (handled) ;
  enum shape_type t2 = GET_TYPE (s2) ;
  enum shape_color c2 = GET_COLOR (s2) ;

  if (t2 == Type_None) return (true) ;
  if ((t_handled == t2) || (c_handled == c2))  return (true) ;
  if ((t_handled == Type_Universal) || (t2 == Type_Universal)) return (true) ;
  return (false) ;
}




/* Retourne par argument en mode OUT le nombre de voisins 4-connexes rels   */
/* valides. Si la pice ne "fit" pas, ce nombre n'est pas significatif. Si   */
/* le pointeur 'nb_real_neighbours' est NULL, alors aucun compte n'est fait. */
static bool fit_p (struct game *game, s16 x, s16 y, u8 *nb_real_neighbours)
{
  bool north, east, south, west ;
  bool connected = false ;
  shape tmp ;

  if (nb_real_neighbours) *nb_real_neighbours = 0 ;
  if ((x < 0) || (y < 0) || (x >= BOARD_WIDTH) ||(y >= BOARD_HEIGHT))
    return (false) ;

  tmp = game->board[x][y] ;

  if (GET_TYPE (tmp) != Type_None) return (false) ;

  if (y > 0) {
    tmp = game->board[x][y - 1] ;
    north = is_compatible (game->proposed, tmp) ;
    if ((GET_TYPE (tmp)) != Type_None) {
      connected = true ;
      if (nb_real_neighbours) *nb_real_neighbours = *nb_real_neighbours + 1 ;
    }
  }
  else {
    north = true ;
  }

  if (x < (BOARD_WIDTH - 1)) {
    tmp = game->board[x + 1][y] ;
    east = is_compatible (game->proposed, tmp) ;
    if ((GET_TYPE (tmp)) != Type_None) {
      connected = true ;
      if (nb_real_neighbours) *nb_real_neighbours = *nb_real_neighbours + 1 ;
    }
  }
  else {
    east = true ;
  }

  if (y < (BOARD_HEIGHT - 1)) {
    tmp = game->board[x][y + 1] ;
    south = is_compatible (game->proposed, tmp) ;
    if ((GET_TYPE (tmp)) != Type_None) {
      connected = true ;
      if (nb_real_neighbours) *nb_real_neighbours = *nb_real_neighbours + 1 ;
    }
  }
  else {
    south = true ;
  }

  if (x > 0) {
    tmp = game->board[x - 1][y] ;
    west = is_compatible (game->proposed, tmp) ;
    if ((GET_TYPE (tmp)) != Type_None) {
      connected = true ;
      if (nb_real_neighbours) *nb_real_neighbours = *nb_real_neighbours + 1 ;
    }
  }
  else {
    west = true ;
  }

  return (connected && north && east && south && west) ; 
}





static void new_shape (struct game *game)
{
  enum shape_color c ;
  enum shape_type t ;
  u16 x, y ;

  /* On regarde si l'on a la chance d'obtenir une pice "universelle". */
  if (((17 + rand ()) % 100) < UNIVERSAL_PROBA) {
    SET_COLOR_TYPE (game->proposed, Color_Universal, Type_Universal) ;
  }
  else {
    /* On tire une pice au hasard. */
    c = 1 + ((17 + rand ()) % game->nb_colors) ;
    t = 1 + ((17 + rand ()) % game->nb_types) ;
    SET_COLOR_TYPE (game->proposed, c, t) ;
  }

  game->player.player_x = SHAPE_POOL_X_AS_PIXELS ;
  game->player.player_y = SHAPE_POOL_Y_AS_PIXELS ;
  game->player.action = Action_Idle ;
  /* On met directement  jour le boolen disant si la pice peut rentrer. */
  game->can_fit = false ;
  for (y = 0; y < BOARD_HEIGHT; y++) {
    for (x = 0 ; x < BOARD_WIDTH; x++) {
      if (fit_p (game, x, y, NULL)) {
	game->can_fit = true ;
	return ;
      }
    }
  }
}




struct game* new_game (u16 level, enum game_type game_type)
{
  short x, y ;

  for (y = 0; y < BOARD_HEIGHT; y++) {
    for (x = 0; x < BOARD_WIDTH; x++) {
      SET_COLOR_TYPE (global_game.board[x][y], Color_None, Type_None) ;
      global_game.cell_filled_p[x][y] = false ;
    }
  }

  if (level == 0) {
    /* En fait on a demand un vrai nouveau jeu. */
    global_game.game_type = game_type ;
    global_game.level = 1 ;
    global_game.score = 0 ;
    /* Jamais de contrainte au dbut. */
    global_game.constraint = Constraint_None ;
    switch (game_type) {
    case Game_Original:
      global_game.nb_colors = 3 ;
      global_game.nb_types = 3 ;
      break ;
    case Game_Fu:
      global_game.nb_colors = FU_COLORS_NUMBER ;
      global_game.nb_types = FU_TYPES_NUMBER ;
      break ;
    }               /* Fin de switch (game_type). */
  }                 /* Fin de if (level == 0). */
  else {
    /* Sinon, c'est qu'on a simplement augment de niveau. */
    global_game.level++ ;
    switch (game_type) {
    case Game_Original:
      /* Pas la peine de changer la contrainte, elle ne bouge pas. */
      if ((global_game.level % 2) == 0) {
	/* Niveaux pairs => augmentation des formes. */
	global_game.nb_types =
	  min ((global_game.nb_types + 1), MAX_TYPES_NUMBER) ;
      }
      else {
	/* Niveaux impairs => augmentation des couleurs. */
	global_game.nb_colors =
	  min ((global_game.nb_colors + 1), MAX_COLORS_NUMBER) ;
      }
      break ;       /* Fin de case Game_Original. */

    case Game_Fu:
      /* Rien a modifier dans le nombre de formes et de couleurs. */
      /* Par contre, il faut modifier les contraintes. */
      global_game.constraint =
	(enum constraint) ((global_game.level - 1) % 3) ;
      break ;       /* Fin de case Game_Fu. */
    }               /* Fin de switch (game_type). */
  }                 /* Fin du else de if (level == 0). */

  for (x = 0; x < BOARD_WIDTH; x++) {
    global_game.cleared_column_p[x] = false ;
    global_game.columns_counters[x] = 0 ;
  }

  for (y = 0; y < BOARD_HEIGHT; y++) {
    global_game.cleared_line_p[y] = false ;
    global_game.lines_counters[y] = 0 ;
  }

  global_game.recovery_count_down = NUM_PIECES_FOR_RECOVER_1 ;
  global_game.nb_cleared_lines = 0 ;
  global_game.nb_cleared_columns = 0 ;
  global_game.nb_thrown_allowed = INITIAL_NB_THROWN_ALLOWED ;
  global_game.can_fit = true ;

  SET_COLOR_TYPE (global_game.board[INITIAL_SHAPE_X][INITIAL_SHAPE_Y],
		  Color_Universal, Type_Universal) ;
  global_game.nb_cleared_cells = 1 ;  /* La "Universal" pose au dpart. */
  global_game.cell_filled_p[INITIAL_SHAPE_X][INITIAL_SHAPE_Y] = true ;
  global_game.columns_counters[INITIAL_SHAPE_X] = 1 ;
  global_game.lines_counters[INITIAL_SHAPE_Y] = 1 ;
  draw_shape (global_game.board[INITIAL_SHAPE_X][INITIAL_SHAPE_Y],
	      INITIAL_SHAPE_X, INITIAL_SHAPE_Y) ;

  new_shape (&global_game) ;
  return (&global_game) ;
}





static bool line_constraint_p (struct game *game, u16 at_y)
{
  short x ;
  enum shape_color tmp_c ;
  enum shape_type tmp_t ;
  enum shape_color c = Color_Universal ;
  enum shape_type t = Type_Universal ;

  switch (game->constraint) {
  case Constraint_None: break ;

  case Constraint_Color:
    for (x = 0; x < BOARD_WIDTH; x++) {
      tmp_c = GET_COLOR (game->board[x][at_y]) ;
      if ((tmp_c != c) && (tmp_c != Color_Universal)) {
	if (c == Color_Universal) c = tmp_c ;
	else return (false) ;
      }
    }
    break ;

  case Constraint_Shape:
    for (x = 0; x < BOARD_WIDTH; x++) {
      tmp_t = GET_TYPE (game->board[x][at_y]) ;
      if ((tmp_t != t) && (tmp_t != Type_Universal)) {
	if (t == Type_Universal) t = tmp_t ;
	else return (false) ;
      }
    }
    break ;
  }

  return (true) ;
}





static bool col_constraint_p (struct game *game, u16 at_x)
{
  short y ;
  enum shape_color tmp_c ;
  enum shape_type tmp_t ;
  enum shape_color c = Color_Universal ;
  enum shape_type t = Type_Universal ;

  switch (game->constraint) {
  case Constraint_None: break ;

  case Constraint_Color:
    for (y = 0; y < BOARD_HEIGHT; y++) {
      tmp_c = GET_COLOR (game->board[at_x][y]) ;
      if ((tmp_c != c) && (tmp_c != Color_Universal)) {
	if (c == Color_Universal) c = tmp_c ;
	else return (false) ;
      }
    }
    break ;

  case Constraint_Shape:
    for (y = 0; y < BOARD_HEIGHT; y++) {
      tmp_t = GET_TYPE (game->board[at_x][y]) ;
      if ((tmp_t != t) && (tmp_t != Type_Universal)) {
	if (t == Type_Universal) t = tmp_t ;
	else return (false) ;
      }
    }
    break ;
  }

  return (true) ;
}





/* Met  jour le score par passage par rfrence par    */
/* effet de bord si le pointeur 'score' n'est pas NULL. */
static bool check_destruction (struct game *game, u16 at_x, u16 at_y,
			       u32 *score)
{
  short i, x, y ;
  bool found_line, found_column ;
  bool put_hole  ;

  found_line = (game->lines_counters[at_y] == BOARD_WIDTH) ;
  found_column = (game->columns_counters[at_x] == BOARD_HEIGHT) ;

  if (found_line) {
    /* Ligne  dtruire. */
    if ((!game->cleared_line_p[at_y]) && (line_constraint_p (game, at_y))) {
      /* On ne compte la ligne que si elle n'avait pas dj t */
      /* dtruite et si elle respecte l'ventuelle contrainte.  */
      if (score) *score = *score + SCORE_NEW_DESTRUCTION ;
      game->cleared_line_p[at_y] = true ;
      game->nb_cleared_lines++ ;
      put_hole = true ;
    }
    else {
      put_hole = false ;
      /* La ligne avait dj t dtruite. On augmente quand mme le score. */
      if (score) *score = *score + SCORE_OLD_DESTRUCTION ;
    }
    init_exploding_animation () ;
    animate_exploding_line (at_y) ;
    for (i = 0; i < BOARD_WIDTH; i++) {
      if (! game->cell_filled_p[i][at_y]) {
	game->cell_filled_p[i][at_y] = true ;
	game->nb_cleared_cells ++ ;
      }
      SET_COLOR_TYPE (game->board[i][at_y], Color_None, Type_None) ;
    }
    clear_line (at_y, put_hole) ;
  }

  if (found_column) {
    /* Colonne  dtruire. */
    if ((!game->cleared_column_p[at_x]) && (col_constraint_p (game, at_x))) {
      /* On ne compte la colonne que si elle n'avait pas dj t */
      /* dtruite et si elle respecte l'ventuelle contrainte.    */
      if (score) *score = *score + SCORE_NEW_DESTRUCTION ;
      game->cleared_column_p[at_x] = true ;
      game->nb_cleared_columns++ ;
      put_hole = true ;
    }
    else {
      put_hole = false ;
      /* La colonne avait dj t dtruite.On augmente quand mme le score. */
      if (score) *score = *score + SCORE_OLD_DESTRUCTION ;
    }
    if (!found_line) init_exploding_animation () ;
    animate_exploding_column (at_x) ;
    for (i = 0; i < BOARD_HEIGHT; i++) {
      if (! game->cell_filled_p[at_x][i]) {
	game->cell_filled_p[at_x][i] = true ;
	game->nb_cleared_cells ++ ;
      }
      SET_COLOR_TYPE (game->board[at_x][i], Color_None, Type_None) ;
    }
    clear_column (at_x, put_hole) ;
  }
  if (found_line || found_column) release_exploding_animation () ;

  /* Bonus de double destruction ligne/colonne. */
  if (found_line && found_column && score)
    *score = *score + SCORE_CROSS_DESTRUCTION ;

  /* Maintenant, on rinitialise les compteurs. */
  if (found_line) {
    game->lines_counters[at_y] = 0 ;
    for (x = 0; x < BOARD_WIDTH; x++) game->columns_counters[x]-- ;
  }

  if (found_column) {
    game->columns_counters[at_x] = 0 ;
    for (y = 0; y < BOARD_HEIGHT; y++) {
      /* Pour viter de dcrmenter 2 fois le compteur dans le  */
      /* cas o l'on a fait  la fois une ligne et une colonne. */
      if (game->lines_counters[y] > 0) game->lines_counters[y]-- ;
    }
  }

  /* On retourne si l'on a dtruit au moins 1 ligne ou colonne. */
  return ((found_line) || (found_column)) ;
}




#define NB_RANDOM_PLACE_OK_SOUNDS 7
struct rnd_snd {
  const u32 *data ;
  const u32 length ;
};

static const struct rnd_snd random_place_ok_sounds[NB_RANDOM_PLACE_OK_SOUNDS] =
{ { g_wav_place_ok, WAV_PLACE_OK_LENGTH },
  { g_wav_place_ok2, WAV_PLACE_OK2_LENGTH },
  { g_wav_place_ok3, WAV_PLACE_OK3_LENGTH },
  { g_wav_place_ok4, WAV_PLACE_OK4_LENGTH },
  { g_wav_place_ok5, WAV_PLACE_OK5_LENGTH },
  { g_wav_place_ok6, WAV_PLACE_OK6_LENGTH },
  { g_wav_place_ok7, WAV_PLACE_OK7_LENGTH }
};



static void play_place_ok_random_sound ()
{
  u8 i ;
  
  i = ((17 + rand ()) % NB_RANDOM_PLACE_OK_SOUNDS) ;
  playGenericSound
    (random_place_ok_sounds[i].data,
     random_place_ok_sounds[i].length * sizeof (u32)) ;
}




static bool lay_down (struct game *game)
{
  /* Eh oui, les coordonnes du joueur sont celles de la position     */
  /* du sprite, donc top-left. La position centrale doit donc tre    */
  /* calcule en considrant que l'on tient le sprite par son milieu. */
  /* x et y sont maintenant des coordonnes "damier".                 */
  s16 x = (((s16) game->player.player_x + 8) - (BOARD_X_OFFSET * 8)) / 16 ;
  s16 y = (((s16) game->player.player_y + 8) - (BOARD_Y_OFFSET * 8)) / 16 ;
  bool result ;
  bool destruction_occured ;
  u8 nb_real_neighbours = 0 ;

  /* Score mis  jour par effet de bord. */
  result = fit_p (game, x, y, &nb_real_neighbours) ;

  if (result) {
    /* Un petit son pour dire qu'on a russi  placer la pice. */
    play_place_ok_random_sound () ;
    animate_spin_stars_on_sprite_0
      (game->player.player_x, game->player.player_y) ;

    /* Mise  jour du score de pice pose. */
    game->score += (1 << nb_real_neighbours) * SCORE_PIECE_PLACED ;
    /* On fixe la pice effectivement sur le damier. */
    game->board[x][y] = game->proposed ;
    draw_shape (game->proposed, x, y) ;
    game->lines_counters[y]++ ;
    game->columns_counters[x]++ ;
    /* Score mis  jour par effet de bord pour les destructions. */
    destruction_occured = check_destruction (game, x, y, &game->score) ;
    /* On met  jour le but. */
    refresh_aim_counter (game) ;

    /* Le son de l'explosion... */
    if (destruction_occured)
      playGenericSound (g_wav_destruct, WAV_DESTRUCT_LENGTH * sizeof (u32)) ;

    /* En fonction du mode de jeu, on met  jour le   */
    /* nombre de pices que l'on a le droit de jeter. */
    switch (game->game_type) {
    case Game_Original:
      if (destruction_occured) {
	game->nb_thrown_allowed = INITIAL_NB_THROWN_ALLOWED ;
	refresh_trash_bar
	  (INITIAL_NB_THROWN_ALLOWED - game->nb_thrown_allowed) ;
      }            /* Fin de if (destruction_occured). */
      break ;      /* Fin de case Game_Original. */

    case Game_Fu:
      game->recovery_count_down-- ;
      if (game->recovery_count_down == 0) {
	game->recovery_count_down = NUM_PIECES_FOR_RECOVER_1 ;
	game->nb_thrown_allowed++ ;
	refresh_trash_bar
	  (INITIAL_NB_THROWN_ALLOWED - game->nb_thrown_allowed) ;
      }           /* Fin de if (game->recovery_count_down == 0). */
      break ;     /* Fin de case Game_Fu. */
    }             /* Fin de switch (game->game_type). */
  }               /* Fin de if (result). */

  return (result) ;
}





static bool throw_shape (struct game *game)
{
  short i ;

  if (game->nb_thrown_allowed > 0) {
    game->nb_thrown_allowed-- ;
    playGenericSound (g_wav_throw, WAV_THROW_LENGTH * sizeof (u32)) ;
    animate_throwing_cursor (game) ;
    refresh_trash_bar (INITIAL_NB_THROWN_ALLOWED - game->nb_thrown_allowed) ;
    new_shape (game) ;
    return (true) ;
  }
  else {
    playGenericSound
      (g_wav_can_t_throw, WAV_CAN_T_THROW_LENGTH * sizeof (u32)) ;
    /* On fait un flash  l'cran. */
    SUB_BLEND_Y = 8 ;
    SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
    for (i = 0; i < 8; i++) swiWaitForVBlank () ;
    SUB_BLEND_CR = 0 ;
    return (false) ;
  }
}





enum location { Location_None, Location_Proposed,
		Location_Throw, Location_Hide } ;

static enum location find_location (s16 x, s16 y)
{
  if ((x < SHAPE_POOL_X_AS_PIXELS + 16) &&
      (x >= SHAPE_POOL_X_AS_PIXELS) &&
      (y < SHAPE_POOL_Y_AS_PIXELS + 16) &&
      (y >= SHAPE_POOL_Y_AS_PIXELS))
    return (Location_Proposed) ;

  if ((x < SHAPE_THROW_X_AS_PIXELS + SHAPE_THROW_WIDTH_AS_PIXELS) &&
      (x >= SHAPE_THROW_X_AS_PIXELS) &&
      (y < SHAPE_THROW_Y_AS_PIXELS + SHAPE_THROW_HEIGHT_AS_PIXELS) &&
      (y >= SHAPE_THROW_Y_AS_PIXELS))
    return (Location_Throw) ;

  if ((x < BUTTON_HIDE_X_AS_PIXELS + BUTTON_HIDE_WIDTH_AS_PIXELS) &&
      (x >= BUTTON_HIDE_X_AS_PIXELS) &&
      (y < BUTTON_HIDE_Y_AS_PIXELS + BUTTON_HIDE_HEIGHT_AS_PIXELS) &&
      (y >= BUTTON_HIDE_Y_AS_PIXELS))
    return (Location_Hide) ;

  return (Location_None) ;
}





enum end_game { End_Game_None, End_Game_Lost, End_Game_Next } ;

static enum end_game check_end (struct game *game)
{
  short aim ;

  switch (game->game_type) {
  case Game_Fu:
    aim = game->level / 3 ;
    if ((game->level % 3) != 0) aim++ ;
    if ((game->nb_cleared_lines + game->nb_cleared_columns) >=
	(min (aim, (BOARD_WIDTH + BOARD_HEIGHT)))) {
      return (End_Game_Next) ;
    }
    break ;

  case Game_Original:
    if (game->nb_cleared_cells >= (BOARD_WIDTH * BOARD_HEIGHT)) {
      return (End_Game_Next) ;
    }
    break ;
  }

  if (!game->can_fit && (game->nb_thrown_allowed == 0)) {
    return (End_Game_Lost) ;
  }

  return (End_Game_None) ;
}




/* Pour viter que si l'on a vid le damier, on ne puisse plus poser de      */
/* pice du fait qu'il n'y aura plus moyen d'tre connexe  une autre pice. */
void insert_may_be_universal_shape (struct game *game)
{
  short y ;
  bool empty = true ;

  /* On vrifie si le damier est vide. */
  for (y = 0; y < BOARD_HEIGHT; y++) {
    if (game->lines_counters[y] > 0) {
      empty = false ;
      break ;
    }    /* Fin de if (game->lines_counters[y] > 0). */
  }      /* Fin de for (y = 0; y < BOARD_HEIGTH; y++). */

  if (empty) {
    SET_COLOR_TYPE (game->board[INITIAL_SHAPE_X][INITIAL_SHAPE_Y],
		    Color_Universal, Type_Universal) ;
  game->nb_cleared_cells = 1 ;  /* La "Universal" pose au dpart. */
  game->cell_filled_p[INITIAL_SHAPE_X][INITIAL_SHAPE_Y] = true ;
  game->columns_counters[INITIAL_SHAPE_X] = 1 ;
  game->lines_counters[INITIAL_SHAPE_Y] = 1 ;
  draw_shape (game->board[INITIAL_SHAPE_X][INITIAL_SHAPE_Y],
	      INITIAL_SHAPE_X, INITIAL_SHAPE_Y) ;
  }
}




enum mainloop_end mainloop (struct game *game)
{
  s16 x, y ;
  bool refresh ;
  touchPosition stylus_xy ;

  refresh_cursor (game) ;
  refresh_constraint_icon (game) ;
  large_print_int
    (((u16*) SCREEN_BASE_BLOCK (1)), game->level,
     LEVEL_X_OFFSET, LEVEL_Y_OFFSET) ;
  large_print_int
    (((u16*) SCREEN_BASE_BLOCK (1)), game->score,
     SCORE_X_OFFSET, SCORE_Y_OFFSET) ;
  refresh_aim_counter (game) ;

  for (;;) {
    refresh = false ;

    /* Vrification de la fin du jeu. */
    switch (check_end (game)) {
    case End_Game_None: break ;
    case End_Game_Lost: return (Main_End_Lost) ; break ;
    case End_Game_Next: return (Main_End_Next) ; break ;
    }

    /* Surtout 1 seul 'scanKeys' par itration. */
    scanKeys () ;
    stylus_xy = touchReadXY () ;

    /* Demande de pause. */
    if (keysDown () & KEY_START) {
      if (!pause_game (game)) return (Main_End_Lost) ;
    }

    /* Le crayon vient d'tre appuy. */
    if (keysDown () & KEY_TOUCH) {
      refresh = true ;
      x = (s16) stylus_xy.px ;
      y = (s16) stylus_xy.py ;
      switch (find_location (x, y)) {
      case Location_Proposed:
	game->player.player_x = x ;
	game->player.player_y = y ;
	game->player.action = Action_Drag ;
	break ;

      case Location_Throw:
	throw_shape (game) ;
	game->player.action = Action_Idle ;
	break ;

      case Location_Hide:
	/* Permet de jouer au toggle avec les pices sur le damier. */
	videoSetModeSub
	  (SUB_DISPLAY_CR ^ (DISPLAY_BG1_ACTIVE | DISPLAY_BG2_ACTIVE)) ;
	break ;

      default:
	animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	game->player.action = Action_Idle ;
	break ;
      }             /* Fin de switch (find_location (x, y)). */
    }               /* Fin de if (keysDown () & KEY_TOUCH). */

    /* Le crayon est maintenu appuy. */
    if (keysHeld () & KEY_TOUCH) {
      refresh = true ;
      if (game->player.action == Action_Drag) {
	x = (s16) stylus_xy.px ;
	y = (s16) stylus_xy.py ;
	x = max ((x - 8), 0) ;
	y = max ((y - 8), 0) ;
	x = min ((256 - 16), x) ;
	y = min ((192 - 16), y) ;
	game->player.player_x = x ;
	game->player.player_y = y ;
      }
    }               /* Fin de if (keysHeld () & KEY_TOUCH). */

    /* Relchement du crayon. */
    if (keysUp () & KEY_TOUCH) {
      refresh = true ;
      if (game->player.action == Action_Drag) {
	game->player.action = Action_Idle ;
	if (lay_down (game)) {
	  insert_may_be_universal_shape (game) ;
	  /* Le son pour dire qu'on a russi  placer la pice est jou  */
	  /* dans 'lay_down' avant l'ventuel son d'explosion afin de ne */
	  /* pas l'entendre une fois que l'explosion s'est produite.     */
	  new_shape (game) ;
	  /* Remise  jour de l'affichage du score. */
	  large_print_int
	    (((u16*) SCREEN_BASE_BLOCK (1)), game->score,
	     SCORE_X_OFFSET, SCORE_Y_OFFSET) ;
	}
	else {
	  /* Un petit son pour dire que la pice ne rentre pas. */
	  playGenericSound
	    (g_wav_place_ko, WAV_PLACE_KO_LENGTH * sizeof (u32)) ;
	  game->player.player_x = SHAPE_POOL_X_AS_PIXELS ;
	  game->player.player_y = SHAPE_POOL_Y_AS_PIXELS ;
	}
      }             /* Fin de if (game->player.action == Action_Drag). */
    }               /* Fin de if (keysUp () & KEY_TOUCH). */

    if (refresh) refresh_cursor (game) ;
  }
}
