#ifndef __GAME_H__
#define __GAME_H__

#ifndef min
#define min(a,b) ((a) < (b) ? (a) : (b))
#endif

#ifndef max
#define max(a,b) ((a) > (b) ? (a) : (b))
#endif


#define BOARD_WIDTH 9
#define BOARD_HEIGHT 8

#define FU_TYPES_NUMBER 8
/* Sans compter "None" et "Universal". */
#define MAX_TYPES_NUMBER 9
enum shape_type {
  Type_None = 0,
  Type_1 = 1,
  Type_2 = 2,
  Type_3 = 3,
  Type_4 = 4,
  Type_5 = 5,
  Type_6 = 6,
  Type_7 = 7,
  Type_8 = 8,
  Type_9 = 9,
  Type_Universal = 10
};

#define FU_COLORS_NUMBER 5
/* Sans compter "None" et "Universal". */
#define MAX_COLORS_NUMBER 9
enum shape_color {
  Color_None = 0,
  Color_1 = 1,
  Color_2 = 2,
  Color_3 = 3,
  Color_4 = 4,
  Color_5 = 5,
  Color_6 = 6,
  Color_7 = 7,
  Color_8 = 8,
  Color_9 = 9,
  Color_Universal = 10
};

typedef u8 shape ;   /* Bits 7-4: type, 3-0: couleur. */

#define GET_COLOR(s) ((enum shape_color) (s & 0x0F))
#define GET_TYPE(s) ((enum shape_type) ((s & 0xF0) >> 4))
#define SET_COLOR_TYPE(s,c,t) (s) = (((t) << 4) | (c))
#define SET_COLOR(s,c) (s) = (((s) & 0xF0) | (c))
#define SET_TYPE(s,t) (s) = (((s) & 0x0F) | ((t) << 4))

#define INITIAL_SHAPE_X 4
#define INITIAL_SHAPE_Y 4


enum action {
  Action_Idle,
  Action_Drag
};

struct player {
  u16 player_x ;
  u16 player_y ;
  enum action action ;
};

#define INITIAL_NB_THROWN_ALLOWED 4
#define UNIVERSAL_PROBA 10

#define NUM_PIECES_FOR_RECOVER_1 4

enum game_type { Game_Original, Game_Fu } ;
enum constraint {
  Constraint_None = 0,
  Constraint_Color = 1,
  Constraint_Shape = 2
};

struct game {
  shape board[BOARD_WIDTH][BOARD_HEIGHT] ;
  /* Sert pour le mode Original afin de dterminer quelles cases ont t */
  /* couvertes. On pourrait le dterminer  partir de la map d'affichage */
  /* mais c'est pas propre de mlanger IHM et donnes noyau. Pour la     */
  /* place que a prends, on ne va pas s'en priver ! Et puis on s'en     */
  /* aussi pour re-dessiner l'cran de jeu en sortie d'hibernation.      */
  bool cell_filled_p[BOARD_WIDTH][BOARD_HEIGHT] ;
  /* Sert  dterminer la fin du niveau en mode Fu en mmorisant le  */
  /* nombre de lignes remplies (sans compter plusieurs fois la mme. */
  u8 nb_cleared_lines ;
  /* Sert  dterminer la fin du niveau en mode Fu en mmorisant le    */
  /* nombre de colonnes remplies (sans compter plusieurs fois la mme. */
  u8 nb_cleared_columns ;
  /* Sert  dterminer la fin du niveau en mode Original. */
  u8 nb_cleared_cells ;
  /* Sert  mmoriser le nombre de cases pleines sur chaque ligne. */
  u8 lines_counters[BOARD_HEIGHT] ;
  /* Sert  mmoriser le nombre de cases pleines sur chaque colonne. */
  u8 columns_counters[BOARD_WIDTH] ;
  /* Sert  savoir si une ligne a dj t efface. */
  bool cleared_line_p[BOARD_HEIGHT] ;
  /* Sert  savoir si une colonne a dj t efface. */
  bool cleared_column_p[BOARD_WIDTH] ;
  u8 nb_thrown_allowed ;
  /* Nombre de pices restant  poser avant de rcuprer le droit d'en */
  /* jeter une en mode 'Game_Fu'. */
  u8 recovery_count_down ;
  /* Section dcrivant les proprits de mode de jeu. */
  enum game_type game_type ;
  u8 nb_colors ;
  u8 nb_types ;

  u16 level ;
  enum constraint constraint ;
  struct player player ;
  shape proposed ;
  bool can_fit ;
  u32 score ;
};

#define SCORE_CROSS_DESTRUCTION 75
#define SCORE_NEW_DESTRUCTION 200
#define SCORE_OLD_DESTRUCTION 100
#define SCORE_PIECE_PLACED 20

extern struct game global_game ;
enum mainloop_end { Main_End_Lost, Main_End_Next } ;
struct game *new_game (u16, enum game_type) ;
enum mainloop_end mainloop (struct game*) ;

#endif
