#include <nds.h>
#include <stdlib.h>
#include "gfx_load.h"

void load_palette_tile_map_256 (u16* tiles_base_block_addr,
				u16* map_base_block_addr,
				u16 palette_size,
				const u16 *palette,
				u16 nb_tiles,
				const u8 *tiles,
				u16 map_width,
				u16 map_height,
				const u16 *map,
				enum video_location vloc)
{
  u16 *bg_pal = ((vloc == Video_main) ? BG_PALETTE : BG_PALETTE_SUB) ; 
  u16 i, j, k ;

  /* Palette du fond. */
  if ((palette != NULL) && (palette_size > 0)) {
    for (i = 0; i < palette_size; i++) bg_pal[i] = palette[i] ;
  }

  /* Chargement des tiles du fond d'cran en mmoire. */
  if ((tiles != NULL) && (tiles_base_block_addr != NULL) && (nb_tiles > 0)) {
    k = 0 ;
    for (i = 0; i < nb_tiles * (64 / 2); i++) {
      tiles_base_block_addr[k] =
	(u16) ((tiles[(i * 2) + 1]<< 8) | (tiles[(i * 2)])) ;
      k++ ;
    }
  }

  /* Chargement de la map de fond. */
  if ((map != NULL) && (map_base_block_addr != NULL) && (map_width > 0) &&
      (map_height > 0)) {
    k = 0 ;
    for (j = 0; j < map_height; j++) {          /* Boucle verticale. */
      for (i = 0; i < map_width; i++) {         /* Boucle honrizontale. */
	map_base_block_addr[(j * (256 / 8)) + i] = (u16) map[k] ;
	k++ ;
      }
    }
  }
}



void load_palette_tile_map_16 (u16* tiles_base_block_addr,
			       u16* map_base_block_addr,
			       u16 palette_slot, 
			       u16 palette_size,
			       const u16 *palette,
			       u16 nb_tiles,
			       const u8 *tiles,
			       u16 map_width,
			       u16 map_height,
			       const u16 *map,
			       enum video_location vloc)
{
  u16 *bg_pal = ((vloc == Video_main) ? BG_PALETTE : BG_PALETTE_SUB) ; 
  u16 i, j, k ;

  /* Chargement de la palette de fond en slot demand. */
  if ((palette != NULL) && (palette_size > 0)) {
    i = palette_slot * 16 ;
    for (j = 0; j < palette_size; i++, j++) bg_pal[i] = palette[j] ;
  }

  if ((tiles != NULL) && (tiles_base_block_addr != NULL) && (nb_tiles > 0)) {
    k = 0 ;
    /* Chargement des tiles de fond en mmoire. */
    for (i = 0; i < nb_tiles * (32 / 2); i++) {
      tiles_base_block_addr[k] =
	(u16) ((tiles[(i * 2) + 1] << 8) | (tiles[(i * 2)])) ;
      k++ ;
    }
  }

  /* Chargement de la map de fond. */
  if ((map != NULL) && (map_base_block_addr != NULL) && (map_width > 0) &&
      (map_height > 0)) {
    k = 0 ;
    for (j = 0; j < map_height; j++) {          /* Boucle verticale. */
      for (i = 0; i < map_width; i++) {         /* Boucle honrizontale. */
	map_base_block_addr[(j * (256 / 8)) + i] =
	  (u16) ((map[k]) | (palette_slot << 12)) ;
	k++ ;
      }
    }
  }
}




void load_sprites_16 (u16 offset,  /* Attention, 1 quivaut  2 tiles ! */
		      u16 nb_tiles,
		      const u8 *tiles,
		      u16 palette_slot,
		      u16 palette_size,
		      const u16 *palette,
		      enum video_location vloc)
{
  u16 i, j ;
  u16 *sprites_tiles_memory =
    ((vloc == Video_main) ? SPRITE_GFX : SPRITE_GFX_SUB) ;
  u16 *sprite_palette =
    ((vloc == Video_main) ? SPRITE_PALETTE : SPRITE_PALETTE_SUB) ;

  /* Chargement des tiles. */
  sprites_tiles_memory += offset ;
  if (tiles != NULL) {
    for (i = 0; i < nb_tiles * (32 / 2) ; i++)
      sprites_tiles_memory[i] =
    	(u16) ((tiles[(i * 2) + 1]<< 8) | (tiles[(i * 2)])) ;
  }

  /* Chargement de la palette. */
  if ((palette != NULL) && (palette_size > 0)) {
    i = palette_slot * 16 ;
    for (j = 0; j < palette_size; i++, j++) sprite_palette[i] = palette[j] ;
  }
}



void load_sprites_256 (u16 offset,  /* Attention, 1 quivaut  2 tiles ! */
		       u16 nb_tiles,
		       const u8 *tiles,
		       u16 palette_size,
		       const u16 *palette,
		       enum video_location vloc)
{
  u16 *sprites_tiles_memory =
    ((vloc == Video_main) ? SPRITE_GFX : SPRITE_GFX_SUB) ;
  u16 *sprite_palette =
    ((vloc == Video_main) ? SPRITE_PALETTE : SPRITE_PALETTE_SUB) ;
  u16 i ;

  /* Chargement des tiles. */
  sprites_tiles_memory += offset ;
  if (tiles != NULL) {
    for (i = 0; i < nb_tiles * (64 / 2) ; i++) 
      sprites_tiles_memory[i] =
	(u16) ((tiles[(i * 2) + 1]<< 8) | (tiles[(i * 2)])) ;
  }

  /* Chargement de la palette. */
  if ((palette != NULL) && (palette_size > 0)) {
    for (i = 0; i < palette_size; i++) sprite_palette[i] = palette[i] ;
  }
}
