#include <nds.h>
#include <stdlib.h>
#include <string.h>
#include "gfx_load.h"
#include "bottom_game_bg_gfx.h"
#include "colors_gfx.h"
#include "types_gfx.h"
#include "explo_gfx.h"
#include "target_anim_gfx.h"
#include "top_game_bg_gfx.h"
#include "top_fonts_gfx.h"
#include "top_marks_gfx.h"
#include "top_constraints_gfx.h"
#include "game.h"
#include "printing.h"
#include "throw_anim_gfx.h"
#include "spin_stars_anim_gfx.h"
#include "touch_stars_anim_gfx.h"




struct sSpriteEntry global_sprites_copy[128] ;


static void init_throwing_animation ()
{
  /* On charge la palette des sprites d'explosion. */
  load_sprites_256
    (0,
     0,
     NULL,
     THROW_ANIM_PALETTE_SIZE,
     throw_anim_palette,
     Video_sub) ;
}


void init_exploding_animation ()
{
  /* On charge la palette des sprites d'explosion. */
  load_sprites_256
    (0,
     0,
     NULL,
     EXPLOSION_PALETTE_SIZE,
     exploding_sprite_palette,
     Video_sub) ;
}





void release_exploding_animation ()
{
  /* On recharge la palettes des sprites de forme et de couleur. */
  load_sprites_256
    (0,
     0,
     NULL,
     BOTTOM_GAME_BG_PALETTE_SIZE,
     bottom_game_bg_palette,
     Video_sub) ;
}





void animate_exploding_line (u16 at_y)
{
  short i, j ;

  /* Positionnement des sprites sur la ligne. */
  for (i = 0; i < BOARD_WIDTH; i++) {
    global_sprites_copy[i].attribute[0] =
      ATTR0_COLOR_256 | ATTR0_SQUARE |
      ((BOARD_Y_OFFSET * 8 + at_y * 16) & 0x00FF) ;
    global_sprites_copy[i].attribute[1] =
      ATTR1_SIZE_16 | ((BOARD_X_OFFSET * 8 + i * 16) & 0x01FF) ;
    /* On initialisera l'attribute[2] au cours de la boucle ci-dessous. */
    global_sprites_copy[i].attribute[3] = 0 ;
  }

  /* Animation frame par frame. */
  for (i = 0; i < (NB_EXPLOSION_TILES / NB_TILES_PER_EXPLOSION_FRAME); i++) {
    for (j = 0; j < BOARD_WIDTH; j++)
      global_sprites_copy[j].attribute[2] =
	(FIRST_EXPLOSION_TILE_INDEX + (i * NB_TILES_PER_EXPLOSION_FRAME)) * 2 ;
    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
  }

  /* On dsactive les sprites que l'on a utiliss. */
  for (i = 0; i < BOARD_WIDTH; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;
}





void animate_exploding_column (u16 at_x)
{
  short i, j ;

  /* Positionnement des sprites sur la ligne. */
  for (i = 0; i < BOARD_HEIGHT; i++) {
    global_sprites_copy[i].attribute[0] =
      ATTR0_COLOR_256 | ATTR0_SQUARE |
      ((BOARD_Y_OFFSET * 8 + i * 16) & 0x00FF) ;
    global_sprites_copy[i].attribute[1] =
      ATTR1_SIZE_16 | ((BOARD_X_OFFSET * 8 + at_x * 16) & 0x01FF) ;
    /* On initialisera l'attribute[2] au cours de la boucle ci-dessous. */
    global_sprites_copy[i].attribute[3] = 0 ;
  }

  /* Animation frame par frame. */
  for (i = 0; i < (NB_EXPLOSION_TILES / NB_TILES_PER_EXPLOSION_FRAME); i++) {
    for (j = 0; j < BOARD_HEIGHT; j++)
      global_sprites_copy[j].attribute[2] =
	(FIRST_EXPLOSION_TILE_INDEX + (i * NB_TILES_PER_EXPLOSION_FRAME)) * 2 ;
    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
  }

  /* On dsactive les sprites que l'on a utiliss. */
  for (i = 0; i < BOARD_HEIGHT; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;
}





void setup_gfx ()
{
  u16 old_blending_mode, old_blending_mode_sub ;
  short i ;

  /* cran infrieur. */
  /* Tiles de fond. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (0),   // MAP (2ko aligne) (adresse)
     BOTTOM_GAME_BG_PALETTE_SIZE,
     bottom_game_bg_palette,
     NB_BOTTOM_GAME_BG_TILES,
     bottom_game_bg_tiles,
     BOTTOM_GAME_BG_MAP_WIDTH,
     BOTTOM_GAME_BG_MAP_HEIGHT,
     bottom_game_bg_map,
     Video_sub) ;

  /* Tiles de case termine. */
  load_palette_tile_map_256
    (((u16*) CHAR_BASE_BLOCK_SUB (1)) +
     HOLE_TILES_LOADING_OFFSET,          // TILES (16ko alignes) (adresse)
     NULL,                               // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_HOLE_TILES,
     hole_tiles,
     0,
     0,
     NULL,
     Video_sub) ;

  /* Tiles de couleurs de pices. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (2),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (1),   // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_COLORS_TILES,
     colors_tiles,
     0,                                  // On construira la map  la pogne.
     0,
     NULL,
     Video_sub) ;

  /* Tiles de formes de pices. */
  load_palette_tile_map_256
    (((u16*) CHAR_BASE_BLOCK_SUB (2)) +
     TYPES_TILES_LOADING_OFFSET,         // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (2),   // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_TYPES_TILES,
     types_tiles,
     0,                                  // On construira la map  la pogne.
     0,
     NULL,
     Video_sub) ;

  SUB_BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  SUB_BG1_CR =
      BG_MAP_BASE (1)        // Map (pas adresse).
    | BG_TILE_BASE (2)       // Tiles (pas adresse).
    | BG_PRIORITY_2          // Priorit moins faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  SUB_BG2_CR =
      BG_MAP_BASE (2)        // Map (pas adresse).
    | BG_TILE_BASE (2)       // Tiles (pas adresse).
    | BG_PRIORITY_1          // Priorit leve.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  for (i = 0; i < (32 * 24); i++) {
    /* On efface la map du layer de dessin des blocs  la main. */
    ((u16*) SCREEN_BASE_BLOCK_SUB (1))[i] = (u16) EMPTY_COLOR_TILE_INDEX ;
    ((u16*) SCREEN_BASE_BLOCK_SUB (2))[i] = (u16) EMPTY_TYPE_TILE_INDEX ;
  }

  /* Chargement des tiles de sprites. */
  load_sprites_256
    (COLORS_TILES_LOADING_OFFSET,
     NB_COLORS_TILES,
     colors_tiles,
     BOTTOM_GAME_BG_PALETTE_SIZE,
     bottom_game_bg_palette,
     Video_sub) ;
  load_sprites_256
    (TYPES_TILES_LOADING_OFFSET,
     NB_TYPES_TILES,
     types_tiles,
     0,
     NULL,
     Video_sub) ;
  load_sprites_256
    (EXPLOSION_TILES_LOADING_OFFSET,
     NB_EXPLOSION_TILES,
     exploding_sprite_tiles,
     0,
     NULL,   /* On ne chargera la palette que lorsque l'on en aura besoin. */
     Video_sub) ;
  load_sprites_256
    (TARGET_SPRITE_TILES_LOADING_OFFSET,
     NB_TARGET_SPRITE_TILES,
     target_sprite_tiles,
     0,
     NULL,   /* La palette est celle des sprites de pices. */
     Video_sub) ;
  load_sprites_256
    (THROW_ANIM_TILES_LOADING_OFFSET,
     NB_THROW_ANIM_TILES,
     throw_anim_tiles,
     0,
     NULL,    /* On ne chargera la palette que lorsque l'on en aura besoin. */
     Video_sub) ;
  load_sprites_256
    (SPIN_STARS_ANIM_TILES_LOADING_OFFSET,
     NB_SPIN_STARS_ANIM_TILES,
     spin_stars_anim_tiles,
     0,
     NULL,    /* La palette est celle des sprites de pices. */
     Video_sub) ;
  load_sprites_256
    (TOUCH_STARS_ANIM_TILES_LOADING_OFFSET,
     NB_TOUCH_STARS_ANIM_TILES,
     touch_stars_anim_tiles,
     0,
     NULL,    /* La palette est celle des sprites de pices. */
     Video_sub) ;


  /* On dsactive les sprites. */
  for (i = 0; i < 128; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

  /* cran suprieur. */
  /* Tiles de fond. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (0),   // MAP (2ko aligne) (adresse)
     TOP_GAME_BG_PALETTE_SIZE,
     top_game_bg_palette,
     NB_TOP_GAME_BG_TILES,
     top_game_bg_tiles,
     TOP_GAME_BG_MAP_WIDTH,
     TOP_GAME_BG_MAP_HEIGHT,
     top_game_bg_map,
     Video_main) ;

  /* Tiles des fontes. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (2),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (1),   // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_TOP_FONTS_TILES,
     top_fonts_tiles,
     0,
     0,
     NULL,
     Video_main) ;

  /* Tiles des marqueurs. */
  load_palette_tile_map_256
    (((u16*) CHAR_BASE_BLOCK (2)) +
     TOP_MARKS_TILES_LOADING_OFFSET,    // TILES (16ko alignes) (adresse)
     NULL,                               // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_TOP_MARKS_TILES,
     top_marks_tiles,
     0,                                  // On construira la map  la pogne.
     0,
     NULL,
     Video_main) ;

  /* Tiles des contraintes. */
  load_palette_tile_map_256
    (((u16*) CHAR_BASE_BLOCK (2)) +
     TOP_CONSTRAINTS_TILES_LOADING_OFFSET,   // TILES (16ko alignes) (adresse)
     NULL,                                   // MAP (2ko aligne) (adresse)
     0,
     NULL,
     NB_TOP_CONSTRAINTS_TILES,
     top_constraints_tiles,
     0,                                  // On construira la map  la pogne.
     0,
     NULL,
     Video_main) ;

  BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  BG1_CR =
      BG_MAP_BASE (1)        // Map (pas adresse).
    | BG_TILE_BASE (2)       // Tiles (pas adresse).
    | BG_PRIORITY_2          // Priorit moins faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  for (i = 0; i < (32 * 24); i++) {
    /* On efface la map du layer de dessin des blocs  la main. */
    ((u16*) SCREEN_BASE_BLOCK (1))[i] = (u16) EMPTY_FONT_TILE_INDEX ;
  }

  /* Apparition de l'cran en fading. */
  old_blending_mode = BLEND_CR ;
  old_blending_mode_sub = SUB_BLEND_CR ;
  BLEND_Y = 15 ;
  SUB_BLEND_Y = 15 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;

  videoSetMode (MODE_0_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE) ;
  videoSetModeSub (MODE_0_2D | DISPLAY_BG0_ACTIVE |
		   DISPLAY_BG1_ACTIVE | DISPLAY_BG2_ACTIVE |
		   DISPLAY_SPR_1D_LAYOUT | DISPLAY_SPR_ACTIVE) ;

  for (i = 31; i > 0; i--) {
    swiWaitForVBlank () ;
    BLEND_Y = (u16) (i / 2) ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

}





void refresh_cursor (struct game *game)
{
  static u8 target_frame_counter = 0, frame_anim_delay = 0 ;
  enum shape_type t = GET_TYPE (game->proposed) ;
  enum shape_color c = GET_COLOR (game->proposed) ;
  /* Coordonnes "damier" du joueur. */
  s16 x = (((s16) game->player.player_x + 8) - (BOARD_X_OFFSET * 8)) / 16 ;
  s16 y = (((s16) game->player.player_y + 8) - (BOARD_Y_OFFSET * 8)) / 16 ;

  /* Type. */
  global_sprites_copy[0].attribute[0] =
    ATTR0_COLOR_256 | ATTR0_SQUARE | (game->player.player_y & 0x00FF) ;
  global_sprites_copy[0].attribute[1] =
    ATTR1_SIZE_16 | (game->player.player_x & 0x01FF) ;
  global_sprites_copy[0].attribute[2] =
    (EMPTY_TYPE_TILE_INDEX + (t * NB_TILES_PER_TYPE)) * 2 ;
  global_sprites_copy[0].attribute[3] = 0 ;

  /* Couleur. */
  global_sprites_copy[1].attribute[0] =
    ATTR0_COLOR_256 | ATTR0_SQUARE | (game->player.player_y & 0x00FF) ;
  global_sprites_copy[1].attribute[1] =
    ATTR1_SIZE_16 | (game->player.player_x & 0x01FF) ;
  global_sprites_copy[1].attribute[2] =
    (EMPTY_COLOR_TILE_INDEX + (c * NB_TILES_PER_COLOR)) * 2 ;
  global_sprites_copy[1].attribute[3] = 0 ;

  /* Maintenant, on regarde s'il faut dessiner la cible.*/
  if ((x >= 0) && (y >= 0) && (x < BOARD_WIDTH) && (y < BOARD_HEIGHT)) {
    s16 recomputed_x, recomputed_y ;

    recomputed_x = (x * 16) + (BOARD_X_OFFSET * 8) - 8 ;
    recomputed_y = (y * 16) + (BOARD_Y_OFFSET * 8) - 8 ;
    frame_anim_delay ++ ;

    /*  Temporisation pour laisser le clignottement visible. */
    if ((frame_anim_delay % 4) == 0)
      target_frame_counter = (target_frame_counter + 1) % 2 ;
    frame_anim_delay++ ;

    global_sprites_copy[2].attribute[0] =
      ATTR0_COLOR_256 | ATTR0_SQUARE | (recomputed_y & 0x00FF) ;
    global_sprites_copy[2].attribute[1] =
      ATTR1_SIZE_32 | (recomputed_x & 0x01FF) ;
    global_sprites_copy[2].attribute[2] =
      (FIRST_TARGET_SPRITE_TILE_INDEX +
       (target_frame_counter * NB_TILES_PER_TARGET_FRAME)) * 2 ;
    global_sprites_copy[2].attribute[3] = 0 ;
  }
  else
    global_sprites_copy[2].attribute[0] = ATTR0_DISABLED ;

  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

}





void draw_shape (shape sh, u8 board_x, u8 board_y)
{
  enum shape_type t ;
  enum shape_color c ;
  u16 *colors_map = (u16*) (SCREEN_BASE_BLOCK_SUB (1)) ;
  u16 *types_map = (u16*) (SCREEN_BASE_BLOCK_SUB (2)) ;
  u16 map_index ;
  u16 colors_tile, types_tile ;

  c = GET_COLOR (sh) ;
  t = GET_TYPE (sh) ;

  /* Tile 1. */
  map_index = (((board_y * 2) + BOARD_Y_OFFSET) * (256 / 8)) +
    (BOARD_X_OFFSET + (board_x * 2)) ;
  colors_tile = EMPTY_COLOR_TILE_INDEX + (c * NB_TILES_PER_COLOR) ;
  types_tile = EMPTY_TYPE_TILE_INDEX + (t * NB_TILES_PER_TYPE) ;
  colors_map[map_index] = colors_tile ;
  types_map[map_index] = types_tile ;
  /* Tile 2. */
  map_index++ ;
  colors_tile++ ;
  types_tile++ ;
  colors_map[map_index] = colors_tile ;
  types_map[map_index] = types_tile ;
  /* Tile 3. */
  map_index += (256 / 8) - 1 ;
  colors_tile++ ;
  types_tile++ ;
  colors_map[map_index] = colors_tile ;
  types_map[map_index] = types_tile ;
  /* Tile 4. */
  map_index++ ;
  colors_tile++ ;
  types_tile++ ;
  colors_map[map_index] = colors_tile ;
  types_map[map_index] = types_tile ;
}




void clear_line (u8 at, bool put_hole)
{
  u16 *bg_map = (u16*) (SCREEN_BASE_BLOCK_SUB (0)) ;
  u16 *colors_map = (u16*) (SCREEN_BASE_BLOCK_SUB (1)) ;
  u16 *types_map = (u16*) (SCREEN_BASE_BLOCK_SUB (2)) ;
  u16 map_index ;   /* Index sur la premire ligne. */
  u16 map_index2 ;  /* Index sur la seconde ligne. */
  short x ;

  map_index = (((at * 2) + BOARD_Y_OFFSET) * (256 / 8)) + BOARD_X_OFFSET ;
  map_index2 = (((at * 2) + 1 + BOARD_Y_OFFSET) * (256 / 8)) + BOARD_X_OFFSET ;
  for (x = 0; x < BOARD_WIDTH ; x++) {
    /* Premire tile de la case. */
    colors_map[map_index] = EMPTY_COLOR_TILE_INDEX ;
    colors_map[map_index2] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index] = EMPTY_TYPE_TILE_INDEX ;
    types_map[map_index2] = EMPTY_TYPE_TILE_INDEX ;
    /* Seconde tile de la case. */
    colors_map[map_index + 1] = EMPTY_COLOR_TILE_INDEX ;
    colors_map[map_index2 + 1] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index + 1] = EMPTY_TYPE_TILE_INDEX ;
    types_map[map_index2 + 1] = EMPTY_TYPE_TILE_INDEX ;

    if (put_hole) {
      bg_map[map_index] = HOLE_FIRST_TILE_INDEX ;
      bg_map[map_index2] = HOLE_FIRST_TILE_INDEX + 2 ;
      bg_map[map_index + 1] = HOLE_FIRST_TILE_INDEX + 1 ;
      bg_map[map_index2 + 1] = HOLE_FIRST_TILE_INDEX + 3 ;
    }

    map_index += 2 ;
    map_index2 += 2 ;
    }
}



void clear_column (u8 at, bool put_hole)
{
  u16 *bg_map = (u16*) (SCREEN_BASE_BLOCK_SUB (0)) ;
  u16 *colors_map = (u16*) (SCREEN_BASE_BLOCK_SUB (1)) ;
  u16 *types_map = (u16*) (SCREEN_BASE_BLOCK_SUB (2)) ;
  u16 map_index ;
  short y ;

  map_index = (BOARD_Y_OFFSET * (256 / 8)) + (at * 2) + BOARD_X_OFFSET ;
  for (y = 0; y < BOARD_HEIGHT; y++) {
    /* Premire ligne de la case. */
    /* Premire colonne de la case. */
    colors_map[map_index] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index] = EMPTY_TYPE_TILE_INDEX ;
    /* Seconde colonne de la case. */
    colors_map[map_index + 1] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index + 1] = EMPTY_TYPE_TILE_INDEX ;    
    /* Seconde ligne de la case. */
    /* Premire colonne de la case. */
    colors_map[map_index + (256 / 8)] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index + (256 / 8)] = EMPTY_TYPE_TILE_INDEX ;
    /* Seconde colonne de la case. */
    colors_map[map_index + (256 / 8) + 1] = EMPTY_COLOR_TILE_INDEX ;
    types_map[map_index + (256 / 8) + 1] = EMPTY_TYPE_TILE_INDEX ;

    if (put_hole) {
      bg_map[map_index] = HOLE_FIRST_TILE_INDEX ;
      bg_map[map_index + 1] = HOLE_FIRST_TILE_INDEX + 1 ;
      bg_map[map_index + (256 / 8)] = HOLE_FIRST_TILE_INDEX + 2 ;
      bg_map[map_index + (256 / 8) + 1] = HOLE_FIRST_TILE_INDEX + 3 ;
    }

    map_index += 2 * (256 / 8) ;
  }
}



void refresh_aim_counter (struct game *game)
{
  u8 value = 0 ;

  switch (game->game_type) {
  case Game_Original:
    value = (BOARD_WIDTH * BOARD_HEIGHT) - game->nb_cleared_cells ;
    break ;

  case Game_Fu:
    value = game->level / 3 ;
    if ((game->level % 3) != 0) value++ ;
    value = value - (game->nb_cleared_lines + game->nb_cleared_columns) ;
    break ;
  }

  large_print_int
    (((u16*) SCREEN_BASE_BLOCK (1)), value,
     AIM_X_OFFSET, AIM_Y_OFFSET) ;
}





void refresh_trash_bar (u8 v)
{
  u16 *dest_map = ((u16*) SCREEN_BASE_BLOCK (1)) ;
  u16 *tmp ;
  short i ;

  /* Effacement. */
  tmp = &dest_map[(MARKS_Y_OFFSET * (256 / 8)) + MARKS_X_OFFSET] ;
  for (i = 0; i < 4; i++) {
    *tmp = FIRST_MARK_TILE_INDEX ;
    tmp++ ;
    *tmp = FIRST_MARK_TILE_INDEX ;
    tmp++ ;
  }

  tmp = &dest_map[(MARKS_Y_OFFSET * (256 / 8)) + MARKS_X_OFFSET] ;
  for (i = 0; i < v; i++) {
    *tmp = (i + 1) * 2 + FIRST_MARK_TILE_INDEX ;
    tmp++ ;
    *tmp = (i + 1) * 2 + FIRST_MARK_TILE_INDEX + 1 ;
    tmp++ ;
  }
}





void refresh_constraint_icon (struct game *game)
{
  u16 *dest_map = ((u16*) SCREEN_BASE_BLOCK (1)) ;
  u16 *tmp ;
  u16 tile_index ;
  short y ;

  if (game->game_type == Game_Fu) {
    tile_index =
      (u16) (FIRST_CONSTRAINT_TILE_INDEX +
	     (NB_TILES_PER_CONSTRAINT * game->constraint)) ;
    for (y = 0; y < 3; y++) {
      tmp = &dest_map[((CONSTRAINT_Y_OFFSET + y) * (256 / 8)) +
		      CONSTRAINT_X_OFFSET] ;
      tmp[0] = tile_index ; tile_index++ ;
      tmp[1] = tile_index ; tile_index++ ;
      tmp[2] = tile_index ; tile_index++ ;
    }
  }
}





void redraw_all (struct game *game)
{
  short x, y ;
  u16 *bg_map = (u16*) (SCREEN_BASE_BLOCK_SUB (0)) ;
  u16 map_index ;   /* Index sur la premire ligne. */
  u16 map_index2 ;  /* Index sur la seconde ligne. */


  /* On re-dessine les pices poses et les cases marques. */
  for (y = 0; y < BOARD_HEIGHT; y++) {
    map_index = (((y * 2) + BOARD_Y_OFFSET) * (256 / 8)) + BOARD_X_OFFSET ;
    map_index2 =
      (((y * 2) + 1 + BOARD_Y_OFFSET) * (256 / 8)) + BOARD_X_OFFSET ;
    for (x = 0; x < BOARD_WIDTH; x++) {
      draw_shape (game->board[x][y], x, y) ;
      if (game->cell_filled_p[x][y]) {
	bg_map[map_index] = HOLE_FIRST_TILE_INDEX ;
	bg_map[map_index2] = HOLE_FIRST_TILE_INDEX + 2 ;
	bg_map[map_index + 1] = HOLE_FIRST_TILE_INDEX + 1 ;
	bg_map[map_index2 + 1] = HOLE_FIRST_TILE_INDEX + 3 ;
      }         /* Fin de if (game->cell_filled_p[x][y]). */
      map_index += 2 ;
      map_index2 += 2 ;
    }          /* Fin de for (x = 0; x < BOARD_WIDTH; x++). */
  }            /* Fin de for (y = 0; y < BOARD_HEIGHT; y++). */

  /* Le niveau courant. */
  large_print_int
    (((u16*) SCREEN_BASE_BLOCK (1)), game->level,
     LEVEL_X_OFFSET, LEVEL_Y_OFFSET) ;
  /* Le score courant. */
  large_print_int
    (((u16*) SCREEN_BASE_BLOCK (1)), game->score,
     SCORE_X_OFFSET, SCORE_Y_OFFSET) ;
  /* Le but courant. */
  refresh_aim_counter (game) ;
  /* La trash-bar. */
  refresh_trash_bar (INITIAL_NB_THROWN_ALLOWED - game->nb_thrown_allowed) ;
  /* Et la contrainte courante. */
  refresh_constraint_icon (game) ;
}





void animate_throwing_cursor (struct game *game)
{
  enum shape_type t = GET_TYPE (game->proposed) ;
  enum shape_color c = GET_COLOR (game->proposed) ;
  /* Coordonnes "damier" du joueur. */
  s16 x = SHAPE_POOL_X_AS_PIXELS ;
  s16 y = SHAPE_POOL_Y_AS_PIXELS ;
  short accel = -7 ;

  for (; y < SHAPE_THROW_Y_AS_PIXELS; y += accel) {
    /* Type. */
    global_sprites_copy[0].attribute[0] =
      ATTR0_COLOR_256 | ATTR0_SQUARE | (y & 0x00FF) ;
    global_sprites_copy[0].attribute[1] = ATTR1_SIZE_16 | (x & 0x01FF) ;
    global_sprites_copy[0].attribute[2] =
      (EMPTY_TYPE_TILE_INDEX + (t * NB_TILES_PER_TYPE)) * 2 ;
    global_sprites_copy[0].attribute[3] = 0 ;

    /* Couleur. */
    global_sprites_copy[1].attribute[0] =
      ATTR0_COLOR_256 | ATTR0_SQUARE | (y & 0x00FF) ;
    global_sprites_copy[1].attribute[1] = ATTR1_SIZE_16 | (x & 0x01FF) ;
    global_sprites_copy[1].attribute[2] =
      (EMPTY_COLOR_TILE_INDEX + (c * NB_TILES_PER_COLOR)) * 2 ;
    global_sprites_copy[1].attribute[3] = 0 ;

    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
    accel = min ((accel + 1), 4) ;
  }

  /* Partie "explosion". */
  init_throwing_animation () ;
  global_sprites_copy[1].attribute[0] = ATTR0_DISABLED ;
  for (accel = 0; accel < (NB_THROW_ANIM_TILES/NB_TILES_PER_THROW_ANIM_FRAME);
       accel++) {
    global_sprites_copy[0].attribute[2] =
      (FIRST_THROW_ANIM_TILE_INDEX + (accel * NB_TILES_PER_THROW_ANIM_FRAME))
      * 2 ;
    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
  }
  release_exploding_animation () ;
}





void animate_spin_stars_on_sprite_0 (s16 at_x, s16 at_y)
{
  short i ;

  global_sprites_copy[1].attribute[0] = ATTR0_DISABLED ;
  global_sprites_copy[2].attribute[0] = ATTR0_DISABLED ;

  global_sprites_copy[0].attribute[0] =
    ATTR0_COLOR_256 | ATTR0_SQUARE | (at_y & 0x00FF) ;
  global_sprites_copy[0].attribute[1] = ATTR1_SIZE_16 | (at_x & 0x01FF) ;
  global_sprites_copy[0].attribute[3] = 0 ;

  for (i = 0;
       i < (NB_SPIN_STARS_ANIM_TILES / NB_TILES_PER_SPIN_STARS_ANIM_FRAME) ;
       i++) {
    global_sprites_copy[0].attribute[2] =
      (FIRST_SPIN_STARS_ANIM_TILE_INDEX +
       (i * NB_TILES_PER_SPIN_STARS_ANIM_FRAME)) * 2 ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
  }

  global_sprites_copy[0].attribute[0] = ATTR0_DISABLED ;
}




void animate_touch_stars_on_sprite_0 (s16 at_x, s16 at_y)
{
  short i ;

  global_sprites_copy[1].attribute[0] = ATTR0_DISABLED ;
  global_sprites_copy[2].attribute[0] = ATTR0_DISABLED ;

  global_sprites_copy[0].attribute[0] =
    ATTR0_COLOR_256 | ATTR0_SQUARE | (at_y & 0x00FF) ;
  global_sprites_copy[0].attribute[1] = ATTR1_SIZE_16 | (at_x & 0x01FF) ;
  global_sprites_copy[0].attribute[3] = 0 ;

  for (i = 0;
       i < (NB_TOUCH_STARS_ANIM_TILES / NB_TILES_PER_TOUCH_STARS_ANIM_FRAME) ;
       i++) {
    global_sprites_copy[0].attribute[2] =
      (FIRST_TOUCH_STARS_ANIM_TILE_INDEX +
       (i * NB_TILES_PER_TOUCH_STARS_ANIM_FRAME)) * 2 ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    swiWaitForVBlank () ;
    memcpy
      ((void*) OAM_SUB, (void*) global_sprites_copy,
       128 * sizeof (struct sSpriteEntry)) ;
  }

  global_sprites_copy[0].attribute[0] = ATTR0_DISABLED ;
}
