#include <nds.h>
#include <nds/arm9/sound.h>
#include <string.h>
#include "gfx_load.h"
#include "bottom_intro_gfx.h"
#include "top_intro_gfx.h"
#include "game.h"
#include "scores.h"
#include "wav_screen_touch.h"
#include "wav_selection.h"
#include "ihm.h"
#include "bottom_game_bg_gfx.h"
#include "colors_gfx.h"
#include "types_gfx.h"
#include "explo_gfx.h"
#include "target_anim_gfx.h"
#include "throw_anim_gfx.h"
#include "spin_stars_anim_gfx.h"
#include "touch_stars_anim_gfx.h"




static bool wait_intro_input (enum game_type *gtype_out)
{
  u16 x, y ;
  touchPosition stylus_xy ;

  for (;;) {
    scanKeys() ;

    /* L'appui sur START fair continuer par dfaut. */
    if (keysDown () & (KEY_START)) return (true) ;

    stylus_xy = touchReadXY () ;
    if (keysDown () & KEY_TOUCH) {
      x = stylus_xy.px ;
      y = stylus_xy.py ;

      if ((x >= (BUTTONS_X * 8)) && (x <= ((BUTTONS_X + BUTTONS_WIDTH) * 8))) {
	/* On est positionn sur une abscisse de bouton. */
	if ((y >= BUTTON_ORIGINAL_Y * 8) &&
	    (y < ((BUTTON_ORIGINAL_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_selection, WAV_SELECTION_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  *gtype_out = Game_Original ;
	  return (true) ;                    /* Mode Original. */
	}

	if ((y >= BUTTON_FU_Y * 8) &&
	    (y < ((BUTTON_FU_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_selection, WAV_SELECTION_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  *gtype_out = Game_Fu ;
	  return (true) ;                      /* Mode Fu. */
	}

	if ((y >= BUTTON_SCORES_Y * 8) &&
	    (y < ((BUTTON_SCORES_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_screen_touch, WAV_SCREEN_TOUCH_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  /* Afficher les highscores. */
	  show_scores () ;
	  return (false) ;
	}
      }  /* Fin de if ((x >= (BUTTONS_X * 8)) && (x <= ((BUTTOS_X + BUT ... */
    }    /* Fin de if (keysDown () & KEY_TOUCH). */
  }
}




enum game_type intro ()
{
  enum game_type selected_game_type = Game_Fu ;
  short i ;


  /* Chargement de l'anim des toiles lorsque l'on touche l'cran. */
  load_sprites_256
    (TOUCH_STARS_ANIM_TILES_LOADING_OFFSET,
     NB_TOUCH_STARS_ANIM_TILES,
     touch_stars_anim_tiles,
     BOTTOM_GAME_BG_PALETTE_SIZE,
     bottom_game_bg_palette,
     Video_sub) ;

  /* On dsactive les sprites. */
  for (i = 0; i < 128; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

 dirty_restart_intro:
  /* cran infrieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (0),   // MAP (2ko aligne) (adresse)
     BOTTOM_INTRO_PALETTE_SIZE,
     bottom_intro_palette,
     NB_BOTTOM_INTRO_TILES,
     bottom_intro_tiles,
     BOTTOM_INTRO_MAP_WIDTH,
     BOTTOM_INTRO_MAP_HEIGHT,
     bottom_intro_map,
     Video_sub) ;

  SUB_BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  /* cran suprieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (0),   // MAP (2ko aligne) (adresse)
     TOP_INTRO_PALETTE_SIZE,
     top_intro_palette,
     NB_TOP_INTRO_TILES,
     top_intro_tiles,
     TOP_INTRO_MAP_WIDTH,
     TOP_INTRO_MAP_HEIGHT,
     top_intro_map,
     Video_main) ;

  BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  /* Apparition de l'cran en fading. */
  BLEND_Y = 15 ;
  SUB_BLEND_Y = 15 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;

  videoSetMode (MODE_0_2D | DISPLAY_BG0_ACTIVE) ;
  videoSetModeSub (MODE_0_2D | DISPLAY_BG0_ACTIVE | DISPLAY_SPR_1D_LAYOUT |
		   DISPLAY_SPR_ACTIVE) ;

  for (i = 31; i > 0; i--) {
    swiWaitForVBlank () ;
    BLEND_Y = (u16) (i / 2) ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  BLEND_CR = 0 ;
  SUB_BLEND_CR = 0 ;

  /* Attente d'une slection de mode de jeu. */
  if (wait_intro_input (&selected_game_type) == false)
    goto dirty_restart_intro ;

  /* Disparition de l'cran en fading. */
  BLEND_Y = 0 ;
  SUB_BLEND_Y = 0 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
  for (i = 0; i < 32; i++) {
    swiWaitForVBlank () ;
    BLEND_Y = (u16) (i / 2) ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  BLEND_CR = 0 ;
  SUB_BLEND_CR = 0 ;

  videoSetMode (0) ;
  videoSetModeSub (0) ;

  return (selected_game_type) ;
}
