#include <nds.h>
#include <stdlib.h>
#include <string.h>
#include <nds/arm9/sound.h>
#include "game.h"
#include "gfx_load.h"
#include "persistent.h"
#include "bottom_pause_gfx.h"
#include "bottom_game_bg_gfx.h"
#include "wav_screen_touch.h"
#include "wav_hibernate.h"
#include "ihm.h"



bool wait_for_continue (struct game *game)
{
  u16 x, y ;
  touchPosition stylus_xy ;

  for (;;) {
    scanKeys () ;
    stylus_xy = touchReadXY () ;

    /* Les touches font reprendre par dfaut. */
    if (keysDown () & (KEY_START | KEY_A | KEY_B)) return (true) ;

    if (keysDown () & KEY_TOUCH) {
      x = stylus_xy.px ;
      y = stylus_xy.py ;

      if ((x >= (BUTTONS_X * 8)) && (x <= ((BUTTONS_X + BUTTONS_WIDTH) * 8))) {
	/* On est positionn sur une abscisse de bouton. */
	if ((y >= BUTTON_CONTINUE_Y * 8) &&
	    (y < ((BUTTON_CONTINUE_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_screen_touch, WAV_SCREEN_TOUCH_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  return (true) ;                    /* Continue. */
	}

	if ((y >= BUTTON_ABANDON_Y * 8) &&
	    (y < ((BUTTON_ABANDON_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_screen_touch, WAV_SCREEN_TOUCH_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  return (false) ;                      /* Abandon. */
	}

	if ((y >= BUTTON_HIBERNATE_Y * 8) &&
	    (y < ((BUTTON_HIBERNATE_Y + BUTTONS_HEIGHT) * 8))) {
	  playGenericSound
	    (g_wav_hibernate, WAV_HIBERNATE_LENGTH * sizeof (u32)) ;
	  animate_touch_stars_on_sprite_0 (x - 8, y - 8) ;
	  hibernate_game (game) ;
	  /* Dodo au bout d'1 seconde pour laisser jouer le son ! */
	  for (x = 0 ; x < 90; x++) swiWaitForVBlank () ;
	  powerOFF (POWER_LCD|POWER_2D_A |POWER_2D_B) ;
	  for (;;) ;   /* Inutile mais pour viter que GCC ne geule. */
	}
      }   /* Fin de if ((x >= (BUTTONS_X * 8)) && (x <= ((BUTTOS_X + BUT ... */
    }     /* Fin de if (keysDown () & KEY_TOUCH). */
  }       /* Fin de for (;;). */
}





bool pause_game (struct game *game)
{
  short i ;
  bool continue_game ;
  u32 old_sub_display_mode = SUB_DISPLAY_CR ;

  videoSetModeSub (0) ;

  /* On dsactive les sprites. */
  for (i = 0; i < 128; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

  /* On grise un peu l'cran suprieur (de score). */
  BLEND_Y = 7 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 | BLEND_SRC_BG1 ;

  /* cran infrieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (3),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (3),   // MAP (2ko aligne) (adresse)
     BOTTOM_PAUSE_PALETTE_SIZE,
     bottom_pause_palette,
     NB_BOTTOM_PAUSE_TILES,
     bottom_pause_tiles,
     BOTTOM_PAUSE_MAP_WIDTH,
     BOTTOM_PAUSE_MAP_HEIGHT,
     bottom_pause_map,
     Video_sub) ;

  SUB_BG3_CR =
      BG_MAP_BASE (3)        // Map (pas adresse).
    | BG_TILE_BASE (3)       // Tiles (pas adresse).
    | BG_PRIORITY_0          // Priorit la plus forte.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  /* Apparition de l'cran de requester infrieur en fading. */
  SUB_BLEND_Y = 15 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG3 ;
  videoSetModeSub (MODE_0_2D | DISPLAY_BG3_ACTIVE | DISPLAY_SPR_1D_LAYOUT |
		   DISPLAY_SPR_ACTIVE) ;
  for (i = 31; i > 0; i--) {
    swiWaitForVBlank () ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }
  SUB_BLEND_CR = 0 ;

  continue_game = wait_for_continue (game) ;

  /* Disparition de l'cran de requester infrieur en fading. */
  SUB_BLEND_Y = 0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG3 ;
  for (i = 0; i < 32; i++) {
    swiWaitForVBlank () ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  /* On restaure la palette de l'cran infrieur que l'on avait bute. */
  load_palette_tile_map_256
    (NULL, NULL,
     BOTTOM_GAME_BG_PALETTE_SIZE, bottom_game_bg_palette,
     0, NULL, 0, 0, NULL, Video_sub) ;

  /* On remet les crans  leur luminosits normales. */
  BLEND_CR = 0 ;
  SUB_BLEND_CR = 0 ;

  /* On ractive les layers de jeu normaox. */
  videoSetModeSub (old_sub_display_mode) ;

  return (continue_game) ;
}
