#include <nds.h>
#include <string.h>
#include <stdlib.h>
#include "game.h"
#include "persistent.h"



/* Pour viter d'allouer un gros truc sur la pile. */
static struct save_data tmp_data ;
struct highscores global_highscores = {
  { { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } },
  { { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 0, 0 } }
};



static void bytes_memcpy (u8* dest, u8 const *src, u32 size)
{
  while (size--) *dest++ = *src++ ;
}





void save_scores ()
{
  u16 i ;

  /* It is now safe to write GBA Cartridge memory. */
  WAIT_CR &= ~0x0880 ;

  tmp_data.magic_tag = MAGICNUMBER ;
  tmp_data.seed = rand () ;

  /* On recopie les scores en mmoire temporaire. */
  for (i = 0; i < NB_HIGHSCORES; i++) {
    tmp_data.highscores.original[i].score =
      global_highscores.original[i].score ;
    tmp_data.highscores.original[i].level =
      global_highscores.original[i].level ;
    tmp_data.highscores.fu[i].score = global_highscores.fu[i].score ;
    tmp_data.highscores.fu[i].level = global_highscores.fu[i].level ;
  }

  bytes_memcpy ((u8*) SRAM, (u8 const*) &tmp_data, sizeof (struct save_data)) ;
}



void erase_scores ()
{
  u16 i ;

  for (i = 0; i < NB_HIGHSCORES; i++) {
    global_highscores.original[i].score = 0 ;
    global_highscores.original[i].level = 0 ;
    global_highscores.fu[i].score = 0 ;
    global_highscores.fu[i].level = 0 ;
  }
  save_scores () ;
}




bool read_scores ()
{
  u16 i ;

  /* It is now safe to read GBA Cartridge memory. */
  WAIT_CR &= ~0x0880 ;
  bytes_memcpy ((u8*) &tmp_data, (u8 const*) SRAM, sizeof (struct save_data)) ;

  if (tmp_data.magic_tag != MAGICNUMBER) return (false) ;

  /* On utilise le dernier seed sauv pour rinitialiser le randomizer. */
  srand (tmp_data.seed) ;
  for (i = 0; i < NB_HIGHSCORES; i++) {
    global_highscores.original[i].score =
      tmp_data.highscores.original[i].score ;
    global_highscores.original[i].level =
      tmp_data.highscores.original[i].level ;
    global_highscores.fu[i].score = tmp_data.highscores.fu[i].score ;
    global_highscores.fu[i].level = tmp_data.highscores.fu[i].level ;
  }

  return (true) ;
}





bool check_if_highscore (enum game_type gtype, u32 score, u16 level)
{
  short i, j ;
  struct entry *score_table = NULL ;

  switch (gtype) {
    case Game_Original:
      score_table = &(global_highscores.original[0]) ;
      break ;
    case Game_Fu:
      score_table = &(global_highscores.fu[0]) ;
      break ;
  }

  if (score_table == NULL) return (false) ;
  /* Recherche d'un point d'entre dans la table des highscores. */
  for (i = 0; i < NB_HIGHSCORES; i++) {
    if (score > score_table[i].score) {
      /* Dcalage des scores infrieurs. */
      for (j = (NB_HIGHSCORES - 1); j > i; j--) {
	score_table[j].score = score_table[j - 1].score ;
	score_table[j].level = score_table[j - 1].level ;
      }
      score_table[i].score = score ;
      score_table[i].level = level ;
      return (true) ;
    }
  }    /* Fin de for (i = 0; i < NB_HIGHSCORES; i++). */

  return (false) ;
}




void hibernate_game (struct game *game)
{
  u8 *dest_mem ;
  u32 tag = MAGICNUMBER ;

  /* On commence par sauver les scores. */
  save_scores () ;
  /* On remet un magic number disant qu'il y a un jeu hibern. */
  dest_mem = ((u8*) SRAM) + sizeof (struct save_data) ;
  bytes_memcpy (dest_mem, (u8 const*) &tag, sizeof (u32)) ;
  /* Maintenant, on dumpe l'tat du jeu. */
  dest_mem += sizeof (u32) ;
  bytes_memcpy (dest_mem, (u8 const*) game, sizeof (struct game)) ;
}





struct game* load_hibernated ()
{
  u8 *src_mem ;
  u32 tag ;

  /* It is now safe to read GBA Cartridge memory. */
  WAIT_CR &= ~0x0880 ;

  /* On recherche le premier magic number. */
  src_mem = (u8*) SRAM ;
  bytes_memcpy ((u8*) &tag, src_mem, sizeof (u32)) ;
  if (tag != MAGICNUMBER) return (NULL) ;

  /* On recherche le second magic number. */
  src_mem = ((u8*) SRAM) + sizeof (struct save_data) ;
  bytes_memcpy ((u8*) &tag, src_mem, sizeof (u32)) ;
  if (tag != MAGICNUMBER) return (NULL) ;

  /* On dtruit l'hibernation pour la prochaine fois. */
  tag = 0L ;
  bytes_memcpy (src_mem, (u8 const*) &tag, sizeof (u32)) ;

  /* On charge le jeu hibern. */
  src_mem += sizeof (u32) ;
  bytes_memcpy ((u8*) &global_game, src_mem, sizeof (struct game)) ;

  return (&global_game) ;
}
