#ifndef __PERSISTENT_H__
#define __PERSISTENT_H__

#define TAGTOLONG(a,b,c,d) ((unsigned long)(((a)<<24)|((b)<<16)|((c)<<8)|(d)))
#define MAGICNUMBER TAGTOLONG('F','U','D','O')

#define NB_HIGHSCORES 5
struct entry {
  u32 score ;
  u16 level ;
};

struct highscores {
  struct entry original[NB_HIGHSCORES] ;
  struct entry fu[NB_HIGHSCORES] ;
};

struct save_data {
  u32 magic_tag ;
  int seed ;
  struct highscores highscores ;
};


extern struct highscores global_highscores ;
void save_scores () ;
bool read_scores () ;
bool check_if_highscore (enum game_type, u32, u16) ;
void hibernate_game (struct game*) ;
struct game* load_hibernated () ;
void erase_scores () ;

#endif
