#include <nds.h>
#include <string.h>
#include <stdio.h>
#include "top_fonts_gfx.h"

static void u32toa (u32 x, unsigned char *buffer)
{
  u8 i = 0 ;
  u8 j ;
  unsigned char tmp_c ;
  int div = x ;
  int remain = 0 ;

  if (x == 0) {
    buffer[0] = '0' ;
    buffer[1] = '\0' ;
  }
  else
    {
      while (div != 0) {
	remain = div % 10 ;
	div = div / 10 ;
	buffer [i] = '0' + remain ;
	i++ ;
      }
      buffer[i] = '\0' ;
      i-- ;

      /* Inversion de la chane. */
      for (j = i; i > j / 2; i--) {
	tmp_c = buffer[i] ;
	buffer[i] = buffer[j-i] ;
	buffer[j-i] = tmp_c ;
      }
    }
}



void large_print_int (u16 *dest_map, u32 value, u8 x_tile_offset,
		      u8 y_tile_offset)
{

  u16 tile_on_screen ;
  unsigned char buffer[11] ;
  u8 i ;
  u16 tile_index ;

  u32toa (value, buffer) ;
  i = strlen ((const char*) buffer) ;

  /* On complte le buffer par des espaces. */
  for (; i < 9; i++) buffer[i] = ' ' ;
  buffer[9] = '\0' ;

  for (i = 0; buffer[i] != '\0'; i++) {
    if (buffer[i] == ' ') tile_index = EMPTY_FONT_TILE_INDEX ;
    else
      tile_index =
	ZERO_FONT_TILE_INDEX + ((buffer[i] - '0') * FONT_SIZE_IN_TILES) ;
    /* Premire ligne. */
    tile_on_screen =
      (y_tile_offset * (256 / 8)) /* Offset de ligne. */
      /* 256 : Largeur map en pixels. */
      /* 8 : Nbre pixels par tile. */
      + x_tile_offset + (i * 2) ;  /* Offset de colonne. */
    dest_map[tile_on_screen] = tile_index ;
    tile_on_screen++ ;
    dest_map[tile_on_screen] = tile_index + 1 ;
    /* Seconde ligne. */
    tile_on_screen =
      ((y_tile_offset + 1) * (256 / 8)) /* Offset de ligne. */
      /* 256 : Largeur map en pixels. */
      /* 8 : Nbre pixels par tile. */
      + x_tile_offset + (i * 2) ;  /* Offset de colonne. */
    dest_map[tile_on_screen] = tile_index + 2 ;
    tile_on_screen++ ;
    dest_map[tile_on_screen] = tile_index + 3 ;
  }
}
