#include <nds.h>
#include <nds/arm9/sound.h>
#include <string.h>
#include "gfx_load.h"
#include "top_scores_gfx.h"
#include "bottom_scores_gfx.h"
#include "fonts_scores_gfx.h"
#include "game.h"
#include "printing.h"
#include "persistent.h"
#include "wav_screen_touch.h"
#include "ihm.h"




void show_scores ()
{
  short i ;

  /* On dsactive les sprites. */
  for (i = 0; i < 128; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

  /* cran infrieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (0),   // MAP (2ko aligne) (adresse)
     SCORES_PALETTE_SIZE,
     scores_palette,
     NB_BOTTOM_SCORES_TILES,
     bottom_scores_tiles,
     BOTTOM_SCORES_MAP_WIDTH,
     BOTTOM_SCORES_MAP_HEIGHT,
     bottom_scores_map,
     Video_sub) ;
 
 load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (2),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (1),   // MAP (2ko aligne) (adresse)
     0, NULL,
     NB_FONTS_SCORES_TILES,
     fonts_scores_tiles,
     0, 0, NULL,
     Video_sub) ;

  SUB_BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  SUB_BG1_CR =
      BG_MAP_BASE (1)        // Map (pas adresse).
    | BG_TILE_BASE (2)       // Tiles (pas adresse).
    | BG_PRIORITY_2          // Priorit moins faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  /* cran suprieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (0),   // MAP (2ko aligne) (adresse)
     SCORES_PALETTE_SIZE,
     scores_palette,
     NB_TOP_SCORES_TILES,
     top_scores_tiles,
     TOP_SCORES_MAP_WIDTH,
     TOP_SCORES_MAP_HEIGHT,
     top_scores_map,
     Video_main) ;

 load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (2),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (1),   // MAP (2ko aligne) (adresse)
     0, NULL,
     NB_FONTS_SCORES_TILES,
     fonts_scores_tiles,
     0, 0, NULL,
     Video_main) ;

  BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  BG1_CR =
      BG_MAP_BASE (1)        // Map (pas adresse).
    | BG_TILE_BASE (2)       // Tiles (pas adresse).
    | BG_PRIORITY_2          // Priorit moins faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  for (i = 0; i < (32 * 24); i++) {
    /* On efface la map des layers de texte  la main. */
    ((u16*) SCREEN_BASE_BLOCK_SUB (1))[i] = (u16) EMPTY_FONT_TILE_INDEX ;
    ((u16*) SCREEN_BASE_BLOCK (1))[i] = (u16) EMPTY_FONT_TILE_INDEX ;
  }

 dirty_show_scores_again:
  /* Affichage des scores. */
  for (i = 0; i < NB_HIGHSCORES; i++) {
    /* Mode Original. */
    large_print_int (((u16*) SCREEN_BASE_BLOCK (1)),
		     global_highscores.original[i].score, SCORE_START_X,
		     LINES_START_Y + (i * 3)) ;
    large_print_int (((u16*) SCREEN_BASE_BLOCK (1)),
		     global_highscores.original[i].level, LEVEL_START_X,
		     LINES_START_Y + (i * 3)) ;
    /* Mode Fu. */
    large_print_int (((u16*) SCREEN_BASE_BLOCK_SUB (1)),
		     global_highscores.fu[i].score, SCORE_START_X,
		     LINES_START_Y + (i * 3)) ;
    large_print_int (((u16*) SCREEN_BASE_BLOCK_SUB (1)),
		     global_highscores.fu[i].level, LEVEL_START_X,
		     LINES_START_Y + (i * 3)) ;
  }

  /* Apparition de l'cran en fading. */
  BLEND_Y = 15 ;
  SUB_BLEND_Y = 15 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 | BLEND_SRC_BG1 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 | BLEND_SRC_BG1 ;

  videoSetMode (MODE_0_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE) ;
  videoSetModeSub (MODE_0_2D | DISPLAY_BG0_ACTIVE | DISPLAY_BG1_ACTIVE |
		   DISPLAY_SPR_1D_LAYOUT | DISPLAY_SPR_ACTIVE) ;

  for (i = 31; i > 0; i--) {
    swiWaitForVBlank () ;
    BLEND_Y = (u16) (i / 2) ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  BLEND_CR = 0 ;
  SUB_BLEND_CR = 0 ;

  /* On attend une pression du stylo pour quitter. */
  for (;;) {
    scanKeys () ;
    if ((keysHeld () & (KEY_L | KEY_R | KEY_A | KEY_LEFT)) ==
	(KEY_L | KEY_R | KEY_A | KEY_LEFT)) {
      /* Rinitialisation des scores. */
      erase_scores () ;
      goto dirty_show_scores_again ;
    }
    if (keysDown () & KEY_TOUCH) {
      touchPosition stylus_xy = touchReadXY () ;
      playGenericSound
	(g_wav_screen_touch, WAV_SCREEN_TOUCH_LENGTH * sizeof (u32)) ;
      animate_touch_stars_on_sprite_0 (stylus_xy.px - 8, stylus_xy.py - 8) ;
      break ;
    }
  }

  /* Disparition de l'cran en fading. */
  BLEND_Y = 0 ;
  SUB_BLEND_Y = 0 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 | BLEND_SRC_BG1 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 | BLEND_SRC_BG1 ;
  for (i = 0; i < 32; i++) {
    swiWaitForVBlank () ;
    BLEND_Y = (u16) (i / 2) ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  BLEND_CR = 0 ;
  SUB_BLEND_CR = 0 ;

  videoSetMode (0) ;
  videoSetModeSub (0) ;
}
