#include <nds.h>
#include <string.h>
#include <nds/arm9/sound.h>
#include "gfx_load.h"
#include "neo_tiles_gfx.h"
#include "smile_splash_gfx.h"
#include "wav_screen_touch.h"
#include "game.h"
#include "ihm.h"


void splash_on_bottom_bg0 (u16* dest_tiles, u16* dest_map,
			   u16 palette_size, const u16 *palette,
			   u16 nb_tiles, const u8 *tiles,
			   u16 map_width, u16 map_height,
			   const u16 *map)
{
  short i ;

  /* On dsactive les sprites. */
  for (i = 0; i < 128; i++)
    global_sprites_copy[i].attribute[0] = ATTR0_DISABLED ;
  swiWaitForVBlank () ;
  memcpy
    ((void*) OAM_SUB, (void*) global_sprites_copy,
     128 * sizeof (struct sSpriteEntry)) ;

  /* cran infrieur. */
  load_palette_tile_map_256
    (dest_tiles,     // TILES (16ko alignes) (adresse)
     dest_map,   // MAP (2ko aligne) (adresse)
     palette_size,
     palette,
     nb_tiles,
     tiles,
     map_width,
     map_height,
     map,
     Video_sub) ;

  SUB_BG0_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_3          // Priorit la plus faible.
    | BG_COLOR_256           // 256 couleurs.
    | TEXTBG_SIZE_256x256 ;  // 256 x 256 pixels

  /* Apparition de l'cran en fading. */
  SUB_BLEND_Y = 15 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;

  videoSetModeSub (MODE_0_2D | DISPLAY_BG0_ACTIVE |
		   DISPLAY_SPR_1D_LAYOUT | DISPLAY_SPR_ACTIVE) ;

  for (i = 31; i > 0; i--) {
    swiWaitForVBlank () ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  SUB_BLEND_CR = 0 ;

  /* On attend une pression du stylo pour quitter. */
  for (;;) {
    scanKeys () ;
    if (keysDown () & KEY_TOUCH) {
      touchPosition stylus_xy = touchReadXY () ;
      playGenericSound
	(g_wav_screen_touch, WAV_SCREEN_TOUCH_LENGTH * sizeof (u32)) ;
      animate_touch_stars_on_sprite_0 (stylus_xy.px - 8, stylus_xy.py - 8) ;
      break ;
    }
  }

  /* Disparition de l'cran en fading. */
  SUB_BLEND_Y = 0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG0 ;
  for (i = 0; i < 32; i++) {
    swiWaitForVBlank () ;
    SUB_BLEND_Y = (u16) (i / 2) ;
  }

  SUB_BLEND_CR = 0 ;

  videoSetModeSub (0) ;
}




#define set_mosaic_mode_sub(bh,bv,oh,ov) \
    SUB_MOSAIC_CR = ((bh)|((bv)<<4)|((oh)<<8)|((ov)<<12))
#define set_mosaic_mode(bh,bv,oh,ov) \
    MOSAIC_CR = ((bh)|((bv)<<4)|((oh)<<8)|((ov)<<12))

void splash_neo ()
{
  short i ;

  /* cran infrieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK_SUB (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK_SUB (0),   // MAP (2ko aligne) (adresse)
     NEO_PALETTE_SIZE,
     neo_palette,
     NB_NEO_TILES,
     neo_tiles,
     NEO_MAP_WIDTH,
     NEO_MAP_HEIGHT,
     neo_map,
     Video_sub) ;

  SUB_BG2_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_0          // Priorit la plus forte.
    | BG_COLOR_256           // 256 couleurs.
    | ROTBG_SIZE_256x256    // 256 x 256 pixels avec rotation/scaling
    | BG_MOSAIC_ON ;


 /* cran suprieur. */
  load_palette_tile_map_256
    ((u16*) CHAR_BASE_BLOCK (1),     // TILES (16ko alignes) (adresse)
     (u16*) SCREEN_BASE_BLOCK (0),   // MAP (2ko aligne) (adresse)
     SMILE_SPLASH_PALETTE_SIZE,
     smile_splash_palette,
     NB_SMILE_SPLASH_TILES,
     smile_splash_tiles,
     SMILE_SPLASH_MAP_WIDTH,
     SMILE_SPLASH_MAP_HEIGHT,
     smile_splash_map,
     Video_main) ;

  BG2_CR =
      BG_MAP_BASE (0)        // Map (pas adresse).
    | BG_TILE_BASE (1)       // Tiles (pas adresse).
    | BG_PRIORITY_0          // Priorit la plus forte.
    | BG_COLOR_256           // 256 couleurs.
    | ROTBG_SIZE_256x256    // 256 x 256 pixels avec rotation/scaling
    | BG_MOSAIC_ON ;


  set_mosaic_mode_sub (15, 15, 0, 0) ;
  set_mosaic_mode (15, 15, 0, 0) ;
  videoSetMode (MODE_1_2D | DISPLAY_BG2_ACTIVE) ;
  videoSetModeSub (MODE_1_2D | DISPLAY_BG2_ACTIVE) ;

  for (i = 31; i >= 0; i--) {
    swiWaitForVBlank () ;
    set_mosaic_mode_sub (i/2, i/2, 0, 0) ;
    set_mosaic_mode (i/2, i/2, 0, 0) ;
  }

  /* On supprime l'effet de mosaique. */
  SUB_BG2_CR = SUB_BG2_CR & (~BG_MOSAIC_ON) ;
  BG2_CR = BG2_CR & (~BG_MOSAIC_ON) ;

  /* On attend une pression du stylo pour quitter. */
  for (;;) {
    scanKeys () ;
    if (keysDown () & KEY_TOUCH) break ;
  }
 
  /* Disparition des crans en fading. */
  SUB_BLEND_Y = 0 ;
  BLEND_Y = 0 ;
  SUB_BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG2 ;
  BLEND_CR = BLEND_FADE_BLACK | BLEND_SRC_BG2 ;
  for (i = 0; i < 32; i++) {
    swiWaitForVBlank () ;
    SUB_BLEND_Y = (u16) (i / 2) ;
    BLEND_Y = (u16) (i / 2) ;
  }

  SUB_BLEND_CR = 0 ;

  videoSetMode (0) ;
  videoSetModeSub (0) ;
}
