// Includes
#include <PA9.h>       // Include for PA_Lib
#include <fat.h>
#include <sys/dir.h>
#include <stdio.h>
#include <sys/stat.h>
#include "nds_loader_arm9.h"
#include <unistd.h>
#include <stdlib.h>
#include <math.h>

#include "gfx/all_gfx.c"
#include "gfx/all_gfx.h"

int GetFilenameToLoad(void);
void GetFileList(void);
int filetype(const char *filename, const char *extention);
void readheader(const char *filename,int file_number);
void show_time(void);
int Day(int day,int month,int year);
void bootGBAMPnds(char *filename);
int HexToDec(int num);
void load_ini_file(void);
void play_mod(char * filename);
void load_bmp_4_sprite(u8 sprite_number, char *filename);
void readid3(char *filename,int file_number);
char *trim_right( char *szSource );
int len(char *str1); // length of string
void load_bottom(void);
void line(int x0, int y0, int x1, int y1, int pix); // for drawing lines on 16c layer
void boot_gba(void);
void load_gba_frame(int screen);
int EMC_Playback(char * filename, u8 screen, u8 interruptme);
void fadetoblack();
void fadefromblack();
void fadetowhite();
void fadefromwhite();


inline void PA_Shutdown()
{
IPC->aux |= BIT(6); // libnds arm7 code: #define PM_POWER_DOWN BIT(6)
}

// Functions
void show_text_file(char* filename, long length_of_file);
void giffromfat(u8 sprite_number, char *filename); // sprite_number represents the icon to be loaded, not the hardware sprite number
int len(char *str1);
void left(char *str1, char * str2, int num);

// for loading jpg...
unsigned short screen_bitmap[49152];
inline void PA_load_jpg(u8 screen, void *jpeg) {
	REG_IME = 0x00;
	JPEG_DecompressImage((u8*)jpeg, screen_bitmap, 256, 192);
	REG_IME = 0x01;	
}

#define boolean int
//	int number_zoom=-1;

// stuff for .ini loading
boolean initIniFile(char *filename);
void closeIniFile();
boolean seekLine(char *line, char *param);
char* readIniFileString(char *param);
int readIniFileInt(char *param);
boolean fileLocator(char *start, char *target, boolean isDir, int depth, char *result);
FILE* iniFile;

// the three 'quick' folders
char* folder1;
char* folder2;
char* folder3;
// shortcuts in the top bar
char* short1;
char* short2;
char* short3;
char* short4;
char* short5;
char* short6;
char* short7;
char* short8;
int short_number;
int quick_number=0;
int clocktype;
int emc_screen;
char * startup;

	char tag[3];
	char songname[30];
	char artist[30];
	char album[30];
	char year[4];
	char comment[30];
	char genre[1];

char genre_name[127][30]={
"Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge",
"Hip-Hop","Jazz","Metal","New Age","Oldies","Other","Pop","R&B",
"Rap","Reggae","Rock","Techno","Industrial","Alternative","Ska",
"Death Metal","Pranks","Soundtrack","Euro-Techno","Ambient",
"Trip-Hop","Vocal","Jazz+Funk","Fusion","Trance","Classical",
"Instrumental","Acid","House","Game","Sound Clip","Gospel",
"Noise","AlternRock","Bass","Soul","Punk","Space","Meditative",
"Instrumental Pop","Instrumental Rock","Ethnic","Gothic",
"Darkwave","Techno-Industrial","Electronic","Pop-Folk",
"Eurodance","Dream","Southern Rock","Comedy","Cult","Gangsta",
"Top 40","Christian Rap","Pop/Funk","Jungle","Native American",
"Cabaret","New Wave","Psychadelic","Rave","Showtunes","Trailer",
"Lo-Fi","Tribal","Acid Punk","Acid Jazz","Polka","Retro",
"Musical","Rock & Roll","Hard Rock","Folk","Folk-Rock",
"National Folk","Swing","Fast Fusion","Bebob","Latin","Revival",
"Celtic","Bluegrass","Avantgarde","Gothic Rock","Progressive Rock",
"Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band",
"Chorus","Easy Listening","Acoustic","Humour","Speech","Chanson",
"Opera","Chamber Music","Sonata","Symphony","Booty Bass","Primus",
"Porn Groove","Satire","Slow Jam","Club","Tango","Samba",
"Folklore","Ballad","Power Ballad","Rhythmic Soul","Freestyle",
"Duet","Punk Rock","Drum Solo","Acapella","Euro-House","Dance Hall"};

u16 spritepal[16]; // temp palette for sprite
// some global variable to be loaded from the ini
int clockx = 147; // clock X
int clocky = 51; // clock Y

// the struct to hold the filenames
typedef struct
{
	char name[255]; // then name of the file
	u8 isDirectory; // is it a file or directory?
	int sprite; // what sprite number to use
	int x; // X location
	int zoom; // zoom value
	long size; // size in bytes (characters) of file
}DirEntry;
DirEntry FileNames[50];
int NumberOfFiles=0;
int max_files=50;
typedef struct
{
   char image[512]; // for icon sprite
   unsigned short palette[16]; // icon palette
   char data[512]; // title information
	int has_icon; // if no icon, use a default one
	u8 used; // is this sprite used already?
	int filenumber; // what file is represented by this icon?
}Sprite_Entry;
Sprite_Entry Sprite[5]; // We will only use 5 sprites on screen
u8 col1; // toutch screen text
u8 col2; // top screen text
u8 col3; // clock seconds
u8 col4; // clock led dim
u8 col5; // clock led lit
unsigned short pale[16]; // same as icon palette
int half_way;

// Variables for the mp3 player
FILE* infile;		// File handle of the mp3 file
// Memtest options
#define DO_MEMTEST
#define MEMTESTVALUE 42
// FAT test options
#define TESTDATASIZE (1024*32)
char test[TESTDATASIZE];

//char stylus_lasthit; // when the last stylus press was
char stylus_lastx; // where the last stylus press was
char stylus_lasty;

// For EMC video playback
struct VIDEO_HEADER
{
  char		magic[8];
  u32		framecount;
  u16		samplesize;
  u16		finalsample;
  u16		frametype;
  char		reserved[14];
} vidhead;



// Function: main()
int main(int argc, char ** argv)
{
//
	
	PA_Init();    				// Initializes PA_Lib
	PA_InitVBL(); 				// Initializes a standard VBL

//	PA_Init8bitBg(1, 3); 	// Init a 8 bit Bg on screen 1	
	fatInitDefault();

load_ini_file();

	struct stat st;
// If we are holding 'Right' then check for autorun.nds
if(Pad.Held.Right)
{
//	char DEFAULT_FILE[] = "autorun.nds";
	if (stat (startup, &st) >= 0) {
		runNdsFile (startup);
	}
}
//	fadefromwhite();
	fadetoblack();
	PA_EasyBgLoad(1,3,t_splash);
	PA_EasyBgLoad(0,3,b_splash);
	fadefromblack();
	PA_WaitFor(Pad.Newpress.Start || Stylus.Newpress);
	fadetoblack();
	PA_ResetBgSys();
	fadefromblack();

	PA_Init16bitBg(0, 3);
	PA_Init16bitBg(1, 3);


	PA_InitWifi();					// NECCESSARY!!! Don't forget! for mp3 playing
	PA_InitMP3(); // mp3 setup
	PA_InitSound(); // raw playing

	PA_Init16cBg(0, 2); // 16 color background init with default colors for text
	PA_Init16cBg(1, 2); // 16 color background init with default colors for text


	int temp=0;
	for(temp=0; temp<50; temp++)
	{
	   FileNames[temp].sprite=-1;
	} 
	
	
	
	while(!filetype(FileNames[temp].name,".nds"))
	{		  
		temp=GetFilenameToLoad();
//		if(filetype(FileNames[temp].name,".txt"))
//		{
//		   show_text_file("FileNames[temp].name",FileNames[temp].size);
//		}		
	}


			fadetowhite();
			memset(top_Bitmap,0,49152);	// set the top image to 0
			memset(bottom_Bitmap,0,49152);// set the bottom image to 0
			PA_SetBgPalCol(0, 0, PA_RGB(31, 31, 31)); // set color 0 to white
			PA_SetBgPalCol(1, 0, PA_RGB(31, 31, 31)); // set color 0 to white
			PA_Load16bitBitmap(1, top_Bitmap); // Show image on top screen
			PA_Load16bitBitmap(0, bottom_Bitmap); // Show image on top screen
			int temp1;
			for(temp1=0; temp1<5; temp1++)
			{
			   PA_DeleteSprite(0,temp1);// delete the icons
			   if(temp1<5){PA_DeleteSprite(1,temp1);}// delete the closk
			}

			PA_SetBrightness(0, 0);
			PA_SetBrightness(1, 0);

//			struct stat st;
			stat("/.", &st); 
			int device_id = st.st_dev;

			if(device_id==1178816589)// = 46 43 50 4D = FCPM (Media Player Compact Flash)
			{
			   bootGBAMPnds(FileNames[temp].name);
			}else{   
			   runNdsFile(FileNames[temp].name);
			}   
	while(1)
	{
		PA_WaitForVBL();   
	}			
} // End of main()


int GetFilenameToLoad(void)
{

   // set up the 6 sprites we need for the icons
   int temp;
	for(temp=0; temp<5; temp++)
	{
	      PA_CreateSprite(0, temp,(void*)Blank,OBJ_SIZE_32X32,0,temp,320,192);
	  PA_SetSpriteDblsize(0, temp, 1); // enable double size
	PA_SetSpriteRotEnable(0, temp, temp); // enable rotation
	Sprite[temp].used=0;
	}

	// set a sprite for each icon reflection
	for(temp=0; temp<5; temp++)
	{
	      PA_CreateSprite(0, temp+6,(void*)Blank,OBJ_SIZE_32X32,0,temp,320,192);
	  PA_SetSpriteDblsize(0, temp+6, 1); // enable double size
	PA_SetSpriteRotEnable(0, temp+6, temp+6); // enable rotation

	PA_SetSpriteMode(0,temp+6,1); // Alphablending
	}



	// Enable the alpha-blending
	PA_EnableSpecialFx(0, // Screen
						SFX_ALPHA, // Alpha blending mode
						0, // Nothing
						SFX_BG0 | SFX_BG1 | SFX_BG2 | SFX_BG3 | SFX_BD); // Everything normal

		PA_SetSFXAlpha(0, // Screen
						4, // Alpha level, 0-15
						15); // Leave this to 15
	

load_bottom();

// we reserve below 10 for loading direct to sprites (e.g. filename.nds.gif)
 giffromfat(10,"fat:/menu_skin/1.gif"); // 10 = parent
 giffromfat(11,"fat:/menu_skin/2.gif"); // 11 = folder
 giffromfat(12,"fat:/menu_skin/3.gif"); // 12 = nds file
 giffromfat(13,"fat:/menu_skin/4.gif"); // 13 = music file
 giffromfat(14,"fat:/menu_skin/5.gif"); // 14 = txt file
 giffromfat(15,"fat:/menu_skin/6.gif"); // 14 = movie file




   
   // After we have the background images, we will use them to fint the colours
   // for the other elements in the menu.
//	col1 = 255;//bottom_Bitmap[256*191]; // get the colour in the bottom left of the image
//	col2 = 255;//top_Bitmap[256*191]; // get the colour in the bottom left of the image
//	col3 = 254;

//		PA_SetBgPalCol(1, 254, PA_RGB(0,26,31)); // set the ds palette accordingly
//		PA_SetBgPalCol(1, 255, PA_RGB(0,0,0)); // set the ds palette accordingly
//		PA_SetBgPalCol(0, 255, PA_RGB(31,31,31)); // set the ds palette accordingly

//147
if(clocktype==1)
{
PA_CreateSprite(1, 0,(void*)digit_Sprite,OBJ_SIZE_16X32,0,0,clockx+14,clocky+38);
PA_CreateSprite(1, 1,(void*)digit_Sprite,OBJ_SIZE_16X32,0,0,clockx+32,clocky+38);
PA_CreateSprite(1, 2,(void*)digit_Sprite,OBJ_SIZE_16X32,0,0,clockx+54,clocky+38);
PA_CreateSprite(1, 3,(void*)digit_Sprite,OBJ_SIZE_16X32,0,0,clockx+72,clocky+38);
PA_LoadSprite16cPal(1,0,(void*)pale);	// Palette name
}
	GetFileList();

	// Put the menu controles ans animation here.
	// We will start with a simple list
	int FileNumber=0; // the item number in the list
	int finished=0;
	int aimx=0,temp2,yy=0,stylus_offset=0;
	float y=-128;
	int file_to_load=0;
	int current_frame=0;
	
	 	infile = fopen("fat:/menu_skin/startup.mp3", "rb");
	if(infile)PA_PlayMP3(infile);	// the parameter must be an opened file handle

//giffromfat(20,10, "1.gif");


	while(!finished)
	{

	if(Stylus.Newpress && Stylus.Y>128)
	{
		stylus_offset = Stylus.X + y;
		stylus_lastx = Stylus.X;
		stylus_lasty = Stylus.Y;
	}			   

	if(Stylus.Held && Stylus.Y>128)
	{
	  yy = stylus_offset - Stylus.X;
	  y = yy;
	  FileNumber = ((stylus_offset-Stylus.X)+16)/32;
	  if(FileNumber>NumberOfFiles-1){FileNumber=NumberOfFiles-1;}
	  if(FileNumber<0){FileNumber=0;}
	}   



	if(Stylus.Released)
	{
	   if(Stylus.Downtime<10)
	   {
		 int sx=Stylus.X; int sy=Stylus.Y;
			if(stylus_lastx/8 == sx/8 && stylus_lasty/8 == sy/8)
			{
				 if(sx>= 95 && sx<= 160 && sy>= 121 && sy<= 186)
				 {
				    if(FileNames[FileNumber].isDirectory==0){finished=1;}
				    if(FileNames[FileNumber].isDirectory==1)
			    {
			    	chdir(FileNames[FileNumber].name);
			    	GetFileList();
			    	y=-128;
			    	FileNumber=0;
			    }
			    if(FileNames[FileNumber].isDirectory==2)
			    {
			   	PA_StopMod();
					PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
					fclose(infile);	// close the mp3
			   	play_mod(FileNames[FileNumber].name);
			    }
			    if(FileNames[FileNumber].isDirectory==3)
			    {
			   	PA_StopMod();
					PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
					fclose(infile);	// close the mp3
					infile = fopen(FileNames[FileNumber].name, "rb");
					PA_PlayMP3(infile);	// the parameter must be an opened file handle
			    }		    
			    if(FileNames[FileNumber].isDirectory==4)
			    {
			   	PA_StopMod();
					PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
					fclose(infile);	// close the mp3
			   	show_text_file(FileNames[FileNumber].name,FileNames[FileNumber].size);
			    }			    
			    if(FileNames[FileNumber].isDirectory==5)
			    {
			   PA_StopMod();
				PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
				fclose(infile);	// close the mp3
				for(temp=0; temp<12; temp++)
				{
					PA_SetSpriteXY(0,temp,256,0); // move al the sprites off screen
				}			
				PA_Clear16bitBg(0);
				PA_Clear16bitBg(1);
				PA_16cErase(0); // clear text on bottom screen
				PA_16cErase(1); // clear text on top screen

				EMC_Playback(FileNames[FileNumber].name,emc_screen,0);
				load_bottom(); // reload the screens from fat
			    }			    
			}		    
		 }		    
		}		 
	}

	if(Stylus.Newpress || Stylus.Downtime/15==1)
	{
	 Stylus.Downtime=0;
	 int sx=Stylus.X; int sy=Stylus.Y;

	// shortcut1
	 if(sx>=0 && sx<32 && sy<16)
	 {if(strcmp(short1, "gba")==0){boot_gba();}else{if(strcmp(short1, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short1);}else{runNdsFile(short1);}}}}
	// shortcut2 
	 if(sx>=32 && sx<64 && sy<16)
	 {if(strcmp(short2, "gba")==0){boot_gba();}else{if(strcmp(short2, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short2);}else{runNdsFile(short2);}}}}
	// shortcut3
	 if(sx>=64 && sx<96 && sy<16)
	{if(strcmp(short3, "gba")==0){boot_gba();}else{if(strcmp(short3, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short3);}else{runNdsFile(short3);}}}}
	// shortcut4
	 if(sx>=96 && sx<128 && sy<16)
	{if(strcmp(short4, "gba")==0){boot_gba();}else{if(strcmp(short4, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short4);}else{runNdsFile(short4);}}}}
	// shortcut5
	 if(sx>=128 && sx<160 && sy<16)
	{if(strcmp(short5, "gba")==0){boot_gba();}else{if(strcmp(short5, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short5);}else{runNdsFile(short5);}}}}
	// shortcut6
	 if(sx>=160 && sx<192 && sy<16)	
	 {if(strcmp(short6, "gba")==0){boot_gba();}else{if(strcmp(short6, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short6);}else{runNdsFile(short6);}}}}

	// shortcut7
	 if(sx>=192 && sx<224 && sy<16)
	 {if(strcmp(short7, "gba")==0){boot_gba();}else{if(strcmp(short7, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short7);}else{runNdsFile(short7);}}}}
	// shortcut8
	 if(sx>=224 && sx<256 && sy<16)
	 {if(strcmp(short8, "gba")==0){boot_gba();}else{if(strcmp(short8, "power")==0){IPC->aux |= BIT(6);}else{struct stat st;	stat("/.", &st); int device_id = st.st_dev; if(device_id==1178816589)
		 {bootGBAMPnds(short8);}else{runNdsFile(short8);}}}}
	}   
		

	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==0)finished=1;

	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==2)
		{
		   PA_StopMod();
			PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
			fclose(infile);	// close the mp3
		   play_mod(FileNames[FileNumber].name);
		}
	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==3)
		{
		   PA_StopMod();
			PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
			fclose(infile);	// close the mp3
			infile = fopen(FileNames[FileNumber].name, "rb");
			PA_PlayMP3(infile);	// the parameter must be an opened file handle
		}

	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==4)
		{
		   PA_StopMod();
			PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
			fclose(infile);	// close the mp3
		   show_text_file(FileNames[FileNumber].name,FileNames[FileNumber].size);
		}

	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==5) // emc video playback
		{
		   PA_StopMod();
			PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
			fclose(infile);	// close the mp3
			for(temp=0; temp<12; temp++)
			{
				PA_SetSpriteXY(0,temp,256,0); // move al the sprites off screen
			}			
			PA_Clear16bitBg(0);
			PA_Clear16bitBg(1);
			PA_16cErase(0); // clear text on bottom screen
			PA_16cErase(1); // clear text on top screen

			EMC_Playback(FileNames[FileNumber].name,emc_screen,0);
//			PA_Clear16bitBg(0); // clear the screen to remove movie
//			PA_Clear16bitBg(1); //
			load_bottom(); // reload the screens from fat
		}


//					PA_SmartText(1,0,0,182,240,"main loop",1,1,3,100);

		if(Pad.Newpress.X)
		{
		   PA_StopMod();
			PA_StopMP3();		// this does nothing to the file handle - don't forget to close it!
			fclose(infile);	// close the mp3
		}

	   if(Pad.Newpress.A && FileNames[FileNumber].isDirectory==1)
	   {
	    chdir(FileNames[FileNumber].name);
	    GetFileList();
	    y=-128;
	    FileNumber=0;
	   }   
	 
	if(Pad.Newpress.Right && FileNumber<NumberOfFiles-1){FileNumber++;}
	if(Pad.Newpress.Left && FileNumber>0){FileNumber--;}
	if(Pad.Newpress.Down)
	 {
	  if(FileNumber<half_way){FileNumber=half_way;}
	 else{
	  FileNumber=NumberOfFiles-1;  
	 }}   
	if(Pad.Newpress.Up)
	 {
	  if(FileNumber>half_way){FileNumber=half_way;}
	 else{
	  FileNumber=0;  
	 }}

	 if(Pad.Newpress.B)
	 {      
	    if(FileNames[0].isDirectory==1 && strcmp(FileNames[0].name, "..")==0)// are we in a folder?
      {
       chdir("..");
       GetFileList();
       FileNumber=0; // shoot back to the start.
		 y=-128; // should scroll backwards through the file list on startup.
		}   
		}// if B pressed

	if(Pad.Newpress.R)
	{
	 quick_number++;
	 if(quick_number==3){quick_number=0;}

		if(quick_number==0){chdir(folder1);}
		if(quick_number==1){chdir(folder2);}
		if(quick_number==2){chdir(folder3);}
       GetFileList();
       FileNumber=0; // shoot back to the start.
		 y=-128; // should scroll backwards through the file list on startup.
	}   
	if(Pad.Newpress.L)
	{
	 quick_number--;
	 if(quick_number==-1){quick_number=2;}

		if(quick_number==0){chdir(folder1);}
		if(quick_number==1){chdir(folder2);}
		if(quick_number==2){chdir(folder3);}
       GetFileList();
       FileNumber=0; // shoot back to the start.
		 y=-128; // should scroll backwards through the file list on startup.
	}   

//if(Pad.Held.Select && Pad.Held.Start){boot_gba();}



// Animate the dock!
//if(!Stylus.Held)
//{
	aimx = FileNumber * 32; // each icon is 32pixels
	y = y - ((y-aimx)/16); // should scroll to 32 pixels
	yy = y;
	if(yy == aimx - 1 || yy == aimx + 1)
	{
  	 yy = aimx;
	}   
//}

////////////////////////////////////////////////////////////////////////////////////////////////////
int screen = yy - 96; // half screen-32

for(temp=0; temp<=NumberOfFiles-1; temp++)
{
	int yo=FileNames[temp].x+(FileNames[temp].x-y);

	int number_zoom=-1;
	if(yo-screen<-64 || yo-screen>256)// is the icon supposed to be onscreen?
	{ 
		Sprite[FileNames[temp].sprite].used=0;								// This line
		FileNames[temp].sprite=-1;
	}
	if(yo-screen>-64 && yo-screen<256)// is the icon supposed to be onscreen?
	{ 
		if(FileNames[temp].sprite==-1)
		{
			number_zoom=-1;
			for(temp2=0; temp2<5; temp2++)
			{
				if(Sprite[temp2].used==0)
				{
				   number_zoom=temp2; //if unused sprite, number it			   
				}   
			}			   
			if(number_zoom>-1) // if theres an unused sprite, use it
			{
				int isback=0;
				Sprite[number_zoom].used=1;								// And this line
				Sprite[number_zoom].filenumber=temp;	// tells the sprite which file it is
			 	FileNames[temp].sprite=number_zoom; // sprite uses free slot
				 	// while were off screen, load the icon
				if(FileNames[temp].isDirectory==1)// If a folder, give it the folder icon
				{
					DMA_Copy(folder_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
					DMA_Copy(folder_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);

					if(strcmp(FileNames[temp].name,"..")==0)
					{	// If we are the back folder (..) then use a nice 'back' icon
						DMA_Copy(folder_back_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
						DMA_Copy(folder_back_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);
						isback=1;
					}   
				}   

				if(FileNames[temp].isDirectory==0)// If a file, load it's icon
				{
					// If we are a program file, try to use the icon header info
					char * gifname;
					left(gifname, FileNames[temp].name, len(FileNames[temp].name)-4);
					strcat(gifname, ".gif");
//					FILE* temp_file = fopen (gifname, "rb"); //rb=read gif=Variable fr Grafikdateinamen
//					if(temp_file)
//					{
						//giffromfat(12, gifname); // change default icon to current icon
//						fclose (temp_file);
//					}			
//					PA_16cText(0, 0, 0, 246, 45, gifname, 1, 2, 30);
					readheader(FileNames[temp].name,number_zoom); // read the files icon and if needed replace it.
				}		
				if(FileNames[temp].isDirectory==2)// If a mod
				{
					DMA_Copy(music_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
					DMA_Copy(music_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);
				}		
				if(FileNames[temp].isDirectory==3)// If an MP3
				{
					readid3(FileNames[temp].name,number_zoom);
					DMA_Copy(music_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
					DMA_Copy(music_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);
				}		
				if(FileNames[temp].isDirectory==4)// If a txt
				{
					DMA_Copy(text_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
					DMA_Copy(text_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);
				}		
				if(FileNames[temp].isDirectory==5)// If a emc (video)
				{
					DMA_Copy(movie_Sprite, Sprite[number_zoom].image, 256, DMA_16NOW);
					DMA_Copy(movie_Pal, Sprite[number_zoom].palette, 16, DMA_16NOW);
				}		

						PA_UpdateSpriteGfx(0,number_zoom,Sprite[number_zoom].image);    
						PA_LoadSprite16cPal(0,number_zoom,(void*)Sprite[number_zoom].palette);
					// reflection
					PA_UpdateSpriteGfx(0,number_zoom+6,Sprite[number_zoom].image);    
					PA_LoadSprite16cPal(0,number_zoom+6,(void*)Sprite[number_zoom].palette);

					//giffromfat(number_zoom,number_zoom,"1.gif");
//					if(FileNames[temp].isDirectory==0){giffromfat(number_zoom,number_zoom,"fat:/3.gif");} // NDS
//					if(FileNames[temp].isDirectory==1){giffromfat(number_zoom,number_zoom,"fat:/2.gif");} // Folder
//					if(FileNames[temp].isDirectory==2){giffromfat(number_zoom,number_zoom,"fat:/4.gif");} // MOD
//					if(FileNames[temp].isDirectory==3){giffromfat(number_zoom,number_zoom,"fat:/4.gif");} // MP3
//					if(FileNames[temp].isDirectory==4){giffromfat(number_zoom,number_zoom,"fat:/5.gif");} // TXT
//					if(FileNames[temp].isDirectory==1 && isback==1){giffromfat(number_zoom,number_zoom,"fat:/1.gif");}

			}   
		}   
	
		// if so, give it an icon.
		int yo=FileNames[temp].x+(FileNames[temp].x-y); // yo = the differents between where the icon IS and where it SHOULD BE
		float zoop=FileNames[temp].zoom;
		float test=64-((256/zoop)*32)/2;
		FileNames[temp].zoom=(128+(abs(FileNames[temp].x-y)*2));
		PA_SetRotsetNoAngle(0,FileNames[temp].sprite,FileNames[temp].zoom,FileNames[temp].zoom);
		// reflection
		PA_SetRotsetNoAngle(0,FileNames[temp].sprite+6,FileNames[temp].zoom,-FileNames[temp].zoom);
		// For safety, make extra sure the sprite is being used before moving it.
		if(FileNames[temp].sprite>-1)
		{
			PA_SetSpriteXY(0,FileNames[temp].sprite,yo-screen,test+80);
			// reflection
			PA_SetSpriteXY(0,FileNames[temp].sprite+6,yo-screen,208-test);
		}		
		if(FileNames[temp].zoom<160)file_to_load=FileNames[temp].sprite;

	}	

}
//// draw the text on the screen ///
PA_WaitForVBL();
// only update the screen once per second?
current_frame++;
if(current_frame == 30)
{
   
current_frame=0;
//PA_Load8bitBitmap(1, top_Bitmap); // Show image on top screen
//PA_Load8bitBitmap(0, bottom_Bitmap); // Show image on bottom screen
		PA_16cErase(0); // clear text on bottom screen
		PA_16cErase(1); // clear text on bottom screen

	char text[256];
			memset(text,0,255);
//sprintf(text,"%s%d",text,yy);  // String to transform
//PA_16cText(0, 10, 10, 246, 45, text, 1, 2, 30);


//load_bmp_4_sprite(20, "pass.bmp");

show_time();

	PA_16cTextAlign(ALIGN_CENTER);
			PA_16cText(0, 10, 33, 246, 45, FileNames[FileNumber].name, 1, 2, 30);
	PA_16cTextAlign(ALIGN_LEFT);

 if((Sprite[file_to_load].has_icon && !FileNames[FileNumber].isDirectory))
 {
	
   int cx=0,cy=0;
//	char letter=0;
	char text[256];
			memset(text,0,255);
	for(temp=0; temp<256; temp+=2)
	{
		if(Sprite[file_to_load].data[temp]!=0){
		sprintf(text,"%s%s",text,&Sprite[file_to_load].data[temp]);  // String to transform
		}		
		if(Sprite[file_to_load].data[temp]==10)
		{
		   sprintf(text,"%s%s",text,"\0");
			  PA_16cText(0, 20+cx, (cy*10)+50, 190, 96, text, 1, 2, 30);

		   cx=0;
			cy++;
			memset(text,0,255);
		}
	}
     PA_16cText(0, 20+cx, (cy*10)+50, 190, 96, text, 1, 2, 30);
 }	

else
{
	if(FileNames[FileNumber].isDirectory==1)
	{
	char text[255]="Folder";   
		  PA_16cText(0, 20, 50, 190, 96, text, 1, 2, 100);
	}
	if(FileNames[FileNumber].isDirectory==0)
	{
	char text[255]="No File Information";   
		  PA_16cText(0, 20, 50, 190, 96, text, 1, 2, 100);
	}      
	if(FileNames[FileNumber].isDirectory==2)
	{
	char text[255]="Protracker Module";   
		  PA_16cText(0, 20, 50, 190, 96, text, 1, 2, 30);
	}      
	if(FileNames[FileNumber].isDirectory==3)
	{
		  PA_16cText(0, 20, 50, 190, 96, songname, 1, 2, 30);
		  PA_16cText(0, 20, 60, 190, 96, artist, 1, 2, 30);
		  PA_16cText(0, 20, 70, 190, 96, album, 1, 2, 30);
		  PA_16cText(0, 20, 80, 190, 96, genre_name[genre[0]], 1, 2, 100);
	}      
}   

}

////////////////////////////////////


	}   

return FileNumber;
}
   
void GetFileList(void)
{
   int temp;
   for(temp=0; temp<5; temp++)
	{
	   Sprite[temp].used=0;
   	PA_SetSpriteXY(0,temp,300,192);
   	PA_SetSpriteXY(0,temp+6,300,192);
	}   

   for(temp=0; temp<max_files; temp++)
   {
      FileNames[temp].sprite=-1;
   }   

   NumberOfFiles=0;
   struct stat st;
   DIR_ITER* dir = diropen(".");
   if (dir == NULL)
   {
      // This will get replaced with a nice looking error.
//      PA_OutputText(1,2,2,"Disk Error!");
   }
   else
	// First check for folders
   while (dirnext(dir, FileNames[NumberOfFiles].name, &st) == 0)
   {
      // Is the entry a folder and is it NOT "."
      if(st.st_mode & S_IFDIR && strcmp(FileNames[NumberOfFiles].name, ".")!=0 && strcmp(FileNames[NumberOfFiles].name, "menu_skin")!=0)
		{
		   FileNames[NumberOfFiles].isDirectory=1;
		   FileNames[NumberOfFiles].size=0;
		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
		   NumberOfFiles++;
		}
	half_way=NumberOfFiles; // set the half way point for quick access to the file list.
	}  
   dirclose(dir);
   
   dir = diropen(".");
   if (dir == NULL)
   {
      // This will get replaced with a nice looking error.
//      PA_OutputText(1,2,2,"Disk Error!");
   }
   else
	// Now check for files
   while (dirnext(dir, FileNames[NumberOfFiles].name, &st) == 0)
   {
      if(st.st_mode & S_IFREG && filetype(FileNames[NumberOfFiles].name,".nds"))
		{
		   FileNames[NumberOfFiles].isDirectory=0;
		   FileNames[NumberOfFiles].size=0;
		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
		   NumberOfFiles++;
		}
      if(st.st_mode & S_IFREG && filetype(FileNames[NumberOfFiles].name,".mod"))
		{
		   FileNames[NumberOfFiles].isDirectory=2;
		   FileNames[NumberOfFiles].size=0;
		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
		   NumberOfFiles++;
		}
      if(st.st_mode & S_IFREG && filetype(FileNames[NumberOfFiles].name,".mp3"))
		{
		   FileNames[NumberOfFiles].isDirectory=3;
		   FileNames[NumberOfFiles].size=0;
		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
		   NumberOfFiles++;
		}
//      if(st.st_mode & S_IFREG && filetype(FileNames[NumberOfFiles].name,".txt"))
//		{
//		   FileNames[NumberOfFiles].isDirectory=4;
//		   FileNames[NumberOfFiles].size = st.st_size; // we only need the filesize for .txt so far
//		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
//		   NumberOfFiles++;
//		}
      if(st.st_mode & S_IFREG && filetype(FileNames[NumberOfFiles].name,".emc"))
		{
		   FileNames[NumberOfFiles].isDirectory=5;
		   FileNames[NumberOfFiles].size = 0; // we only need the filesize for .txt so far
		   FileNames[NumberOfFiles].x=NumberOfFiles*32;
		   NumberOfFiles++;
		}

	}  
   dirclose(dir); 
if(half_way >= NumberOfFiles){half_way = NumberOfFiles-1;}

}

int filetype(const char *filename, const char *extention)
{
   char *dotpos=strrchr(strlwr(filename),'.');
	if(NULL == dotpos)return 0;

	if(strstr(strlwr(filename),".sc.nds"))return 0; // we currently always egnore .sc.nds
	if(strstr(strlwr(filename),extention))return 1;
	return 0;
}

void readheader(const char *filename,int file_number)
{
	bool has_icon=0;
   int datalocation=0x68;
   u32 newlocation=0;
   FILE *handle = fopen(filename, "rb");
 
    if(handle){
        fseek(handle, datalocation, SEEK_SET); // move datalocation bytes from start of file
        fread(&newlocation, sizeof(u32), 1, handle);
			Sprite[file_number].has_icon=0;
			if(newlocation){has_icon=1; Sprite[file_number].has_icon=1;}
			datalocation=newlocation+832; // word+832 is english title
			fseek(handle, datalocation, SEEK_SET);

			fread(&Sprite[file_number].data, 1, 512, handle); // read the part of the header we need
			datalocation=newlocation+544; // word+544 is palette
			fseek(handle, datalocation, SEEK_SET);
			fread(&Sprite[file_number].palette, 1, 32, handle); // read the part of the header we need
//			fread(&icon_Pal, 1, 32, handle); // read the part of the header we need

	datalocation=newlocation+32; // word+32 is icon
	fseek(handle, datalocation, SEEK_SET);

	fread(&Sprite[file_number].image, 1, 512, handle); // read the part of the header we need
//	fread(&icon_Sprite, 1, 512, handle); // read the part of the header we need
	fclose(handle);

	if(!has_icon)// if there is no icon, set a default.
	{
			DMA_Copy(icon_Sprite, Sprite[file_number].image, 256, DMA_16NOW);
			DMA_Copy(icon_Pal, Sprite[file_number].palette, 16, DMA_16NOW);
	}   

    }

}


void show_time(void)
{
   
// clock size = 91x91, center = 50,50
u8 clock_x[60]= {
50,55,59,64,68,72,76,80,83,86,
89,91,93,94,95,95,95,94,93,91,
89,86,83,80,76,72,68,64,59,55,
50,45,41,36,32,28,24,20,17,14,
11,9,7,6,5,5,5,6,7,9,
11,14,17,20,24,27,32,36,41,45};
u8 clock_y[60]= {
5,5,6,7,9,11,14,17,20,24,
28,32,36,41,45,50,55,59,64,68,
72,76,80,83,86,89,91,93,94,95,
95,95,94,93,91,89,86,83,80,76,
72,68,64,59,55,50,45,41,36,32,
28,24,20,17,14,11,9,7,6,5};   


// using color #1 for seconds
// using color #2 for led off
// using color #3 for led on

if(clocktype==2)
{
 int temp = PA_RTC.Seconds;  

int x1 = ((clock_x[temp]-50)*9)/10;
int y1 = ((clock_y[temp]-50)*9)/10;
line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,2);

temp = PA_RTC.Minutes;
x1 = ((clock_x[temp]-50)*7)/10;
y1 = ((clock_y[temp]-50)*7)/10;
line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+50,clocky+49,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+49,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+50,clocky+51,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+51,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);

line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,3);
line(clockx+50,clocky+49,(clockx+50)+x1,(clocky+50)+y1,3);
line(clockx+49,clocky+50,(clockx+50)+x1,(clocky+50)+y1,3);
line(clockx+50,clocky+51,(clockx+50)+x1,(clocky+50)+y1,3);
line(clockx+51,clocky+50,(clockx+50)+x1,(clocky+50)+y1,3);

temp = PA_RTC.Hour;
if(temp>12)temp-=12;
temp*=5;
temp+=(PA_RTC.Minutes/12);

x1 = ((clock_x[temp]-50)*5)/10;
y1 = ((clock_y[temp]-50)*5)/10;
line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+50,clocky+49,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+49,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+50,clocky+51,(clockx+50)+x1,(clocky+50)+y1,0);
line(clockx+51,clocky+50,(clockx+50)+x1,(clocky+50)+y1,0);

line(clockx+50,clocky+50,(clockx+50)+x1,(clocky+50)+y1,4);
line(clockx+50,clocky+49,(clockx+50)+x1,(clocky+50)+y1,4);
line(clockx+49,clocky+50,(clockx+50)+x1,(clocky+50)+y1,4);
line(clockx+50,clocky+51,(clockx+50)+x1,(clocky+50)+y1,4);
line(clockx+51,clocky+50,(clockx+50)+x1,(clocky+50)+y1,4);
}
 
if(clocktype==1)
{
	u8 t;
	u8 tim=PA_RTC.Minutes;
	t=tim/10;
	tim=tim%10;
	PA_SetSpriteAnim(1,2,t);
	PA_SetSpriteAnim(1,3,tim);

	tim=PA_RTC.Hour;
	t=tim/10;
	tim=tim%10;
	PA_SetSpriteAnim(1,0,t);
	PA_SetSpriteAnim(1,1,tim);
	
	// The coors for the seconds
	int temp = PA_RTC.Seconds;
	// then clock part
	for(t=0; t<temp; t++)
	{
		PA_16cPutPixel(1,clockx+clock_x[t]  ,clocky+clock_y[t]  ,1); 
		PA_16cPutPixel(1,clockx+clock_x[t]+1,clocky+clock_y[t]  ,1); 
		PA_16cPutPixel(1,clockx+clock_x[t]  ,clocky+clock_y[t]+1,1); 
		PA_16cPutPixel(1,clockx+clock_x[t]+1,clocky+clock_y[t]+1,1); 
	}	
}

 
// show the day and date on the top screen.
char monthname[12][7]={
"Jan","Feb","March","April",
"May","June","July","Aug",
"Sept","Oct","Nov","Dec"};
char dayname[7][10]={
"Sunday",
"Monday",
"Tuesday",
"Wednesday",   
"Thursday",
"Friday",
"Saturday"}; 
	char text[255];
	
	PA_16cTextAlign(ALIGN_CENTER);
	sprintf(text,"%s",dayname[Day(PA_RTC.Day, PA_RTC.Month, PA_RTC.Year)-1]);
	PA_16cText(1, 14, 136, 128, 170, text, 5, 2, 30);
	sprintf(text,"%02d %s 20%02d",PA_RTC.Day,monthname[PA_RTC.Month-1],PA_RTC.Year);
	PA_16cText(1, 14, 160, 128, 190, text, 5, 2, 30);


}

int Day(int day,int month,int year)
{
  int a = (14 - month)/12;
  int y = year - a;
  int m = month + 12*a - 2;
  int d = (day + y + y/4 - y/100 + y/400 + (31*m)/12);
  return ((d % 7) + 1);
}
   
   
   void bootGBAMPnds(char *filename) {		
		
		REG_EXMEMCNT &= ~(0x8080);
 
 		FILE *handle = fopen(filename, "rb");
 		if(handle < 0) {
 			iprintf("\nLoader has failed!\n");
 		}
 		//u32 fileCluster = GetFileCluster();

		struct stat st;
		u32 cluster;

		stat(filename, &st);

		cluster = st.st_ino; 
 		
		fclose(handle);
 
 		REG_EXMEMCNT |= (0x8080);
 
 		REG_IME = IME_DISABLE;	// Disable interrupts
 		REG_EXMEMCNT |= (0x8080);  // ARM7 has access to GBA cart
 		*((vu32*)0x027FFFFC) = cluster;  // Start cluster of NDS to load
 		*((vu32*)0x027FFE04) = (u32)0xE59FF018;  // ldr pc, 0x027FFE24
 		*((vu32*)0x027FFE24) = (u32)0x027FFE04;  // Set ARM9 Loop address
 		swiSoftReset();  // Reset
}

boolean initIniFile(char *filename)
{
   if(iniFile==NULL)
    iniFile = fopen(filename, "r");
   
   if(iniFile==NULL)
   {
      printf("!!! Failed opening .ini file!\n");
      return false;
   }
   
   return true;
}

void closeIniFile()
{
//   printf("Close .ini file\n");
   if(iniFile!=NULL)
      fclose(iniFile);
}

boolean seekLine(char *line, char *param)
{
   int i;
   
   fseek(iniFile, 0, SEEK_SET);
   memset(line, 0, 256);
   while(fgets(line, 256, iniFile)!=NULL)
   {
      if(strlen(line)>strlen(param)) // check if there's a param
      {
         if(strlen(line)>0&&line[0]!='#') // not a comment line
         {
            boolean foundLine = true;
            for(i=0;i<(int)strlen(param);i++)
            {
               if(line[i]!=param[i])
                  foundLine = false;
            }
            if(foundLine)
               return true;
         }
      }
      memset(line, 0, 256);
   }
   
   return false;
}

// reads an inifile value as a string
char* readIniFileString(char *param)
{
   int i,j;
   if(iniFile==NULL) return NULL;
   char line[256];

   char *value = (char*)malloc(256); memset(value, 0, 256);
   
   if(!seekLine(line, param))
      return NULL;
      
   boolean parse = false;
   boolean strip = false;
   j=0;
   for(i=0;i<256;i++)
   {
      if(parse)
      {
         if(line[i]!=' ')
            strip = true;
         
         if(strip && line[i] > 0x13)
         {
            value[j] = line[i];
            j++;
         }
      }
      if(line[i]=='=')
         parse = true;
   }

   return value;
}

// reads an inifile value as integer
int readIniFileInt(char *param)
{
   int i,j;
   if(iniFile==NULL) return -1;
   char line[256];
   
   if(!seekLine(line, param))
      return -1;
      
   char value[16]; memset(value, 0, 16);
   boolean parse = false;
   boolean strip = false;
   j=0;
   for(i=0;i<(int)strlen(line);i++)
   {
      if(parse)
      {
         if(line[i]!=' ')
            strip = true;
         
         if(strip && line[i] > 0x13)
         {
            value[j] = line[i];
            j++;
         }
      }
      if(line[i]=='=')
         parse = true;
   }
   
   return atoi(value);
} 

boolean fileLocator(char *start, char *target, boolean isDir, int depth, char *result)
{
   struct stat st;
   DIR_ITER *dir = diropen(start);
   static char child[256];
   char temp[256];
   
   if (dir)
   {
      while (dirnext(dir, child, &st) == 0)
      {
         if (strlen(child) == 1 && child[0] == '.')
            continue;
                  
         if (strlen(child) == 2 && child[0] == '.' && child[1] == '.')
            continue;
         
         if (((st.st_mode & S_IFDIR) && isDir) || (!(st.st_mode & S_IFDIR) && !isDir) )
         {
            if (strcasecmp(target, child) == 0)
            {
               strcpy(result, start);
               if (start[strlen(start)-1] != '/')
               {
                  strcat(result, "/");
               }
               strcat(result, child);
               if(isDir)
                  strcat(result, "/");
            
               dirclose(dir);
               return true;
            }
         }
            
         if ((st.st_mode & S_IFDIR) && depth > 1)
         {
            strcpy(temp, start);
            if (start[strlen(start)-1] != '/')
            {
               strcat(temp, "/");
            }
            strcat(temp, child);
            strcat(temp, "/");
            
            if (fileLocator(temp, target, isDir, depth-1, result))
            {
               dirclose(dir);
               return true;
            }
         }
      }
   }
   
   dirclose(dir);
   return false;
}

int HexToDec(int crap)
{
   int num;

		if(crap == 48){num=0;}
		if(crap == 49){num=1;}
		if(crap == 50){num=2;}
		if(crap == 51){num=3;}
		if(crap == 52){num=4;}
		if(crap == 53){num=5;}
		if(crap == 54){num=6;}
		if(crap == 55){num=7;}
		if(crap == 56){num=8;}
		if(crap == 57){num=9;}
		if(crap == 65){num=10;}
		if(crap == 66){num=11;}
		if(crap == 67){num=12;}
		if(crap == 68){num=13;}
		if(crap == 69){num=14;}
		if(crap == 70){num=15;}
	return num;   
}   

void load_ini_file(void)
{
 char *target = "menu_config.ini";
 char iniFileName[256] = {0};   
if(fileLocator("/", target, false, 3, iniFileName)) // found yourconfig.ini, read the values from there
{
   initIniFile(iniFileName);
	// clock type
	clocktype = readIniFileInt("clocktype");
	
	// get the clock coords
	clockx = readIniFileInt("Clock_X");
	clocky = readIniFileInt("Clock_Y");
	if(clockx==-1)clockx=147;
	if(clocky==-1)clocky=51;
	char *tick;
	tick = readIniFileString("LED_On");
	int r1,r2 ,g1,g2 ,b1,b2;
	r1=HexToDec(tick[1]);
	r2=HexToDec(tick[2]);
	g1=HexToDec(tick[3]);
	g2=HexToDec(tick[4]);
	b1=HexToDec(tick[5]);
	b2=HexToDec(tick[6]);
	pale[1]=PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8); // lit led
	PA_SetBgPalCol(1, 3, PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8)); // seconds


	tick = readIniFileString("LED_Off");
	r1=HexToDec(tick[1]);
	r2=HexToDec(tick[2]);
	g1=HexToDec(tick[3]);
	g2=HexToDec(tick[4]);
	b1=HexToDec(tick[5]);
	b2=HexToDec(tick[6]);
	pale[2]=PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8); // dim led
	PA_SetBgPalCol(1, 4, PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8)); // seconds


	tick = readIniFileString("Top_Text");
	r1=HexToDec(tick[1]);
	r2=HexToDec(tick[2]);
	g1=HexToDec(tick[3]);
	g2=HexToDec(tick[4]);
	b1=HexToDec(tick[5]);
	b2=HexToDec(tick[6]);
	PA_SetBgPalCol(1, 5, PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8)); // text top 


	tick = readIniFileString("Seconds");
	r1=HexToDec(tick[1]);
	r2=HexToDec(tick[2]);
	g1=HexToDec(tick[3]);
	g2=HexToDec(tick[4]);
	b1=HexToDec(tick[5]);
	b2=HexToDec(tick[6]);
	PA_SetBgPalCol(1, 2, PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8)); // seconds 

	tick = readIniFileString("Bottom_Text");
	r1=HexToDec(tick[1]);
	r2=HexToDec(tick[2]);
	g1=HexToDec(tick[3]);
	g2=HexToDec(tick[4]);
	b1=HexToDec(tick[5]);
	b2=HexToDec(tick[6]);
	PA_SetBgPalCol(0, 1, PA_RGB((r1*16+r2)/8,(g1*16+g2)/8,(b1*16+b2)/8)); // text bottom 

	char *path;
	path = readIniFileString("Path");
	chdir(path);

	// three 'quick' folders
	folder1 = readIniFileString("folder1");
	folder2 = readIniFileString("folder2");
	folder3 = readIniFileString("folder3");

	// eight shortcuts
	short1 = readIniFileString("short1");
	short2 = readIniFileString("short2");
	short3 = readIniFileString("short3");
	short4 = readIniFileString("short4");
	short5 = readIniFileString("short5");
	short6 = readIniFileString("short6");
	short7 = readIniFileString("short7");
	short8 = readIniFileString("short8");

	startup = readIniFileString("startup");

	emc_screen = readIniFileInt("emc");

   closeIniFile();
}
  
}   

void play_mod(char * filename)
{
	FILE* modFile = fopen (filename, "rb"); //rb = read
	u32 modSize;
   fseek (modFile , 0 , SEEK_END);
   modSize = ftell (modFile);
   rewind (modFile);
   char * buffer;
   buffer = (char*) malloc (sizeof(char)*modSize);
   fread (buffer,1,modSize,modFile);
   fclose (modFile);
	PA_PlayMod(buffer);
}   

void readid3(char *filename,int file_number)
{

   FILE *handle = fopen(filename, "rb");

    if(handle){
		fseek(handle, -128, SEEK_END); // move datalocation bytes from start of file
      fread(tag, sizeof(char), 3, handle);
		if(tag[0]==84 && tag[1]==65 && tag[2]==71) // if valid id3v1 tag, then read it
		{
      fread(songname, sizeof(char), 30, handle);
      fread(artist, sizeof(char), 30, handle);
      fread(album, sizeof(char), 30, handle);
      fread(year, sizeof(char), 4, handle);
      fread(comment, sizeof(char), 30, handle);

		fseek(handle, -4, SEEK_END); // move datalocation bytes from start of file
      fread(genre, sizeof(char), 1, handle);
		}   
	 fclose(handle);
	}	 
}




char *trim_right( char *szSource )
{
char *pszEOS = 0;

// Set pointer to character before terminating NULL
pszEOS = szSource + strlen( szSource ) - 1;

// iterate backwards until non '_' is found
while( (pszEOS >= szSource) && (*pszEOS == '_') )
*pszEOS-- = '\0';

return szSource;
}


// for some stupid reason, this function doesn't seem to work
void load_bmp_4_sprite(u8 sprite_number, char *filename)
{
   unsigned short icons_Pal[16] __attribute__ ((aligned (4)));
 	FILE* testRead = fopen (filename, "rb"); //rb = read
	if(testRead)
	{
	fseek(testRead, 54, SEEK_SET); // palette is 54 bytes from start of file
	unsigned char col[4];
	int temp;
	for(temp=0; temp<16; temp++) // read the palette info
	{
		fread(col, sizeof(char), 4, testRead);	   
		icons_Pal[temp]=PA_RGB(col[2]>>3,col[1]>>3,col[0]>>3);
	}//temp   
	u8 row[16*32];
	fread(row,sizeof(u8),512,testRead); // read the full icon directly from the file
	fclose(testRead);

PA_LoadSprite16cPal(0,7,(void*)icons_Pal);	// Palette name

	PA_InitSpriteDraw (0, sprite_number);
	int x,y;
	for(y=0; y<16; y++)
	{
	 for(x=0; x<16; x++)
	 {
	    // drawing on the screen works fine
//	if((row[x+16*y]&240)>>4){PA_Put8bitPixel(0,x<<1,15-y,(row[x+16*y]&240)>>4);}
//	if(row[x+16*y]&15){PA_Put8bitPixel(0,1+ (x<<1),15-y,row[x+16*y]&15);}
	if((row[x+16*y]&240)>>4){PA_Put16bitPixel(0,x<<1,15-y,icons_Pal[(row[x+16*y]&240)>>4]);}
	if(row[x+16*y]&15){PA_Put16bitPixel(0,1+ (x<<1),15-y,icons_Pal[row[x+16*y]&15]);}

		// drawing on a sprite, well, you can see what happens
//		PA_SetSpritePixel(0, sprite_number, (x*2), (15-y), (row[x+16*y]&240)>>4);    
//		PA_SetSpritePixel(0, sprite_number, (1+x*2), (15-y), row[x+16*y]&15);    

	 }//x	   
	}//y
	}// end if testread	

}

///////////////////////////////////////////////////////////////////////////////////////////////////


void show_text_file(char filename[255], long length_of_file)
{
//	filename="book.txt";
   PA_ResetBgSys();
  	PA_Init8bitBg(0, 3); 	// Init a 8 bit Bg on screen 0	
	PA_Init8bitBg(1, 3); 	// Init a 8 bit Bg on screen 1	
//				PA_Clear8bitBg(0);
//				PA_Clear8bitBg(1);

	PA_8bitCustomFont(5, bigfont);	
	int screen = 1; // which screen to use
	char filetext[100]; // read 100 characters at a time
	int font_number=5; // use font number 1
	int orientation=3; // 2=normal 3=flipped right, 4=flipped left

	police8bitheight[5]=10;// manually set the hieght of the custom font, cos it doesnt recognise it

	PA_Load8bitBgPal(0, (void*)bigfont_Pal);
	PA_Load8bitBgPal(1, (void*)bigfont_Pal);

	long current_pos=0;

	FILE* testRead = fopen (filename, "rb"); //rb = read

// character x and y
int lx=5,ly=police8bitheight[font_number];

int temp=0,temp1=0;
int length_of_word=0; // how many pixels long the word is
long amount_to_read;
int exxit=0;

			for (temp1 = 0; temp1 <= 31; temp1++) {
			PA_SetBrightness(0, temp1);
			PA_SetBrightness(1, temp1);
			PA_WaitForVBL(); // To slow down the fades, we wait a frame...
			}  
			memset(top_Bitmap,0,49152);	// set the top image to 0
			memset(bottom_Bitmap,0,49152);// set the bottom image to 0
			PA_SetBgPalCol(0, 0, PA_RGB(31, 31, 31)); // set color 0 to white
			PA_SetBgPalCol(1, 0, PA_RGB(31, 31, 31)); // set color 0 to white
			PA_Load8bitBitmap(1, top_Bitmap); // Show image on top screen
			PA_Load8bitBitmap(0, bottom_Bitmap); // Show image on top screen
			for(temp1=0; temp1<11; temp1++)
			{
			   PA_DeleteSprite(0,temp1);// delete the icons
			   if(temp1<5){PA_DeleteSprite(1,temp1);}// delete the closk
			}

			PA_SetBrightness(0, 0);
			PA_SetBrightness(1, 0);

   while(current_pos<length_of_file-1 && exxit==0)
{


   amount_to_read = length_of_file - current_pos;
   if(amount_to_read>200)amount_to_read=200;
	fread(filetext, 1,amount_to_read, testRead);// read 100 bytes of text file
	bool isword=false;
	temp=0;
	char wurd[200]={0}; // use a char for each word
	temp=0;
	while(temp<amount_to_read && exxit==0)
	{
		isword=false;
		length_of_word=pa8bitdefaultsize[font_number][' '];
		while(isword==false)
		{//   32 = space         13=carrage return    10=linefeed
		 if(filetext[temp]!=32 && filetext[temp]!=10 && filetext[temp]!=13 && temp<amount_to_read) // if current letter is not space
		 {
		  wurd[temp1]=filetext[temp]; // coppy current letter to word
		  length_of_word+=pa8bitdefaultsize[font_number][(u8)wurd[temp1]]; // update length accordingly
		  temp++;
		  temp1++;
		  current_pos++;
		 }else{
		    wurd[temp1]=0; // terminate the string
		    isword=true; // tell loop a word is found
		    temp1=0;
		  temp++;
		  current_pos++;
		 }
		if(filetext[temp]==10)
		{
		  lx=5;
		  ly+=police8bitheight[font_number];
		}   

if(filetext[temp]==13)
{
   int number_of_lines=0;
	while(filetext[temp]==13 && temp<amount_to_read)
	{
		current_pos++;
		number_of_lines++;
		temp+=1;
	}
	if(number_of_lines>1)number_of_lines=1;
   lx=5;
	ly+=police8bitheight[font_number]*number_of_lines;
}   

		}   
		if(lx+length_of_word<=182) // if we are still on the screen
		{
		 // draw the word and update position
		 PA_SmartText(screen,lx,ly,182,240,wurd,1,font_number,orientation,100);
		 lx+=length_of_word;
		}else{
		   //if we are not on the screen, move down a line
		 ly+=police8bitheight[font_number];
		 lx=5;
		 PA_SmartText(screen,lx,ly,182,240,wurd,1,font_number,orientation,100);
		 lx+=length_of_word;
		 length_of_word=0;
		}   


		if(ly+police8bitheight[font_number]>240)
		{
			if(screen==1)
			{
				 lx=5;
				 ly=police8bitheight[font_number];
				 screen=0;  
			}else{
			   int ok_to_exit=0;
			   while(!ok_to_exit)
			   {
			      PA_WaitForVBL();
					if(Pad.Newpress.A){ok_to_exit=1;}
					if(Pad.Held.B){ok_to_exit=1; exxit=1;}
   
				}
				
				PA_Clear8bitBg(0);
				PA_Clear8bitBg(1);

				 lx=5;
				 ly=police8bitheight[font_number];
				 screen=1;  
			}			 
		}   
	}// temp<100
}//current_pos
					PA_SmartText(1,0,0,182,240,"exited function",1,font_number,orientation,100);
}   



void giffromfat(u8 sprite_number, char *filename)
{

FILE* Sprite = fopen (filename, "rb"); //rb=read gif=Variable fr Grafikdateinamen
u32 SpriteSize;
char * Spritebuffer;
if(Sprite) // Make sure there is a file to load
{
	fseek (Sprite , 0 , SEEK_END);
	SpriteSize = ftell (Sprite);
	rewind (Sprite);

	Spritebuffer = (char*) malloc (sizeof(char)*SpriteSize);
	fread (Spritebuffer,1,SpriteSize,Sprite);
	fclose (Sprite);

	unsigned char *spritegfx = PA_GifToTiles((void*)Spritebuffer, spritepal);

	int temp=0;
	for(temp=0; temp<512; temp++)
	{
		if(temp<16)
		{
			if(sprite_number==10){folder_back_Pal[temp] = spritepal[temp];}
			if(sprite_number==11){folder_Pal[temp] = spritepal[temp];}
			if(sprite_number==12){icon_Pal[temp] = spritepal[temp];}
			if(sprite_number==13){music_Pal[temp] = spritepal[temp];}
			if(sprite_number==14){text_Pal[temp] =spritepal[temp];}
			if(sprite_number==15){movie_Pal[temp] =spritepal[temp];}
		}   
		if(sprite_number==10){folder_back_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
		if(sprite_number==11){folder_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
		if(sprite_number==12){icon_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
		if(sprite_number==13){music_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
		if(sprite_number==14){text_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
		if(sprite_number==15){movie_Sprite[temp] = (spritegfx[1+(temp*2)]*16)+spritegfx[(temp*2)];}
	}   
}// if sprite
//free(Spritebuffer);//free the memory used by mediafiles
}

int len(char *str1)
{
 int count = 0;
 while (str1[count] != '\0') count++;  
 return count;
}

void left(char *str1, char * str2, int num)
{
  int count = 0;
  for(count=0; count<num; count++)
  {
		str1[count] = str2[count];  	   
  }
  str1[count] = '\0';	   
}
   
   
void load_bottom(void)
{
   fadetoblack();
	//fat:/menu_skin/
 	FILE* testRead = fopen ("fat:/menu_skin/bottom.bmp", "rb"); //rb = read
	if(testRead)
	{
	fseek(testRead, 54, SEEK_SET); // palette is 54 bytes from start of file

		int x,y;
		//char r,g,b;
		char col[3];
		for(y=0; y<192; y++)
		{
		 for(x=0; x<256; x++)
		 {
			fread(&col, sizeof(char), 3, testRead);	   
			PA_Put16bitPixel(0,x,191-y,PA_RGB(col[2]>>3,col[1]>>3,col[0]>>3)); //PA_RGB(col[0]>>3,col[1]>>3,col[2]>>3)
		 }//x	   
		}//y
		fclose(testRead);
	}// end if testread	

 	testRead = fopen ("fat:/menu_skin/top.bmp", "rb"); //rb = read
	if(testRead)
	{
	fseek(testRead, 54, SEEK_SET); // palette is 54 bytes from start of file

		int x,y;
		//char r,g,b;
		char col[3];
		for(y=0; y<192; y++)
		{
		 for(x=0; x<256; x++)
		 {
			fread(&col, sizeof(char), 3, testRead);	   
			PA_Put16bitPixel(1,x,191-y,PA_RGB(col[2]>>3,col[1]>>3,col[0]>>3)); //PA_RGB(col[0]>>3,col[1]>>3,col[2]>>3)
		 }//x	   
		}//y
		fclose(testRead);
	fadefromblack();
	}// end if testread	

}


void line(int x0, int y0, int x1, int y1, int pix)
{
    int dx = x1 - x0;
    int dy = y1 - y0;
	PA_16cPutPixel(1,x0,y0,pix);
    if (abs(dx) > abs(dy)) {          // slope < 1
        float m = (float) dy / (float) dx;      // compute slope
        float b = y0 - m*x0;
        dx = (dx < 0) ? -1 : 1;
        while (x0 != x1) {
            x0 += dx;
				PA_16cPutPixel(1,x0,(m*x0 + b),pix);
        }
    } else
    if (dy != 0) {                              // slope >= 1
        float m = (float) dx / (float) dy;      // compute slope
        float b = x0 - m*y0;
        dy = (dy < 0) ? -1 : 1;
        while (y0 != y1) {
            y0 += dy;
				PA_16cPutPixel(1,(m*y0 + b), y0,pix);
        }
    }
}


inline void clearmem(u32 dest, u32 size) {
	int i=0;
	swiFastCopy(&i, (u32*)dest, 0x01000000 | (size>>2));
}


void boot_gba(void)
{
   //switch off one of the screens
 if(PersonalData->_user_data.gbaScreen)
 {
    PA_SetScreenLight(1, 0); 
    PA_SetScreenLight(0, 1); 
  }else
  {
     PA_SetScreenLight(0, 0);
     PA_SetScreenLight(1, 1);
  }   
 	//reset DMA
	clearmem(0x40000B0, 0x30);

	//clear VRAM
	REG_POWERCNT=1;
	VRAM_CR=0x80808080;
	VRAM_E_CR=0x80;
	VRAM_F_CR=0x80;
	VRAM_G_CR=0x80;
	VRAM_H_CR=0x80;
	VRAM_I_CR=0x80;
//	clearmem(0x6800000,0xA4000);
load_gba_frame(1);

load_gba_frame(1);

	VRAM_CR=0;
	VRAM_E_CR=0;
	VRAM_F_CR=0;
	VRAM_G_CR=0;
	VRAM_H_CR=0;
	VRAM_I_CR=0;


			if(PersonalData->_user_data.gbaScreen)
						REG_POWERCNT=1;
					else
						REG_POWERCNT=POWER_SWAP_LCDS|1;

		   REG_IPC_FIFO_TX=0x87654322; // send a fifo to the highjacked wifi code
  
}  

void load_gba_frame(int screen)
{//fat:/menu_skin/
 	FILE* testRead = fopen ("fat:/menu_skin/gbaframe.bmp", "rb"); //rb = read
	if(testRead)
	{
	fseek(testRead, 54, SEEK_SET); // palette is 54 bytes from start of file

		int x,y;
		u32 i,j;
		//char r,g,b;
		char col[3];
		for(y=0; y<192; y++)
		{
		 for(x=0; x<128; x++)
		 {
			fread(&col, sizeof(char), 3, testRead);	   
			i=PA_RGB(col[2]>>3,col[1]>>3,col[0]>>3);
			fread(&col, sizeof(char), 3, testRead);	   
			j=PA_RGB(col[2]>>3,col[1]>>3,col[0]>>3);
			i+=(j<<16);
			swiFastCopy(&i, (u32*)0x6800000+(((256*(191-y)+(x*2))*2)/4), 0x01000000 | (1));
			swiFastCopy(&i, (u32*)0x6820000+(((256*(191-y)+(x*2))*2)/4), 0x01000000 | (1));
		 }//x	   
		}//y
		fclose(testRead);
	}// end if testread	
}
 
 
int EMC_Playback(char * filename, u8 screen, u8 interruptme)
{
	PA_InitSound(); //Init sound

  char* sndBuf = NULL;
  u16 pixSize;
  u8 startedaudio = 0;
  u16 sndBufPointer = 0;
  int ANM = 0 ; 
  int last_top = 0 ;
  FILE* vidFile = fopen (filename, "r");
  fread(&vidhead,1,32,vidFile);
  if (vidhead.samplesize > 0)
  {
    sndBuf = (char*) malloc (sizeof(char)*vidhead.samplesize*4);
  }
  // begin the playback loop here
  PA_VBLCounterStart(ANM) ; 
  int play_on = 1;
  char* pixBuf = (char*) malloc(16000);

    // enter the main loop
    while(play_on)
    {

    if((play_on == 1) || (PA_VBLCounter[ANM] != last_top))
    {
      last_top = PA_VBLCounter[ANM];
      if (vidhead.samplesize != 0)
      {
        fread(&sndBuf[sndBufPointer * vidhead.samplesize],1,vidhead.samplesize,vidFile);
        sndBufPointer++;
        if (sndBufPointer == 4) sndBufPointer = 0;
      }
      fread(&pixSize,2,1,vidFile);
      fread(pixBuf, 1, pixSize, vidFile);

      //PA_LoadJpeg(screen,pixBuf) ;
		PA_load_jpg(screen,pixBuf);		

      if(startedaudio == 0)
      {
        startedaudio = 1;        
        PA_PlaySoundEx2(0, sndBuf, (u32)vidhead.samplesize*4, 127, 11025, 1, 1, 0);
      }
    }
    play_on ++ ;
    if(play_on == vidhead.framecount)
    {
      PA_StopSound(0);
      play_on = 0;
      PA_VBLCounterPause(ANM) ;
    }

	if(Pad.Newpress.B)
	{
      PA_StopSound(0);
      play_on = 0;
      PA_VBLCounterPause(ANM) ;
	}   

//      PA_WaitForVBL() ;
		PA_Load16bitBitmap(screen, screen_bitmap);

  }
  fclose(vidFile);
  if (vidhead.samplesize != 0) free(sndBuf);
  free(pixBuf);
  return 0;
}


void fadetoblack()
{
	int i;
	for (i = 0; i >= -31; i--) 
	{
		PA_SetBrightness(0, i);
		PA_SetBrightness(1, i);
		PA_WaitForVBL(); // To slow down the fades, we wait a frame...
		PA_WaitForVBL(); 
	}	
}


void fadefromblack()
{
	int i;
	for (i = -31; i <= 0; i++) 
	{
		PA_SetBrightness(0, i);
		PA_SetBrightness(1, i);
		PA_WaitForVBL(); // To slow down the fades, we wait a frame...
		PA_WaitForVBL(); 
	}	
}


void fadetowhite()
{
	int temp1=0;
	for (temp1 = 0; temp1 <= 31; temp1++) 
	{
		PA_SetBrightness(0, temp1);
		PA_SetBrightness(1, temp1);
		PA_WaitForVBL(); // To slow down the fades, we wait a frame...
		PA_WaitForVBL(); 
	}  
}   

void fadefromwhite()
{
	int temp1=31;
	for (temp1 = 31; temp1 >= 0; temp1--) 
	{
		PA_SetBrightness(0, temp1);
		PA_SetBrightness(1, temp1);
		PA_WaitForVBL(); // To slow down the fades, we wait a frame...
		PA_WaitForVBL(); 
	}  
}   

