
//***********
// INCLUDES *
//***********

#include <PA9.h>

#include "gfx/all_gfx.c"
#include "gfx/all_gfx.h"

#include "efs_lib.h"


#include "beep3.h"
#include "clop.h"
#include "ploum2.h"
#include "noturn.h"
#include "lift2.h"

#include "compo_top.h" // gif to include
#include "compo_bottom.h" // gif to include



#define CHANNEL 0
#define NB_MODS 16
#define NB_MODS2 16
#define LONGUEUR_BOARD 16
#define LARGEUR_BOARD 12
#define NB_SPRITES 199

#define Y_TITRE 20 //correspond au y de la première brique du E
#define X_TITRE 12 //correspond au x de la première brique du E

//*************
// STRUCTURES *
//*************

typedef struct
{
	u32 num; //numero du sprite
	u8 type; // type 0 nothing 1 circle, 2 triangle ...
	u8 mark; //bool pour verification du board
	u8 turned; // 0 cube pas tourne, 1 cube tourne ou intournable 
	s32 points;
	void* sprite;

	
} cube;

typedef struct
{
	s32 score;
	char nom[10+1]; 
} hgscore;


//*********************
// VARIABLES GLOBALES *
//*********************
u8 ecran = 0; //0 menu principal - 1 menu options jeu 1 

s32 timelimit = 54000; //54000 15minutes
u8 time = 1; // pour choix du temps de jeu
s32 seconds;
s32 seconds2;
u8 passed = 0; // passer introduction

u8 jeu = 0;
u8 vitesse = 1;
u8 level = 1; //0 easy 1 normal 2 hard
u8 music = 1; //0 no music 1 wtc 2 scarlatti
u8 decalage = 2; //decalage pour reduire la taille du tableau en fonction du level
u32 score = 0;
u8 combo = 1;
u8 played[10];
u8 gameend = 0;
u8 newmod = 0;
u8 ferme =0;

hgscore highscores[180]; //easy-5min*10 + easy-15min ...  


u16 gfx[9];
u16 gfx2[9];
u16 gfx3[9];
u16 combogfx;
u16 gameovergfx;
u16 bgblackgfx;

char* basemods[NB_MODS];
void* basemods2[NB_MODS2];

cube board[LONGUEUR_BOARD][LARGEUR_BOARD];
u8 spriteslibres[NB_SPRITES];
s32 MyCounter = 0;




//****************************
// DECLARATIONS DE FONCTIONS *
//****************************
void initialise_spriteslibres();
u8 spritelibre();
void liberesprite(u8);
void occupesprite(u8 i);

u8 channel_libre();
void affiche_timelimit();
void affiche_level();
void affiche_music();
void affiche_ecran0();
void affiche_regle();
void initbasemods();
s32 score_cube(s32);
void affiche_score();
void affiche_combo();
void efface_combo();
void initboard();
void gravite_cube();
void inithighscores();
void play_newmod();
void affichehighscores();
void highscoresscreen();
void update_points(s32);
void nouveau_cube();
void debugtableau();
void deplace_cube();
u8 controle_board();

// Custom function we'll use, with just a single counter for the sake of the example
void MyVBLFunction(void){
	u8 c;
	u8 i;
	

	
	MyCounter++; 
	if ((newmod == 0) & (!PA_SoundChannelIsBusy(0)) & (music != 0)){
			if (MyCounter > 120) 
			{
			
			//PA_StopMod();	
      		//PA_PlayMod(basemods[PA_RandMax(NB_MODS-1)]);
      		//PA_PlayMod(basemods[2]);
      		newmod = 1;
			MyCounter = 0;
			}
		}
	else MyCounter = 0;
	
	
	//PA_CheckLid(); 
	if ((!gameend) & (!ferme) ){
	if (timelimit != 0)	{
				
		seconds = (timelimit-PA_VBLCounter[0])/60;
		
		for (i = 10; i > 0; i--){
			if ((seconds == i) & (played[i] == 0)){
			 c = channel_libre();
			 if (c != 0) PA_PlaySound(c, beep3, (u32)beep3_size,60,18000);
			 played[i] = 1;
		}
		}
		
		
	if (seconds == 0) gameend = 1;
		
		
	}
	else seconds = (timelimit+PA_VBLCounter[0])/60; 
	//	PA_OutputText(1,0,20,"time : %d", time%10); //debug
					 
		PA_SetSpriteAnim(1, 106, seconds%10); //secondes unites
		PA_SetSpriteAnim(1, 105, (seconds/10)%6); //secondes dizaines
		PA_SetSpriteAnim(1, 103, (seconds/(10*6))%10); //minutes unites
		PA_SetSpriteAnim(1, 102, (seconds/(10*6*10))%6); //minutes dizaine
	}	

}

//****************
// MAIN FONCTION *
//****************

s32 main(void)	{
	
	PA_Init();
	PA_InitVBL();	
	PA_InitSound();  // Initialisation du systeme du son
	PA_InitRand();
	
	fatInitDefault(); //Initialise fat library
	EFS_Init();
	
	u8 c;
	u8 cnt = 0;
	s8 i = 0;
	
	


	
	PA_Init8bitBg(0, 3); 	// Init a 16 bit Bg on screen 0
	PA_Init8bitBg(1, 3); 	// Init a 8 bit Bg on screen 1	
	
	PA_SetBrightness(0, -31); // all black
	PA_SetBrightness(1, -31); // all black	
	
	// Load splash while hidden
	PA_LoadGif(	1, (void*)compo_top); // Gif File
	PA_LoadGif(	0, (void*)compo_bottom); // Gif File


		PA_SetBrightness(0, 0); 
		PA_SetBrightness(1, 0); 


	s16 timeframe = 200; // 180 frames = 3 seconds
	while(timeframe && (!Pad.Newpress.Anykey) && (!Stylus.Newpress)){ // Display until time over or keys pressed
		timeframe--; // time goes by
		PA_WaitForVBL();
	}	
		
	
	// Transition to black
	for(i = 0; i > -32; i--){
		PA_SetBrightness(0, i); 
		PA_SetBrightness(1, i); 
		PA_WaitForVBL();		   
	}  	

	// Now that it's all black, clean all that and you're ready to go !
	PA_ResetBgSys();

	
	
	initbasemods();
	
	PA_SetSoundVol(50);
    //PA_PlayMod(basemods[1]);
   		play_newmod();
   	
	PA_Init16cBg(1, 0);
	PA_16cCustomFont(6, bitout);
	PA_LoadTiledBg(1, 1, bas2);  
	PA_LoadPal16(PAL_BG1, 0, bitout_Pal);
	
	PA_Init16cBg(0, 0);
	PA_LoadTiledBg(0, 3, bgmenu);
	PA_LoadPal16(PAL_BG0, 0, bitout_Pal);
	
	for(i = -30; i <= 0; i=i+2){
		PA_SetBrightness(0, i); 
		PA_SetBrightness(1, i); 
		PA_WaitForVBL();		   
	}   
	
	// Turn on the DS Motion...
	
	PA_MotionInit();
	
	 


	affiche_ecran0();
	
	inithighscores();
		
	ecran = 0;
		
	// Boucle infinie pour mas32enir le programme en fonction
	while(1) {	
		
		if (ecran == 0) { 
			

			if (PA_CheckDSMotion()){	
					PA_16cText(0, 57, 160, 255, 192, "DS MOTION DETECTED", 1, 6, 100);
			}
			

			if (PA_SpriteTouched(100)) { // jeu classic
		
				PA_SetSpriteAnim(0, 100, 1); 
				PA_SetSpriteAnim(0, 101, 1); 
				PA_SetSpriteAnim(0, 102, 1); 
				c = channel_libre();
				 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();	
				
				
	
	
				ecran = 1;
				jeu = 0;
				
				
				PA_ResetSpriteSysScreen(1);				
				PA_LoadTiledBg(0, 1, bgmenuoptions);
				PA_16cClearZone(0,0,0,256,192);
				PA_16cClearZone(1,0,0,256,192);
				}		
			
			if (PA_SpriteTouched(103)) { // puzzle
		
				PA_SetSpriteAnim(0, 103, 1); 
				PA_SetSpriteAnim(0, 104, 1); 
				PA_SetSpriteAnim(0, 105, 1); 
				c = channel_libre();
				 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
				PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();	
	
				ecran = 1;
				jeu = 1;
				
				PA_ResetSpriteSysScreen(1);					
				PA_LoadTiledBg(0, 1, bgmenuoptions); 
				PA_16cClearZone(0,0,0,256,192);
				PA_16cClearZone(1,0,0,256,192);

			}	
			
					
			if (PA_LidClosed()) {	
					PA_StopMod();					
				} 
				
			if (newmod) {
				play_newmod();	 
				newmod = 0;
			}
			
			
		}

	   
		if (ecran == 1){
			time = 1; // pour choix du temps de jeu
			level = 1; //0 easy 1 normal 2 hard
		//	music = 1; //0 no music 1 wtc
			
		
			
	 
			PA_LoadSpritePal(0, 1, (void*)button_Pal); 
			affiche_regle();
	
			PA_CreateSprite(0, 100, (void*)buttonstart_Sprite, OBJ_SIZE_64X32, 1, 1, 170, 160);
			PA_CreateSprite(0, 101, (void*)buttonright_Sprite, OBJ_SIZE_32X32, 1, 1, 224, 160); 
			PA_CreateSprite(0, 102, (void*)buttonleft_Sprite, OBJ_SIZE_32X32, 1, 1, 148, 160);  
		
			PA_CreateSprite(0, 103, (void*)buttonback_Sprite, OBJ_SIZE_64X32, 1, 1, 23, 160);
			PA_CreateSprite(0, 104, (void*)buttonright_Sprite, OBJ_SIZE_32X32, 1, 1, 78, 160); 
			PA_CreateSprite(0, 105, (void*)buttonleft_Sprite, OBJ_SIZE_32X32, 1, 1, 2, 160);  

			PA_CreateSprite(0, 106, (void*)left_Sprite, OBJ_SIZE_16X16, 1, 1, 60, 30);
			PA_CreateSprite(0, 107, (void*)right_Sprite, OBJ_SIZE_16X16, 1, 1, 178, 30);	
			PA_16cText(0, 102, 34, 255, 100, "Normal", 1, 6, 100);
	
			PA_CreateSprite(0, 108, (void*)left_Sprite, OBJ_SIZE_16X16, 1, 1, 60, 82);
			PA_CreateSprite(0, 109, (void*)right_Sprite, OBJ_SIZE_16X16, 1, 1, 178, 82);
			PA_16cText(0, 86, 86, 255, 100, "15 Minutes", 1, 6, 100);
		
			PA_CreateSprite(0, 110, (void*)left_Sprite, OBJ_SIZE_16X16, 1, 1, 60, 134);
			PA_CreateSprite(0, 111, (void*)right_Sprite, OBJ_SIZE_16X16, 1, 1, 178, 134);	
			
			if (music == 1) PA_16cText(0, 92, 138, 255, 190, "Bach WTC", 1, 6, 100);
			else if (music == 2) PA_16cText(0, 92, 138, 255, 190, "Scarlatti", 1, 6, 100);
			else PA_16cText(0, 96, 138, 255, 190, "No Music", 1, 6, 100);

			u8 sorti = 0;

			while (!sorti){
				
				if (PA_SpriteTouched(100)) { // START	
				
					PA_SetSpriteAnim(0, 100, 1); // screen, sprite, frame
					PA_SetSpriteAnim(0, 101, 1); // screen, sprite, frame
					PA_SetSpriteAnim(0, 102, 1); // screen, sprite, frame
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
		
					PA_WaitFor(Stylus.Released);  // affiche le bouton avec transparence d'origine si relaché
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					ecran = 2;
					sorti = 1;
					PA_ResetBgSys();
   					PA_ResetSpriteSys();	
				}

				if (PA_SpriteTouched(103)) { // BACK

					PA_SetSpriteAnim(0, 103, 1); // screen, sprite, frame
					PA_SetSpriteAnim(0, 104, 1); 
					PA_SetSpriteAnim(0, 105, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
		
					PA_WaitFor(Stylus.Released);  // affiche le bouton avec transparence d'origine si relaché
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					ecran = 0;
					sorti = 1;
					
				/*	PA_HideBg(0,1);
					//PA_LoadTiledBg(0, 1, bgmenuoptions);
					//PA_LoadTiledBg(0, 3, bas2);
   					PA_ResetSpriteSys();
   					PA_16cClearZone(0,0,0,256,192);
					PA_16cClearZone(1,0,0,256,192);
					affiche_ecran0();*/
					
					PA_SetBrightness(0,-30);
					PA_SetBrightness(1,-30);
					
					   
					PA_ResetBgSys();
   					PA_ResetSpriteSys();	
					PA_Reset3DSprites();
					PA_Init2D();
		
				
					
					PA_Init16cBg(1, 0);
					PA_Init16cBg(0, 0);
		
				
		
					PA_16cCustomFont(6, bitout);	
					PA_LoadPal16(PAL_BG1, 0, bitout_Pal);
					PA_LoadPal16(PAL_BG0, 0, bitout_Pal);
					PA_16cClearZone(0,0,0,256,192);
					PA_16cClearZone(1,0,0,256,192);
			
					PA_LoadTiledBg(0, 3, bgmenu);
					PA_LoadTiledBg(1, 1, bas2);  
					ecran = 0;	
					
					for (cnt=-30; cnt < 1; cnt = cnt + 2)
					{
					   PA_SetBrightness(0,cnt);
					   PA_SetBrightness(1,cnt);
					   PA_WaitForVBL();
					}  		
					affiche_ecran0();
					
				}

				if (PA_SpriteTouched(106)) { // level a gauche
		
					PA_SetSpriteAnim(0, 106, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 106, 0); 
		
					if (level != 0) level--;
					affiche_level(); 	
				}

				if (PA_SpriteTouched(107)) { // level à droite
		
					PA_SetSpriteAnim(0, 107, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 107, 0); 
		
					if (level != 2) level++;
					affiche_level(); 
				}

				if (PA_SpriteTouched(108)) { // time a gauche
		
					PA_SetSpriteAnim(0, 108, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 108, 0); 
					if (time != 0) time--;
					affiche_timelimit(); 
				}

				if (PA_SpriteTouched(109)) { // time a droite
		
					PA_SetSpriteAnim(0, 109, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 109, 0); 
		
					if (time != 2) time++;
					affiche_timelimit(); 	
				}
		
				if (PA_SpriteTouched(110)) { // music a gauche
		
					PA_SetSpriteAnim(0, 110, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 110, 0); 
					
					if (music != 0) music--;
					affiche_music(); 	
				}

				if (PA_SpriteTouched(111)) { // level a droite
		
					PA_SetSpriteAnim(0, 111, 1); 
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					PA_WaitFor(Stylus.Released);  
					PA_WaitForVBL();PA_WaitForVBL();PA_WaitForVBL();
					PA_SetSpriteAnim(0, 111, 0); 
		
					if (music != 2) music++;
					affiche_music(); 
				}
			}
			
			
			if (PA_LidClosed()) {	
					PA_StopMod();					
				} 
				
			 if (newmod) {
				play_newmod();	 	 	
				newmod = 0;
			}
		}   // FIN ECRAN 1
		
		


		if (ecran == 2) {
			PA_ResetBgSys();
   			PA_ResetSpriteSys();
			PA_Init3D(); 
   		
			PA_Reset3DSprites();
		
			combogfx = PA_3DCreateTex((void*)combo_Texture, 32, 32, TEX_256COL);	
			gameovergfx = PA_3DCreateTex((void*)gameover_Texture, 256, 128, TEX_256COL);
			bgblackgfx = PA_3DCreateTex((void*)bgblack_Texture, 256, 256, TEX_256COL);
   		
   			gfx[0] = PA_3DCreateTex((void*)circle3d1_Texture, 16, 16, TEX_256COL);	
			gfx[1] = PA_3DCreateTex((void*)triangle3d1_Texture, 16, 16, TEX_256COL);	
			gfx[2] = PA_3DCreateTex((void*)square3d1_Texture, 16, 16, TEX_256COL);	
			gfx[3] = PA_3DCreateTex((void*)diamond3d1_Texture, 16, 16, TEX_256COL);	
			gfx[4] = PA_3DCreateTex((void*)penta3d1_Texture, 16, 16, TEX_256COL);	
			gfx[5] = PA_3DCreateTex((void*)heart3d1_Texture, 16, 16, TEX_256COL);	
			gfx[6] = PA_3DCreateTex((void*)star3d1_Texture, 16, 16, TEX_256COL);	
			gfx[7] = PA_3DCreateTex((void*)block3d1_Texture, 16, 16, TEX_256COL);	
			gfx[8] = PA_3DCreateTex((void*)joker3d1_Texture, 16, 16, TEX_256COL);	
	
			gfx2[0] = PA_3DCreateTex((void*)circle3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[1] = PA_3DCreateTex((void*)triangle3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[2] = PA_3DCreateTex((void*)square3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[3] = PA_3DCreateTex((void*)diamond3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[4] = PA_3DCreateTex((void*)penta3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[5] = PA_3DCreateTex((void*)heart3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[6] = PA_3DCreateTex((void*)star3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[7] = PA_3DCreateTex((void*)block3d2_Texture, 16, 16, TEX_256COL);	
			gfx2[8] = PA_3DCreateTex((void*)joker3d2_Texture, 16, 16, TEX_256COL);	
	
			gfx3[0] = PA_3DCreateTex((void*)circle3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[1] = PA_3DCreateTex((void*)triangle3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[2] = PA_3DCreateTex((void*)square3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[3] = PA_3DCreateTex((void*)diamond3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[4] = PA_3DCreateTex((void*)penta3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[5] = PA_3DCreateTex((void*)heart3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[6] = PA_3DCreateTex((void*)star3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[7] = PA_3DCreateTex((void*)block3d3_Texture, 16, 16, TEX_256COL);	
			gfx3[8] = PA_3DCreateTex((void*)joker3d3_Texture, 16, 16, TEX_256COL);
	
			PA_Load3DSpritePal(0, (void*)circle3d_Pal); // Palette
			PA_Load3DSpritePal(1, (void*)triangle3d_Pal);		
			PA_Load3DSpritePal(2, (void*)square3d_Pal);	
			PA_Load3DSpritePal(3, (void*)diamond3d_Pal);
			PA_Load3DSpritePal(4, (void*)penta3d_Pal);
			PA_Load3DSpritePal(5, (void*)heart3d_Pal);
			PA_Load3DSpritePal(6, (void*)star3d_Pal);
			PA_Load3DSpritePal(7, (void*)block3d_Pal);
			PA_Load3DSpritePal(8, (void*)joker3d_Pal);
			PA_Load3DSpritePal(9, (void*)combo_Pal);
		
   			PA_InitText(1, 0);  // Initialise the normal text on the bottom screen		

			PA_LoadTiledBg(1, 3, bas2); 
			PA_LoadTiledBg(1, 1, bgscore); 
			PA_LoadTiledBg(0, 3, bas2); 
			
			
			// pour chiffres scores et chrono
			PA_LoadSprite16cPal(1, 5, (void*)digit_Pal);	
			PA_CreateSprite(1, 100, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 50, 141); 
			PA_CreateSprite(1, 101, (void*)colon_Sprite, OBJ_SIZE_32X32, 0, 5, 70, 141);
			PA_CreateSprite(1, 102, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 90, 141);
			PA_CreateSprite(1, 103, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 115, 141);
			PA_CreateSprite(1, 104, (void*)sec_Sprite, OBJ_SIZE_32X32, 0, 5, 135, 141); 
			PA_CreateSprite(1, 105, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 155, 141); 
			PA_CreateSprite(1, 106, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 180, 141); 
	
			PA_CreateSprite(1, 110, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 50, 77); 
			PA_CreateSprite(1, 111, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 75, 77);
			PA_CreateSprite(1, 112, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 100, 77);	
			PA_CreateSprite(1, 113, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 125, 77);
			PA_CreateSprite(1, 114, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 150, 77); 
			PA_CreateSprite(1, 115, (void*)digital_Sprite, OBJ_SIZE_32X32, 0, 5, 175, 77);
	

			// INITIALISATION VARIABLES JEU
			if (level == 0) {
				decalage = 4;	
				vitesse = 1;
				PA_LoadTiledBg(0, 2, bgeasy);  
			}
			else if (level == 1) {
				decalage = 2;	
				vitesse = 2;
				PA_LoadTiledBg(0, 2, bgnormal);  
			}
			else {
				decalage = 1;
				vitesse = 3;
				PA_LoadTiledBg(0, 2, bghard);  
			}
	
			
			
			gameend = 0;
			score = 0;
			
	
			for ( i = 0; i < 10; i++){
				played[i] = 0;
			}
	
			if (time == 0) timelimit = 18000; // 5 minutes
			else if (time == 1) timelimit = 54000; // 15 minutes
			else timelimit = 0; // unlimited
	
			
			
			PA_VBLCounterStart(0);
			PA_VBLFunctionInit(MyVBLFunction);
			
			 
			initialise_spriteslibres();
			initboard();
			seconds2 = seconds; 
			if (jeu == 0) {
				while (gameend == 0){ //DEBUT DU JEU
					
					
				if (PA_LidClosed()) {
					ferme = 1;
					PA_VBLCounterPause(0);
					PA_StopMod();			
					
				} 
				else {
					ferme = 0;
					PA_VBLCounterUnpause(0);
				}
				
				if (!ferme) nouveau_cube();
				
				if (newmod) {
						play_newmod();
				 		newmod = 0;
				}
				}
			}	
			else {
				//jeu puzzle
				while (gameend == 0){
				if (PA_LidClosed()) {
					ferme = 1;
					PA_VBLCounterPause(0);
					PA_StopMod();			
					
				} 
				else {
					ferme = 0;
					PA_VBLCounterUnpause(0);
				}
				
				if (!ferme)	deplace_cube();
				
				if (newmod){
					 play_newmod();
					newmod = 0;
					}
				}
			}
				
			// JEU FINI	
			PA_VBLCounterPause(0);
			s32 x;
						
		
			PA_LoadTiledBg(0, 3, bgmenu); 
			PA_3DCreateSpriteFromTex(252, bgblackgfx, 256, 256,  9, 132, 64);
			PA_3DSetSpritePrio(252, 4);  
			PA_3DSetSpriteAlpha(252, 20);
			PA_3DSetSpritePolyID(252, 1);
			
			PA_3DCreateSpriteFromTex(251, gameovergfx, 256, 128,  9, 132, 64);
			PA_3DSetSpritePrio(251, 5);  
			PA_3DProcess();  // Update sprites
			PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  
		
			//REINITIALISATION POUR MENU
			
			PA_ResetBgSys();
   			PA_ResetSpriteSys();	
			PA_Reset3DSprites();
			PA_Init2D();
						
			 PA_SetBrightness(0,-30);
			 PA_SetBrightness(1,-30);
			
		
			PA_Init16cBg(1, 0);
			PA_Init16cBg(0, 0);
		
			PA_16cCustomFont(6, bitout);	
			PA_LoadPal16(PAL_BG1, 0, bitout_Pal);
			PA_LoadPal16(PAL_BG0, 0, bitout_Pal);
			PA_16cClearZone(0,0,0,256,192);
			PA_16cClearZone(1,0,0,256,192);
			
			PA_LoadTiledBg(0, 3, bas2);
			PA_LoadTiledBg(1, 2, bas2); 
			PA_LoadTiledBg(1, 1, bghighscores); 
			//ecran = 0;	
			//affiche_ecran0();
		
			for (x=-30; x < 1; x = x + 2)
			{
			   PA_SetBrightness(0,x);
			   PA_SetBrightness(1,x);
			   PA_WaitForVBL();
			}  		

				
			ecran = 3;	
		}
		
		if (ecran == 3) { //HIGHSCORES
			
		
			PA_InitCustomKeyboard(2, keyboardcustom2); // Load the keyboard on background 2...
			
			PA_KeyboardIn(25, 95); // This scrolls the keyboard from the bottom, until it's at the right position
		
			highscoresscreen();

			
			PA_SetBrightness(0,-30);
			PA_SetBrightness(1,-30);
			
			PA_16cClearZone(0,0,0,256,192);
			PA_16cClearZone(1,0,0,256,192);
			
			PA_DeleteBg(0,2);
			PA_HideBg(1,1);
		//	PA_LoadTiledBg(0, 3, bgmenu);
		//	PA_LoadTiledBg(1, 1, bas2);  
		
			for (cnt=-30; cnt < 1; cnt = cnt + 2)
			{
			   PA_SetBrightness(0,cnt);
			   PA_SetBrightness(1,cnt);
			   PA_WaitForVBL();
			}  		
			ecran = 0;	
			affiche_ecran0();
			
		}
	
	//PA_WaitForVBL();
	
	} //Fin boucle infinie
	
	return 0;
}






//************
// FONCTIONS *
//************

void initialise_spriteslibres(){
	u8 i = 0;
	
	for (i = 2; i < NB_SPRITES; i++){
		spriteslibres[i] = 0;	
	}	
}

u8 spritelibre(){
	u8 i = 0;

	for (i = 2; i < NB_SPRITES ; i++){
		if (spriteslibres[i] == 0){
			return i;
		}
	}	
	return 0;
}

void liberesprite(u8 i){
	spriteslibres[i] = 0;
}

void occupesprite(u8 i){
	spriteslibres[i] = 1;
}

u8 choisi_cube(){
	u8 rand;
	
	if (level == 0) {
	rand = PA_RandMinMax(1,25);
	if ((rand == 2) | (rand == 4)) return 9;
	if (rand == 3) return 8; 
	
	if (score < 250) return PA_RandMinMax(1,3);
	else if (score < 500) return PA_RandMinMax(1,4);
	else if (score < 1000) return PA_RandMinMax(1,5);
	else if (score < 5000) return PA_RandMinMax(1,6);
	else return PA_RandMinMax(1,7);
	
	}
	
	else if (level == 1) {
	rand = PA_RandMinMax(1,25);
	if (rand == 2) return 9;
	if (rand == 3) return 8; 
	
	if (score < 500) return PA_RandMinMax(1,4);
	else if (score < 1000) return PA_RandMinMax(1,5);
	else if (score < 5000) return PA_RandMinMax(1,6);
	else return PA_RandMinMax(1,7);
	
	}
	
	else if (level == 2) {
	rand = PA_RandMinMax(1,25);
	if (rand == 2) return 9;
	if ((rand == 3) | (rand == 4)) return 8; 
	
	if (score < 1000) return PA_RandMinMax(1,5);
	else if (score < 5000) return PA_RandMinMax(1,6);
	else return PA_RandMinMax(1,7);
	
	}
	
}

u8 blockdanscolonne(s32 i){
	s32 j;
	
	for (j = 0; j < LARGEUR_BOARD; j++){
			if (board[i][j].type  == 8)	return 1;
			}
			
	return 0;	
	
}

u8 choisi_cube2(u8 dejablock){
	u8 rand;
	
	if (level == 0){
		rand = PA_RandMinMax(0,94);
		if ((rand < 2) & (!dejablock)) return 8;
		else if (rand < 20) return 1;
		else if (rand < 35) return 2;
		else if (rand < 50) return 3;
		else if (rand < 65) return 4;
		else if (rand < 75) return 5;
		else if (rand < 88) return 6;
		else if (rand < 93) return 7;
		else return 9;
	}
	
	else if (level == 1 ){
		rand = PA_RandMinMax(0,94);
		if ((rand < 3) & (!dejablock)) return 8;
		else if (rand < 20) return 1;
		else if (rand < 35) return 2;
		else if (rand < 50) return 3;
		else if (rand < 65) return 4;
		else if (rand < 75) return 5;
		else if (rand < 88) return 6;
		else if (rand < 93) return 7;
		else return 9;
	}
	
		else if (level == 2 ){
		rand = PA_RandMinMax(0,94);
		if ((rand < 5) & (!dejablock)) return 8;
		else if (rand < 20) return 1;
		else if (rand < 35) return 2;
		else if (rand < 50) return 3;
		else if (rand < 65) return 4;
		else if (rand < 75) return 5;
		else if (rand < 88) return 6;
		else if (rand < 93) return 7;
		else return 9;
	}
	
}

void CreateSpriteCube(u8 obj_number, u8 type,  s16 x, s16 y){
	
	if (type == 1) PA_3DCreateSpriteFromTex(obj_number, gfx[0], 16, 16,  0, x+16, y+8);
	else if (type == 2) PA_3DCreateSpriteFromTex(obj_number, gfx[1], 16, 16,  1, x+16, y+8);
	else if (type == 3) PA_3DCreateSpriteFromTex(obj_number, gfx[2], 16, 16,  2, x+16, y+8);
	else if (type == 4) PA_3DCreateSpriteFromTex(obj_number, gfx[3], 16, 16,  3, x+16, y+8);
	else if (type == 5) PA_3DCreateSpriteFromTex(obj_number, gfx[4], 16, 16,  4, x+16, y+8);
	else if (type == 6) PA_3DCreateSpriteFromTex(obj_number, gfx[5], 16, 16,  5, x+16, y+8);
	else if (type == 7) PA_3DCreateSpriteFromTex(obj_number, gfx[6], 16, 16,  6, x+16, y+8);
	else if (type == 8) PA_3DCreateSpriteFromTex(obj_number, gfx[7], 16, 16,  7, x+16, y+8);
	else if (type == 9) PA_3DCreateSpriteFromTex(obj_number, gfx[8], 16, 16,  8, x+16, y+8);
	
}


void nouvelle_ligne(){
	u8 i;
	u8 j;
	u8 typecube;
	u32 numsprite;

	
		for (i = decalage; i < LONGUEUR_BOARD-decalage; i++)
			if (board[i][ LARGEUR_BOARD-1].type !=0) gameend = 1;
			
			
		if (! gameend){	
			for (i = decalage; i < LONGUEUR_BOARD-decalage; i++)
				for (j = LARGEUR_BOARD-1; j > 0; j--){
			
					if (board[i][j-1].type != 0){
						
						board[i][j].type = board[i][j-1].type;
						PA_3DSetSpriteXY(board[i][j-1].num, 16*i+16, 176-16*j+8);	
						board[i][j].num = board[i][j-1].num;	
						board[i][j].turned = board[i][j-1].turned;				
 						//PA_3DProcess();  // Update sprites
 					//	PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  // pour debug
 					//	debugtableau();
					}
 				}	
		
			for (i = decalage; i < LONGUEUR_BOARD-decalage; i++){
			
				
				typecube = choisi_cube2(blockdanscolonne(i));
				
				board[i][0].type = typecube;
			
				board[i][0].mark = 0;
				board[i][0].points = 0;
				board[i][0].turned = 0;
				
				numsprite = spritelibre();	
				CreateSpriteCube(numsprite, typecube, 16*i, 176); 
				PA_3DSetSpritePrio(numsprite, 3);  
			//	PA_3DProcess();  // Update sprites
				board[i][0].num = numsprite;
				occupesprite(numsprite);		
				//debugtableau();
			}
			PA_3DProcess();  // Update sprites
		}					
}


void deplace_cube(){
	u8 i;
	u8 j;
	u8 end = 0;
	u8 c;
	u8 fini = 0;
	s32 typetmp;
	s32 numtmp;
	u8 uneligne = 0;
	
	s32 turnedtmp;
	PA_UpdateStylus();
	PA_UpdatePad();
	
	//debugtableau();
	
	if ((Pad.Newpress.R) | (Pad.Newpress.L) ) {
						 c = channel_libre();
			 		 if (c != 0) PA_PlaySound(c, lift2, (u32)lift2_size,127,18000);
					 nouvelle_ligne();
					 seconds2 = seconds;
					 
					  combo = 1;
					  end = 0;
					while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						uneligne = uneligne + !end;
						if (!end) {
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}
					PA_3DProcess(); 
					 
				}
	
	//PA_OutputText(1,0,0,"s%d",seconds2 -seconds); // pour debug
	else if ((timelimit != 0) & (seconds2 -seconds > 60/vitesse)) {
		 c = channel_libre();
			 if (c != 0) PA_PlaySound(c, lift2, (u32)lift2_size,127,18000);
		  nouvelle_ligne();	
		  seconds2 = seconds;
		  
		    combo = 1;
					  end = 0;
					while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						uneligne = uneligne + !end;
						if (!end) {
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}
					PA_3DProcess(); 
	}
	
	else if ((timelimit == 0) & (seconds -seconds2 > 60/vitesse)) {
		c = channel_libre();
		 if (c != 0) PA_PlaySound(c, lift2, (u32)lift2_size,127,18000);
		  nouvelle_ligne();	
		  seconds2 = seconds;
		  
		    combo = 1;
			 end = 0;
			while (!end){ // CONTROLE LE NOUVEAU TABLEAU
			end = !controle_board();
			uneligne = uneligne + !end;
			if (!end) {
						gravite_cube();
						combo ++;
					}
					affiche_score();
			}
			PA_3DProcess(); 
	}
	
	if ((Stylus.Newpress) & (board[Stylus.X/16][11-Stylus.Y/16].type != 0) & (board[Stylus.X/16][11-Stylus.Y/16].type != 8)){
			i = Stylus.X/16;
			j = 11 - Stylus.Y/16;
	 	//	PA_OutputText(1,0,0,"i%d j%d",i,j); // pour debug
	 			
				PA_3DSetSpriteTex(board[i][j].num, gfx2[board[i][j].type-1]); 
				PA_3DProcess();
				
				
				fini = 0;
				
				
				
				while ((!Stylus.Released) & (gameend == 0) & (uneligne == 0)){
					
		
					
				if (((Pad.Newpress.A) | (Pad.Newpress.Down) ) & ( board[i][j].type >1 ) 
				& ( board[i][j].type != 8 )  & ( board[i][j].type != 9 )){
					
					if (board[i][j].turned == 0){ // changement de cube 
					PA_3DSetSpriteTex(board[i][j].num, gfx[board[i][j].type-2]); 
 					PA_3DSetSpritePal(board[i][j].num, board[i][j].type-2);
 						PA_3DProcess();  // Update sprites
 					board[i][j].type = board[i][j].type -1; 			
 					board[i][j].turned = 1;
 					
 					end = 0;
 					combo = 1;
 					while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						uneligne = uneligne + !end;
						if (!end) {
							
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}
					PA_3DProcess(); 
				}
				 
				else {
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, noturn, (u32)noturn_size,120,28000);	
				}
				}
 					
				
				
				if ((board[i][j-1].type != 8) & (!fini) & (Stylus.Y > 176-(16*j)+16)) {
					typetmp = board[i][j].type;
					numtmp = board[i][j].num;
					turnedtmp = board[i][j].turned;
					
					 board[i][j].type =  board[i][j-1].type;
					// board[i][j].num =  board[i][j+1].num;
					 board[i][j].turned =  board[i][j-1].turned;
					 PA_3DSetSpriteTex(board[i][j].num, gfx[board[i][j-1].type-1]); 
					 PA_3DSetSpritePal(board[i][j].num, board[i][j-1].type-1);
					 
					 	c = channel_libre();
				 	 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
				 	
					  board[i][j-1].type =  typetmp;
					 board[i][j-1].turned =  turnedtmp;
					  PA_3DSetSpriteTex(board[i][j-1].num, gfx2[typetmp-1]);  
					  PA_3DSetSpritePal(board[i][j-1].num,typetmp-1);
					  j = j-1;
					  
					  combo = 1;
					  end = 0;
					while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						uneligne = uneligne + !end;
						if (!end) {
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}
					
					  		 
					  		 
				}
				
				if ((j < LARGEUR_BOARD) & (board[i][j+1].type != 0) & (board[i][j+1].type != 8) 
					& (!fini) & (Stylus.Y < 176-(16*j)-4)) {
					typetmp = board[i][j].type;
					numtmp = board[i][j].num;
					turnedtmp = board[i][j].turned;
					
					 board[i][j].type =  board[i][j+1].type;
					 board[i][j].turned =  board[i][j+1].turned;
					 PA_3DSetSpriteTex(board[i][j].num, gfx[board[i][j+1].type-1]); 
					 PA_3DSetSpritePal(board[i][j].num, board[i][j+1].type-1);
					 
					 	c = channel_libre();
				 	 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
				 	
					  board[i][j+1].type =  typetmp;
					 board[i][j+1].turned =  turnedtmp;
					  PA_3DSetSpriteTex(board[i][j+1].num, gfx2[typetmp-1]);  
					  PA_3DSetSpritePal(board[i][j+1].num,typetmp-1);
					j = j +1 ;
					
					end = 0;
					combo = 1;
					while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						uneligne = uneligne + !end;
						if (!end) {
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}
					PA_3DProcess();   		 
					  		 
				}
				
				
						
			//	PA_WaitForVBL();
				PA_3DProcess(); 
				
				}
				

				
				
			/*	while (!end){ // CONTROLE LE NOUVEAU TABLEAU
						end = !controle_board();
						
						if (!end) {
							gravite_cube();
							combo ++;
							}
					affiche_score();
					}*/
					
				PA_3DSetSpriteTex(board[i][j].num, gfx[board[i][j].type-1]); 
				//if (uneligne) PA_UpdateStylus();
 
				
				PA_3DProcess();
				PA_WaitForVBL();	
	}		
				
			
			
							
}

void nouveau_cube(){
	s32 j;
	s32 j2;
	s32 x;
	s32 y;
	u8 end = 0;
	u8 numsprite = 2;
	u8 c;
	
	u32 compteur = 0;
	u8 bloque = 0;
	u8 waitingvbl = 0;
	
	s32 typecube;
	u8  turned = 0;
	PA_UpdatePad ();
	typecube = choisi_cube();
//	PA_ClearTextBg(1); 
	
	x = PA_RandMinMax(0+decalage,LONGUEUR_BOARD-decalage-1);
	
	
	if (board[x][LARGEUR_BOARD-1].type != 0)  //si cube tout en haut fin du jeu
		gameend =  1;
	
	else {	
		numsprite = spritelibre();	
		CreateSpriteCube(numsprite, typecube, 16*x, 0); 
		PA_3DSetSpritePrio(numsprite, 3);  

		// y pour stopper le cube lorsque il touche un autre cube sur la meme colonne
		y = 0;
		for (j2=0; j2 < LARGEUR_BOARD; j2++){ 
			if (board[x][j2].type != 0)
				y = j2+1;
		}
	
	
		//pour animation
		j = 1;
		while (j < (176-16*y)/vitesse) { 
			
			if (PA_LidClosed()) {
					ferme = 1;
					PA_VBLCounterPause(0);
					PA_StopMod();			
					
				} 
				else {
					ferme = 0;
					PA_VBLCounterUnpause(0);
				}
			
			if (((Pad.Newpress.A) | (Pad.Newpress.Down) ) & ( typecube >1 ) & ( typecube != 8 )  & ( typecube != 9 ) 
			& (turned == 0)){ // changement de cube 
				PA_3DSetSpriteTex(numsprite, gfx[typecube-2]); 
 				PA_3DSetSpritePal(numsprite, typecube-2);
 				typecube = typecube -1; 			
 				turned = 1;
			}
					
		
		
		// DS MOTION 	
		if (PA_CheckDSMotion()){
		while ( (!bloque) & (gameend == 0)){
		
			   


				if ( (x < LONGUEUR_BOARD-decalage-1) & (Motion.Held.Right) 
			& (board[x+1][(u8)((176-vitesse*j)/16)].type == 0) & (board[x+1][(u8)((176-vitesse*j+12)/16)].type == 0)) {
					x = x +1;
					c = channel_libre();
				 	 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
					// actualisation y limite
					y = 0; 
					for (j2=0; j2 < (u8)((176-vitesse*j)/16); j2++){ 
						if (board[x][j2].type != 0)
							y = j2+1;
					}
				}
				
				//cube vers la gauche
				else if ( (x > decalage) &  (Motion.Held.Left) 
			& (board[x-1][(u8)((176-vitesse*j)/16)].type == 0) & (board[x-1][(u8)((176-vitesse*j+12)/16)].type == 0)){ //attention au passage en 3D
					x = x -1;
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
					// actualisation y limite
					y = 0; 
					for (j2=0; j2 < (u8)((176-vitesse*j)/16); j2++){ 
						if (board[x][j2].type != 0)
							y = j2+1;
					}
				}
				
			if (Motion.Newpress.Down) { //cube lache
				bloque = 1;
				j = (176-16*y)/vitesse;
			}
				
			PA_WaitForVBL();
			PA_3DProcess();  // Update sprites
		
			if (waitingvbl == 2) {		//animation seulement un vbl sur deux pour ralentis				
				if (j < (176-16*y)/vitesse )  {
					j++;	
					PA_3DSetSpriteXY(numsprite, 16*x+16, vitesse*j+8);	
				}
				else if (compteur <	10-vitesse) { compteur++; PA_SetSpriteXY(0, numsprite, 16*x+16, 176-16*y+8); } // pour probleme arondi
				else bloque = 1;				
				waitingvbl = 0;
			}
			else waitingvbl++;
		}
		}


	// FIN MOTION		
	
		 if (PA_3DSpriteTouched(numsprite)){ 
			PA_3DSetSpriteTex(numsprite, gfx2[typecube-1]); 
	
			while ((!Stylus.Released) & (!bloque) & (gameend == 0)){
			 	//	PA_OutputText(1,0,0,"type : %d",(u8)((176-vitesse*j)/16)); // pour debug
			 	//	PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  // pour debug
			 	
				if (((Pad.Newpress.A) | (Pad.Newpress.Down)) & ( typecube >1 ) & ( typecube != 8 )  & ( typecube != 9 )
				& (turned == 0)){ // changement de cube aprés cube touché
					PA_3DSetSpriteTex(numsprite, gfx[typecube-2]); 
 					PA_3DSetSpritePal(numsprite, typecube-2);	
 					typecube = typecube -1;
 					turned = 1;
				}		

				// cube vers la droite
				if ( (x < LONGUEUR_BOARD-decalage-1) & (Stylus.X > 16*(x+1)+6) 
			& (board[x+1][(u8)((176-vitesse*j)/16)].type == 0) & (board[x+1][(u8)((176-vitesse*j+12)/16)].type == 0)) {
					x = x +1;
					c = channel_libre();
				 	 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
					// actualisation y limite
					y = 0; 
					for (j2=0; j2 < (u8)((176-vitesse*j)/16); j2++){ 
						if (board[x][j2].type != 0)
							y = j2+1;
					}
				}
				
				//cube vers la gauche
				else if ( (x > decalage) & (Stylus.X < 16*(x-1)+10) 
			& (board[x-1][(u8)((176-vitesse*j)/16)].type == 0) & (board[x-1][(u8)((176-vitesse*j+12)/16)].type == 0)){ //attention au passage en 3D
					x = x -1;
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,110,28000);
					// actualisation y limite
					y = 0; 
					for (j2=0; j2 < (u8)((176-vitesse*j)/16); j2++){ 
						if (board[x][j2].type != 0)
							y = j2+1;
					}
				}
				
			PA_WaitForVBL();
			PA_3DProcess();  // Update sprites
			
		
			if (waitingvbl == 2) {		//animation seulement un vbl sur deux pour ralentis				
				if (j < (176-16*y)/vitesse )  {
					j++;	
					PA_3DSetSpriteXY(numsprite, 16*x+16, vitesse*j+8);	
				}
				else if (compteur <	10-vitesse) { compteur++; PA_SetSpriteXY(0, numsprite, 16*x+16, 176-16*y+8); } // pour probleme arondi
				else bloque = 1;				
				waitingvbl = 0;
			}
			else waitingvbl++;
		} 
		
		if ((Stylus.Released) | (gameend == 1)) {	// cube relache
			PA_3DSetSpriteTex(numsprite, gfx[typecube-1]); 
			j = (176-16*y)/vitesse;
		}	
	} // Fin cube touché
	
	
	else {  //si le sprite n est pas touche animation normale
		
		if (waitingvbl == 2){
			j++;
			PA_3DSetSpriteXY(numsprite, 16*x+16, vitesse*j+8);	
			waitingvbl = 0;
		}
		else waitingvbl++;
	}
		
	PA_WaitForVBL();
	PA_3DProcess();  // Update sprites
	
	} // Fin boucle animation
	

	c = channel_libre();
	 if (c != 0) PA_PlaySound(c, ploum2, (u32)ploum2_size,120,28000);
	
	PA_3DSetSpriteXY(numsprite,16*x+16, 176-16*y+8);
	PA_3DSetSpriteTex(numsprite, gfx[typecube-1]); 
	PA_3DSetSpritePrio(numsprite, 3);  
	PA_3DProcess();  // Update sprites	 
	occupesprite(numsprite);
	board[x][y].num = numsprite;	
	board[x][y].type = typecube;
	
	//debugtableau();
	
	combo = 1;
	while (!end){ // CONTROLE LE NOUVEAU TABLEAU
		end = !controle_board();
		if (!end) {
			gravite_cube();
			combo ++;
		}
	affiche_score();
	}
	PA_3DProcess();  // Update sprites
	//debugtableau();
}
	
}



void efface_marks(){
	s32 i;
	s32 j;
	for (i = 0+decalage; i < LONGUEUR_BOARD-decalage; i++)
		for (j = 0; j < LARGEUR_BOARD; j++)
			board[i][j].mark = 0;			
}

void update_points(s32 typ){
	s32 i;
	s32 j;
	for (i = 0+decalage; i < LONGUEUR_BOARD-decalage; i++)
		for (j = 0; j < LARGEUR_BOARD; j++)
			if (board[i][j].mark == 1)
				board[i][j].points = board[i][j].points + score_cube(typ);		
}

void debugtableau(){
	PA_ClearTextBg(1); 
	s32 i;
	s32 j;
	for (i = 0+decalage; i < LONGUEUR_BOARD-decalage; i++)
		for (j = 0; j < LARGEUR_BOARD; j++)
			PA_OutputText(1,3*i-5,2*j,"%d", board[i][j].type); 			
}


u8 verifie(i,j,t){ //retourne 1 si la ligne est complète
u8 b0 = 0;
u8 b1 = 0;
u8 b2 = 0;
u8 b3 = 0;
u8 b4 = 0;
u8 b5 = 0;
u8 b6 = 0;
u8 b7 = 0;
u8 b8 = 0;


 if ((((board[i][j].type == t) & (board[i][j].points == 0))| (board[i][j].type == 9)) & (!board[i][j].mark)){
		board[i][j].mark = 1;
		if (i == LONGUEUR_BOARD-decalage-1) b0 = 1; //au bout de la ligne
		if (j+1 < LARGEUR_BOARD) b1 = verifie(i,j+1,t);
		if (j-1 >= 0) b2 = verifie(i,j-1,t);
		if (i+1 < LONGUEUR_BOARD-decalage) b3 = verifie(i+1,j,t);
		if ((i+1 < LONGUEUR_BOARD-decalage) & (j+1 < LARGEUR_BOARD)) b4 = verifie(i+1,j+1,t);
		if ((i+1 < LONGUEUR_BOARD-decalage) & (j-1 >= 0)) b5 = verifie(i+1,j-1,t);
		if (i-1 >= decalage) b6 = verifie (i-1,j,t);
		if ((i-1 >= decalage) & (j+1 < LARGEUR_BOARD) ) b7 = verifie (i-1,j+1,t);
		if ((i-1 >= decalage) & (j-1 >= 0))  b8 = verifie (i-1,j-1,t);
	}
	
	return b0 | b1 | b2 | b3 | b4 | b5 | b6 | b7 | b8;
	
}
	

u8 verifiejoker(i,j){ // si la ligne commence par un joker verifier toutes les couleurs
u8 b[9];
u8 compteur;


for (compteur = 1; compteur < 9; compteur++){
	b[compteur] = verifie(i, j , compteur);
	if (b[compteur]) update_points(compteur);
	efface_marks();
}

	return b[1] | b[2] | b[3] | b[4] | b[5] | b[6] | b[7] | b[8];
}	
	
	
s32 score_cube(s32 type){
	if (type == 0) return 0; 
	else if (type == 1) return 1; //cube vert-rond
	else if (type == 2) return 5; //cube bleu triangle
	else if (type == 3) return 10; //cube rouge-carre
	else if (type == 4) return 25; //cube violet-losange
	else if (type == 5) return 50; //cube jaune-penta
	else if (type == 6) return 100; //cube rose-coeur
	else if (type == 7) return 500; //cube orange-etoile
	else if (type == 8) return -1; //cube block -1 points pour distinguer avec 0 points mais comptabilise pour 0
	else return 0;	 
} 	
	
u8 controle_board(){
	s32 i = 0;
	s32 j = 0;

	u8 ligneok = 0;
	u8 uneligne = 0;
	for (j = 0; j < LARGEUR_BOARD; j++){
		if (board[0+decalage][j].type == 9){
			ligneok = verifiejoker(0+decalage,j);
			uneligne = uneligne | ligneok;
		}
		else if ((board[0+decalage][j].type != 0) & (board[0+decalage][j].points == 0)) {
			ligneok = verifie(0+decalage,j,board[0+decalage][j].type);
			uneligne = uneligne | ligneok;
			if (ligneok) update_points(board[0+decalage][j].type);
			//	 PA_OutputText(1,20,20,"ligne ok"); // pour debug		
			efface_marks();
		
		}
	}
	
	
	
	//debugtableau();
	// calcul des points et effacement des lignes 
	 for (i = 0+decalage; i < LONGUEUR_BOARD-decalage; i++)
				for (j = 0; j < LARGEUR_BOARD; j++)
					if (board[i][j].points != 0 ) {
						//PA_OutputText(1,0,0,"i%d j%d", i, j); // pour debug	
						//PA_OutputText(1,0,2,"points%d", board[i][j].points); // pour debug		
						//PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  //pour debug 
						if (combo > 1)	affiche_combo();		
					
						PA_3DSetSpriteTex(board[i][j].num, gfx3[board[i][j].type-1]); 
						PA_3DProcess(); 
						PA_WaitForVBL();PA_WaitForVBL();if (combo > 1) {efface_combo(); PA_3DProcess(); }
						PA_WaitForVBL();PA_WaitForVBL();if (combo > 1)	{affiche_combo(); PA_3DProcess(); }
						PA_3DDeleteSprite(board[i][j].num);
						PA_3DProcess(); 
						liberesprite(board[i][j].num);
						if (board[i][j].points > 0 ) {
							score = score + (board[i][j].points*combo);
							affiche_score();
						}
						board[i][j].points = 0;
						board[i][j].type = 0;
						board[i][j].turned = 0;
						board[i][j].num = 0;
						board[i][j].mark = 0;			
					}	
		
 	if (combo > 1) efface_combo();

 
 			
 		
	return uneligne;
}

void gravite_cube(){
	s32 i = 0;
	s32 j = 0;
	s32 c;
	u8 end = 0;
	u8 cnt = 0;
	u8 newposition = 0;
	
		//PA_ClearTextBg(1); 
//	PA_OutputText(1,0,4,"Gravite cube"); // pour debug	

	for (i = 0+decalage; i < LONGUEUR_BOARD-decalage; i++){		
		
		for (j = 1; j < LARGEUR_BOARD; j++){		
			if (((board[i][j].type  != 0) & ( jeu == 0) & (board[i][j].type != 8))
			| ((board[i][j].type  != 0) & ( jeu == 1))){			
				newposition = 0;
				end = 0;
				for (cnt = 1; ((cnt < j+1) & (!end))  ; cnt ++)
					if ((board[i][j-cnt].type == 0) ) { 			
						newposition = cnt;
					}
					else end = 1;
		
		
				if (newposition != 0){				
					board[i][j-newposition].type = board[i][j].type;
					board[i][j-newposition].num = board[i][j].num;
					board[i][j-newposition].turned = board[i][j].turned;
					PA_3DSetSpriteXY(board[i][j-newposition].num, 16*i+16, 176-16*(j-newposition)+8);
					//	PA_OutputText(1,0,4,"num2%d", board[i][j-newposition].num); // pour debug	
					//	PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  // pour debug	
					board[i][j].type = 0; 
					board[i][j].num = 0; 
					board[i][j].turned = 0; 
					board[i][j].points = 0;
				}
			}
		
		//debugtableau();
		}
	}
	PA_3DProcess(); 
	c = channel_libre();
	 if (c != 0) PA_PlaySound(c, ploum2, (u32)ploum2_size,120,28000);		
}

void affiche_score(){
	PA_SetSpriteAnim(1, 110, score/(10*10*10*10*10)%10); 
	PA_SetSpriteAnim(1, 111, score/(10*10*10*10)%10); 
	PA_SetSpriteAnim(1, 112, score/(10*10*10)%10); 
	PA_SetSpriteAnim(1, 113, score/(10*10)%10); 
	PA_SetSpriteAnim(1, 114, score/(10)%10); 
	PA_SetSpriteAnim(1, 115, score%10); 
	
//	PA_OutputText(1,0,0,"Score : %d", score);  //pour debug
}

void affiche_combo(){
	//PA_OutputText(1,2,0,"Combo : %d", combo); //pour debug
	PA_3DCreateSpriteFromTex(250, combogfx, 32, 32,  9, 220, 18);
	PA_3DSetSpriteFrame(250, combo-2);
}

void efface_combo(){
	PA_3DDeleteSprite(250);	
}

void initboard(){
	s32 i;
	s32 j;
	s32 typecube;
	s32 numsprite;
	

	for (i = 0; i < LONGUEUR_BOARD; i++)
			for (j = 0; j < LARGEUR_BOARD; j++){
				board[i][j].type = 0;
				board[i][j].mark = 0;
				board[i][j].points = 0;
				board[i][j].turned = 0;
				board[i][j].num = 0;
			}	
	
	if (jeu == 1) {
		//PA_OutputText(1,0,0,"type : %d",decalage); // pour debug
		for (i = decalage; i < LONGUEUR_BOARD-decalage; i++)
		for (j = 0; j < 6; j++){
			typecube = choisi_cube2(blockdanscolonne(i));
			board[i][j].type = typecube;
			
			board[i][j].mark = 0;
			board[i][j].points = 0;
			board[i][j].turned = 0;
			
			numsprite = spritelibre();	
			CreateSpriteCube(numsprite, typecube, 16*i, 176-16*j); 
			PA_3DSetSpritePrio(numsprite, 3);  
			PA_3DProcess();  // Update sprites
			board[i][j].num = numsprite;
			occupesprite(numsprite);
		}
	}					
							
}

// -----------------------------------------
// Fonction EFS_Scan By Copper ^^
// ---------------- -------------------------
 
extern FILE *nds_file;// on pointe vers le fichier
 
 
extern int EFS_fscanf(EFS_FILE *file, const char *format, ...) {
    int file_pos, tokens_read;
    va_list arg;
 
    // seek to right position and scan data from buffer
    fseek(nds_file, file->seek_pos, SEEK_SET);
    file_pos = ftell(nds_file);
 
    va_start (arg, format);
    tokens_read = vfscanf(nds_file, format, arg);
    va_end (arg);
    if ((tokens_read > 0) && (!feof(nds_file)))
        file->seek_pos += ftell(nds_file) - file_pos;
    return tokens_read;
}

 

void EFS_frewind(EFS_FILE *file)
{
    EFS_fseek(file, 0, SEEK_SET);
}
 
 
 void play_newmod(){	
 // on envoie en paramètre d'entrée de la fonction à grand coup de pointeur (berk ^^)
 	char* name;
 	
 	
 			
 	if (music == 1)	name = basemods[PA_RandMax(NB_MODS-1)];
 	else name = basemods2[PA_RandMax(NB_MODS2-1)];
 	
 		//PA_OutputText(1,0,0,"music %s",name); // pour debug
 	
	char filename[256];
	sprintf ( filename, "/%s.mod", name);
	EFS_FILE* modFile = EFS_fopen (filename); 
 
	u32 modSize;
   EFS_fseek (modFile , 0 , SEEK_END);
   modSize =  EFS_ftell (modFile);
   EFS_frewind (modFile);
 
   // allocate memory to store the raw file
   char * modBuffer;
   modBuffer = (char*) malloc (sizeof(char)*modSize);
 
 
   EFS_fread (modBuffer,1,modSize,modFile);
   // close the file
   EFS_fclose (modFile);
 
 
	//playing the sound	

	PA_PlayMod(modBuffer);
		
    free(modBuffer);

}
 
void inithighscores(){
	char namefile[20] = "";
	u8 ijeu = 1;
	u8 ilevel = 0;
	u8 itime = 0;
	
	
	for (ijeu = 0; ijeu < 2; ijeu ++)
	for (ilevel = 0; ilevel < 3; ilevel++)
	for (itime = 0; itime < 3; itime ++) {
	
	sprintf(namefile,"/scores%d%d%d.sav",ijeu,ilevel,itime);
	//PA_16cText(0, 0, 0, 255, 40, namefile, 1, 6, 100);
	
	EFS_FILE *fichier = NULL;
	fichier = EFS_fopen(namefile); //On ouvre le fichier
	
 
	//Si l'ouverture a fonctionnée
	if (fichier != NULL)
	{	   
	 EFS_fscanf(fichier, "%d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s", 
	 &highscores[ijeu*90+ilevel*30+itime*10].score, &highscores[ijeu*90+ilevel*30+itime*10].nom,
	  &highscores[ijeu*90+ilevel*30+itime*10+1].score, &highscores[ijeu*90+ilevel*30+itime*10+1].nom,
	 &highscores[ijeu*90+ilevel*30+itime*10+2].score, &highscores[ijeu*90+ilevel*30+itime*10+2].nom,
	 &highscores[ijeu*90+ilevel*30+itime*10+3].score, &highscores[ijeu*90+ilevel*30+itime*10+3].nom,
	 &highscores[ijeu*90+ilevel*30+itime*10+4].score, &highscores[ijeu*90+ilevel*30+itime*10+4].nom,
	  &highscores[ijeu*90+ilevel*30+itime*10+5].score, &highscores[ijeu*90+ilevel*30+itime*10+5].nom,
	 &highscores[ijeu*90+ilevel*30+itime*10+6].score, &highscores[ijeu*90+ilevel*30+itime*10+6].nom,
	  &highscores[ijeu*90+ilevel*30+itime*10+7].score, &highscores[ijeu*90+ilevel*30+itime*10+7].nom,
	 &highscores[ijeu*90+ilevel*30+itime*10+8].score, &highscores[ijeu*90+ilevel*30+itime*10+8].nom,
	  &highscores[ijeu*90+ilevel*30+itime*10+9].score, &highscores[ijeu*90+ilevel*30+itime*10+9].nom);
	
	 EFS_fclose(fichier); //On ferme le fichier
	}
	//Si l'ouverture n'a pas fonctionnée
	else
	{   
	   fprintf(stderr, "Erreur Fichier: Ouverture du fichier échouée lors de la récupération des HighScores");// On affiche un message d'erreur
	}
	} 

	//PA_16cText(0, 0, 0, 255, 192, "Chargement terminé", 1, 6, 100);

	 
	
}


void sauv_highscores()
{   
	char namefile[20];
 		EFS_FILE* fichier = NULL;
 
		char texteAffiche[200] = ""; //


	sprintf(namefile,"/scores%d%d%d.sav",jeu,level,time);
	//PA_16cText(0, 0, 0, 200, 10, namefile , 1, 6, 100);
	fichier = EFS_fopen(namefile); //On ouvre le fichier
 
 		
		//Si l'ouverture a fonctionnée
		if (fichier != NULL)
		{
 
	 sprintf(texteAffiche, "%d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s %d %s", 
	 highscores[jeu*90+level*30+time*10].score, highscores[jeu*90+level*30+time*10].nom,
	 highscores[jeu*90+level*30+time*10+1].score, highscores[jeu*90+level*30+time*10+1].nom,
	 highscores[jeu*90+level*30+time*10+2].score, highscores[jeu*90+level*30+time*10+2].nom,
	  highscores[jeu*90+level*30+time*10+3].score, highscores[jeu*90+level*30+time*10+3].nom,
	 highscores[jeu*90+level*30+time*10+4].score, highscores[jeu*90+level*30+time*10+4].nom,
	  highscores[jeu*90+level*30+time*10+5].score, highscores[jeu*90+level*30+time*10+5].nom,
	 highscores[jeu*90+level*30+time*10+6].score, highscores[jeu*90+level*30+time*10+6].nom,
	  highscores[jeu*90+level*30+time*10+7].score, highscores[jeu*90+level*30+time*10+7].nom,
	 highscores[jeu*90+level*30+time*10+8].score, highscores[jeu*90+level*30+time*10+8].nom,
	  highscores[jeu*90+level*30+time*10+9].score, highscores[jeu*90+level*30+time*10+9].nom);
	

	
	
		
	  	EFS_fwrite(texteAffiche, 200, 1, fichier); // On écrit la chaine de caractère texteAffiche dans le fichier Test.sav 
		EFS_fclose(fichier); // On ferme le fichier
 
		 //  PA_OutputSimpleText(1, 0, 8, "You have correctly saved\nyour var !");
		}
		  // Si l'ouverture n'a pas fonctionné
		else
		{
		   // On affiche un message d'erreur
		   	PA_16cText(0, 0, 0, 200, 10, "Open saved file failed" , 1, 6, 100);
		}
 
}

void affichehighscores(){
	u8 i = 0;
	char scoretext[7];
	
	
	PA_16cClearZone(1,  0, 0, 256, 192);
	for (i = 0; i < 10; i++) {
			if (highscores[jeu*90+level*30+time*10+i].score < 10) sprintf(scoretext, "00000%d", highscores[jeu*90+level*30+time*10+i].score);
			else if (highscores[jeu*90+level*30+time*10+i].score < 100) sprintf(scoretext, "0000%d", highscores[jeu*90+level*30+time*10+i].score);
			else if (highscores[jeu*90+level*30+time*10+i].score < 1000) sprintf(scoretext, "000%d", highscores[jeu*90+level*30+time*10+i].score);
			else if (highscores[jeu*90+level*30+time*10+i].score < 10000) sprintf(scoretext, "00%d", highscores[jeu*90+level*30+time*10+i].score);
			else if (highscores[jeu*90+level*30+time*10+i].score < 100000) sprintf(scoretext, "0%d", highscores[jeu*90+level*30+time*10+i].score);
			else sprintf(scoretext, "%d", highscores[jeu*90+level*30+time*10+i].score);
	
		
		PA_16cText(1, 62, 34+i*11, 120, 45+i*11, scoretext, 1, 6, 100);	
		PA_16cText(1, 122, 34+i*11, 220, 45+i*11, (char *) highscores[jeu*90+level*30+time*10+i].nom, 1, 6, 100);	
	}



	
}

		

u8 nomvide(char nom[11]){
	u8 i;
	
	
	for (i = 0; i < 11; i++){
		if (nom[i] == '\0') return 1;
		else if (nom[i] != ' ') return 0;
	}

	return 1;
}
	
void highscoresscreen(){
		u8 iinserer = 0;
		u8 i;
		u8 c;
	
		char nom[11] = ""; // This will be our text...
		s32 nletter = 0; // Next letter to right. 0 since no letters are there yet
		char letter = ' '; // New letter to write.
		u8 newhighscore = 0;
	
		
		affichehighscores();

			for (i = 0; ((i < 10) & (!newhighscore)); i++){
			
			if (score > highscores[jeu*90+level*30+time*10+i].score) {
				 iinserer = i;
				 newhighscore = 1;
			}
			}

	
		
		//PA_OutputText(1,0,0,"i%d",iinserer); // pour debug
	
		
		if (newhighscore){
			
			
			// TO UPDATE HIGHSCORES BOARDS

				for (i = 9; i > iinserer; i--){
					highscores[jeu*90+level*30+time*10+i].score = highscores[jeu*90+level*30+time*10+i-1].score;
					strcpy(highscores[jeu*90+level*30+time*10+i].nom, highscores[jeu*90+level*30+time*10+i-1].nom);
				}
			
				highscores[jeu*90+level*30+time*10+iinserer].score = score;
				strcpy(highscores[jeu*90+level*30+time*10+iinserer].nom, "");
	
			

			affichehighscores();
			PA_16cText(0, 60, 14, 220, 34, "CONGRATULATIONS", 1, 6, 100);	
			PA_16cText(0, 35, 50, 220, 80, "Enter your name for new high score :" , 1, 6, 100);
		
			while (letter != '\n') {
						
				letter = PA_CheckKeyboard();	
						
				if ((letter > 31) & (nletter < 10)) { // there is a new letter
					c = channel_libre();
					   if (c != 0 )PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					nom[nletter] = letter;
					nletter++;
				}
			
				else if ((letter == PA_BACKSPACE)&&nletter) { // Backspace pressed
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					nletter--;
					nom[nletter] = ' '; // Erase the last letter
				}
				else if (letter == '\n'){ // Enter pressed
					c = channel_libre();
					 if (c != 0) PA_PlaySound(c, clop, (u32)clop_size,120,28000);
					nletter++;		
				}
				
				PA_16cClearZone(1,  122, 34+iinserer*11, 220, 45+iinserer*11);
				PA_16cText(1, 122, 34+iinserer*11, 220, 45+iinserer*11, (char *) nom, 1, 6, 100);	
	
				PA_WaitForVBL();
			}
			
			// UPDATE THE NAME ON HIGHSCORES BOARDS

			u8 i;
	
	
			
		
						
			if(nomvide(nom)) strcpy(nom,"NONAME");
			else for (i = 0; i < 11; i++){ //remplacer tous les espaces par underscore pour sauvegarde dans fichier
				if (nom[i] == ' ') nom[i] = '_';
			}
			
			strcpy(highscores[jeu*90+level*30+time*10+iinserer].nom, nom);
			
			sauv_highscores();
			
			affichehighscores();
			PA_16cClearZone(0, 35, 50, 220, 80);
			PA_16cText(0, 66, 35, 220, 45, "New score saved" , 1, 6, 100);
			PA_16cText(0, 20, 50, 256, 80, "Touch the screen to continue" , 1, 6, 100);
			PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  // pour debug
		}
		else {
			PA_16cText(0, 40, 14, 220, 34, "SORRY - NO HIGH SCORE", 1, 6, 100);	
			PA_16cText(0, 29, 50, 220, 80, "Touch the screen to retry" , 1, 6, 100);
			PA_WaitFor((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B));  // pour debug
		}
}
		

void initbasemods(){
	basemods[0] = "BWV847";
	basemods[1] = "BWV848";
	basemods[2] = "BWV850";
	basemods[3] = "BWV851";
	basemods[4] = "BWV852";
	basemods[5] = "BWV855";
	basemods[6] = "BWV856";
	basemods[7] = "BWV858";
	basemods[8] = "BWV860";
	basemods[9] = "BWV861";
	basemods[10] = "BWV865";
	basemods[11] = "BWV866";
	basemods[12] = "BWV871";	
	basemods[13] = "BWV872";
	basemods[14] = "BWV875";
	basemods[15] = "BWV877";
	
	
	basemods2[0] = "K025";
	basemods2[1] = "K033";
	basemods2[2] = "K035";
	basemods2[3] = "K182";
	basemods2[4] = "K187";
	basemods2[5] = "K241";
	basemods2[6] = "K293";
	basemods2[7] = "K303";
	basemods2[8] = "K307";
	basemods2[9] = "K348";
	basemods2[10] = "K362";
	basemods2[11] = "K408";
	basemods2[12] = "K445";
	basemods2[13] = "K463";
	basemods2[14] = "K466";
	basemods2[15] = "K517";
	


}

u8 channel_libre(){
	u8 i;
	
	for (i=13; i <  15; i++){
		if (!PA_SoundChannelIsBusy(i)) return i;
}
return 0;
}

void affiche_timelimit(){
	if (time == 0){
		PA_16cClearZone( 0,  80, 86, 255, 95);
		PA_16cText(0, 84, 86, 255, 100, " 5 Minutes", 1, 6, 100);		
	}
	else if (time == 1){
		PA_16cClearZone( 0,  80, 86, 255, 95);
		PA_16cText(0, 86, 86, 255, 100, "15 Minutes", 1, 6, 100);
	}
	else if (time == 2){
		PA_16cClearZone( 0,  80, 86, 255, 95);
		PA_16cText(0, 90, 86, 255, 100, " Endless", 1, 6, 100);
	}
}

void affiche_music(){
	if (music == 0){
		PA_16cClearZone( 0,  90, 136, 255, 160);
		PA_16cText(0, 96, 138, 255, 190, "No Music", 1, 6, 100);
		PA_StopMod();	
	}
	else if (music == 1){
		PA_16cClearZone( 0,  90, 136, 255, 160);
		PA_16cText(0, 92, 138, 255, 190, "Bach WTC", 1, 6, 100);
		PA_StopMod();
		play_newmod();
	}
	
	else if (music == 2){
		PA_16cClearZone( 0,  90, 136, 255, 160);
		PA_16cText(0, 92, 138, 255, 190, "Scarlatti", 1, 6, 100);
		PA_StopMod();
		play_newmod();
	}
}
	
void affiche_level(){
	if (level == 0){
		PA_16cClearZone( 0,  100, 32, 255, 78);
		PA_16cText(0, 104, 34, 255, 100, " Easy", 1, 6, 100);		
	}
	else if (level == 1){
		PA_16cClearZone( 0,  100, 32, 255, 78);
		PA_16cText(0, 102, 34, 255, 100, "Normal", 1, 6, 100);
	}
	else if (level == 2){
		PA_16cClearZone( 0,  100, 32, 255, 78);
		PA_16cText(0, 104, 34, 255, 100, " Hard", 1, 6, 100);
	}
}
	
void affiche_regle(){
	//PA_LoadTiledBg(1, 1, bas2);  
	
	PA_LoadSpritePal(1, 1, (void*)cube1_Pal); 
	PA_LoadSpritePal(1, 2, (void*)cube2_Pal); 
	PA_LoadSpritePal(1, 3, (void*)cube3_Pal); 
	PA_LoadSpritePal(1, 4, (void*)cube4_Pal); 
	
	if (jeu == 0) {
	
		PA_16cText(1, 1, 0, 255, 30, "Move falling cube with stylet to connect left with right side", 1, 6, 100);	
		PA_16cText(1, 1, 30, 255, 60, "Multiplicate your points with followed lines", 1, 6, 100);
		
		PA_16cText(1, 1, 60, 255, 80, "Downgrade once a falling cube with Down or B key", 1, 6, 100);
		PA_16cText(1, 22, 90, 255, 118, "Joker could remplace any cube and take his point number", 1, 6, 100);
		PA_CreateSprite(1, 8, (void*)joker_Sprite, OBJ_SIZE_16X16, 1, 4, 1, 90); 
		PA_16cText(1, 22, 120, 255, 140, "Block cube give no point and don't fall", 1, 6, 110);
		PA_CreateSprite(1, 7, (void*)block_Sprite, OBJ_SIZE_16X16, 1, 4, 1, 120); 
	
	}
	
	else if (jeu == 1){
		PA_16cText(1, 1, 0, 255, 30, "Move cube vertically with stylet to connect left with right side", 1, 6, 100);
		
		PA_16cText(1, 1, 30, 255, 60, "Add a new line of cubes with R or L key", 1, 6, 100);
		
		PA_16cText(1, 1, 60, 255, 80, "Downgrade once a selected cube with Down or B key", 1, 6, 100);
		PA_16cText(1, 22, 90, 255, 118, "Joker could remplace any cube and take his point number", 1, 6, 100);
		PA_CreateSprite(1, 8, (void*)joker_Sprite, OBJ_SIZE_16X16, 1, 4, 1, 90); 
		PA_16cText(1, 22, 120, 255, 140, "Block cube give no point and block moves from other cubes", 1, 6, 110);
		PA_CreateSprite(1, 7, (void*)block_Sprite, OBJ_SIZE_16X16, 1, 4, 1, 120); 		
	}
		
	PA_16cText(1, 10, 156, 50, 180, "Cube", 1, 6, 100);
	PA_16cText(1, 11, 173, 50, 192, "Pts", 1, 6, 100);
	PA_CreateSprite(1, 0, (void*)circle_Sprite, OBJ_SIZE_16X16, 1, 1, 50, 155); 
	PA_16cText(1, 46, 175, 78, 200, " 1", 1, 6, 100);
	PA_CreateSprite(1, 1, (void*)triangle_Sprite, OBJ_SIZE_16X16, 1, 1, 80, 155); 
	PA_16cText(1, 79, 175, 100, 200, " 5", 1, 6, 100);
	PA_CreateSprite(1, 2, (void*)square_Sprite, OBJ_SIZE_16X16, 1, 2, 110, 155); 
	PA_16cText(1, 102, 175, 133, 200, " 10", 1, 6, 100);
	PA_CreateSprite(1, 3, (void*)diamond_Sprite, OBJ_SIZE_16X16, 1, 2, 140, 155); 
	PA_16cText(1, 134, 175, 162, 200, " 25", 1, 6, 100);
	PA_CreateSprite(1, 4, (void*)penta_Sprite, OBJ_SIZE_16X16, 1, 3, 170, 155);
	PA_16cText(1, 163, 175, 186, 200, " 50", 1, 6, 100); 
	PA_CreateSprite(1, 5, (void*)heart_Sprite, OBJ_SIZE_16X16, 1, 3, 200, 155);
	PA_16cText(1, 187, 175, 219, 200, " 100", 1, 6, 100); 
	PA_CreateSprite(1, 6, (void*)star_Sprite, OBJ_SIZE_16X16, 1, 4, 230, 155); 
	PA_16cText(1, 220, 175, 255, 200, " 500", 1, 6, 100); 
}
	
	
void affiche_ecran0(){
	s32 x = 1;
	  	
	PA_16cText(1, 2, 130, 255, 192, "Development and Graphics by RICHARD Christophe with Palib", 1, 6, 100);	
	PA_16cText(1, 2, 160, 255, 192, "Music BACH and SCARLATTI by SANKEY John - http://sankey.ws", 1, 6, 100);	
	
	//ecran du bas		
	u16 zoom = 512; // Zoom. 256 means no zoom, 512 is twice as small, 128 is twice as big....
	PA_LoadSpritePal(1, 1, (void*)cube1_Pal); 
	PA_LoadSpritePal(1, 2, (void*)cube2_Pal); 
	PA_LoadSpritePal(1, 3, (void*)cube3_Pal); 
	PA_LoadSpritePal(1, 4, (void*)cube4_Pal); 


	PA_CreateSprite(1, 0, (void*)circle_Sprite, OBJ_SIZE_16X16, 1, 1, 0, 0); 	
	PA_SetSpriteRotEnable(1,// screen
						0,// sprite number
						0);// rotset number. You have 32 rotsets (0-31) per screen. 2 sprites with the same rotset will
							// be zoomed/rotated the same way...
	PA_SetRotsetNoAngle(1, //screen
							0, // rotset
							zoom, zoom); // Horizontal zoom, vertical zoom. You can have a sprite streched out if you want,
							// by putting the zoom only for x or y axis....

	s32 j;	
	s32 i;


	/***************/
	/****** E ******/
	/***************/
	//premier cube vert
	for (i=1; i <= Y_TITRE; i++){
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 0, X_TITRE, 4*i);
	}	
	//premiere colonne du E
	for (j=1; j < 5; j++){
		PA_CloneSprite(1,10+j,0);
		for (i=1; i <= (Y_TITRE-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 10+j, X_TITRE, 4*i);
		}
	}
	//deuxieme colonne du E
	for (j=1; j < 4; j++){
		PA_CloneSprite(1,14+j,0);
		for (i=1; i <= (Y_TITRE-(j-1)*4); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 14+j, X_TITRE+8, 4*i);
		}
	}
	for (j=1; j < 4; j++){
		PA_CloneSprite(1,17+j,0);
		for (i=1; i <= (Y_TITRE-(j-1)*4); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 17+j, X_TITRE+16, 4*i);
		}
	}
	
	/***************/
	/****** L ******/
	/***************/
	//premier cube bleu
	PA_CreateSprite(1, 1, (void*)triangle_Sprite, OBJ_SIZE_16X16, 1, 1, X_TITRE+32, 0); 
	PA_SetSpriteRotEnable(1, 1, 0);

	for (i=1; i <= Y_TITRE; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 1, X_TITRE+32, 4*i);
	}	
	//premiere colonne du L
	for (j=1; j < 5; j++){
		PA_CloneSprite(1,20+j,1);
		for (i=1; i <= (Y_TITRE-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 20+j, X_TITRE+32, 4*i);
		}
	}
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,24+j,1);
		for (i=1; i <= (Y_TITRE); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 24+j, X_TITRE+32+j*8, 4*i);
		}
	}
	
	/***************/
	/****** E ******/
	/***************/
	//premier cube rouge
	PA_CreateSprite(1, 2, (void*)square_Sprite, OBJ_SIZE_16X16, 1, 2, X_TITRE+64, 0); 
	PA_SetSpriteRotEnable(1, 2, 0);

	for (i=1; i <= Y_TITRE; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 2, X_TITRE+64, 4*i);
	}	
	//premiere colonne du E
	for (j=1; j < 5; j++){
		PA_CloneSprite(1,30+j,2);
		for (i=1; i <= (Y_TITRE-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 30+j, X_TITRE+64, 4*i);
		}
	}
	//deuxieme colonne du E
	for (j=1; j < 4; j++){
		PA_CloneSprite(1,34+j,2);
		for (i=1; i <= (Y_TITRE-(j-1)*4); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 34+j, X_TITRE+72, 4*i);
		}
	}
	for (j=1; j < 4; j++){
		PA_CloneSprite(1,37+j,2);
		for (i=1; i <= (Y_TITRE-(j-1)*4); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 37+j, X_TITRE+78, 4*i);
		}
	}
	
	/***************/
	/****** C ******/
	/***************/
	//premier cube violet
	PA_CreateSprite(1, 3, (void*)diamond_Sprite, OBJ_SIZE_16X16, 1, 2, X_TITRE+94, 0); 
	PA_SetSpriteRotEnable(1, 3, 0);

	for (i=1; i <= Y_TITRE-2; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 3, X_TITRE+94, 4*i);
	}	
	//premiere colonne du C
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,40+j,3);
		for (i=1; i <= (Y_TITRE-2-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 40+j, X_TITRE+94, 4*i);
		}
	}
	//deuxieme colonne du C
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,44+j,3);
		for (i=1; i <= (Y_TITRE-(j-1)*8); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 44+j, X_TITRE+102, 4*i);
		}
	}
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,47+j,3);
		for (i=1; i <= (Y_TITRE-(j-1)*8); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 47+j, X_TITRE+110, 4*i);
		}
	}

	/***************/
	/****** T ******/
	/***************/
	//premier cube bleu
	PA_CreateSprite(1, 4, (void*)penta_Sprite, OBJ_SIZE_16X16, 1, 3, X_TITRE+126, 0); 
	PA_SetSpriteRotEnable(1, 4, 0);

	for (i=1; i <= Y_TITRE-8; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 4, X_TITRE+126, 4*i);
	}	
	//deuxieme colonne du T
	for (j=1; j < 6; j++){
		PA_CloneSprite(1,50+j,4);
		for (i=1; i <= (Y_TITRE-2*(j-1)); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 50+j, X_TITRE+134, 4*i);
		}
	}

		PA_CloneSprite(1,56,4);
		for (i=1; i <= (Y_TITRE-8); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 56, X_TITRE+142, 4*i);
		
	}

	/***************/
	/****** R ******/
	/***************/
	//premier cube jaune
	PA_CreateSprite(1, 5, (void*)heart_Sprite, OBJ_SIZE_16X16, 1, 3, X_TITRE+158, 0); 
	PA_SetSpriteRotEnable(1, 5, 0);

	for (i=1; i <= Y_TITRE; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 5, X_TITRE+158, 4*i);
	}	
	
	for (j=1; j < 5; j++){
		PA_CloneSprite(1,60+j,5);
		for (i=1; i <= (Y_TITRE-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 60+j, X_TITRE+158, 4*i);
		}
	}
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,65+j,5);
		for (i=1; i <= (Y_TITRE-4*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 65+j, X_TITRE+166, 4*i);
		}
	}
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,68+j,5);
		for (i=1; i <= (Y_TITRE-2*(j-1)); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 68+j, X_TITRE+174, 4*i);
		}
	}
	PA_CloneSprite(1,59,5);
		for (i=1; i <= (Y_TITRE-6); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 59, X_TITRE+174, 4*i);
	}
	

	/***************/
	/****** O ******/
	/***************/
	//premier cube orange
	PA_CreateSprite(1, 6, (void*)star_Sprite, OBJ_SIZE_16X16, 1, 4, X_TITRE+190, 0); 
	PA_SetSpriteRotEnable(1, 6, 0);

	for (i=1; i <= Y_TITRE-2; i++){
	if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
	if (!passed) PA_WaitForVBL();
	PA_SetSpriteXY(1, 6, X_TITRE+190, 4*i);
	}	
	//premiere colonne du O
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,71+j,6);
		for (i=1; i <= (Y_TITRE-2-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 71+j, X_TITRE+190, 4*i);
		}
	}
	//deuxieme colonne du O
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,73+j,6);
		for (i=1; i <= (Y_TITRE-(j-1)*8); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 73+j, X_TITRE+198, 4*i);
		}
	}
	for (j=1; j < 3; j++){
		PA_CloneSprite(1,75+j,6);
		for (i=1; i <= (Y_TITRE-(j-1)*8); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 75+j, X_TITRE+206, 4*i);
		}
	}
	//quatrieme colonne du O
	for (j=1; j < 4; j++){
		PA_CloneSprite(1,77+j,6);
		for (i=1; i <= (Y_TITRE-2*j); i++){
		if ((Stylus.Newpress)||(Pad.Newpress.A)||(Pad.Newpress.B)) passed = 1;
		if (!passed) PA_WaitForVBL();
		PA_SetSpriteXY(1, 77+j, X_TITRE+214, 4*i);
		}
	}
	PA_LoadTiledBg(0, 3, bas2);
	
	
	
	PA_16cText(0, 55, 30, 255, 192, "CHOOSE TYPE OF GAME", 1, 6, 100);

	PA_LoadSpritePal(0, 1, (void*)button_Pal); 
	PA_CreateSprite(0, 100, (void*)buttonclassic_Sprite, OBJ_SIZE_64X32, 1, 1, 100, 60);
	PA_CreateSprite(0, 101, (void*)buttonright_Sprite, OBJ_SIZE_32X32, 1, 1, 164, 60); 
	PA_CreateSprite(0, 102, (void*)buttonleft_Sprite, OBJ_SIZE_32X32, 1, 1, 68, 60);  	

	PA_CreateSprite(0, 103, (void*)buttonpuzzle_Sprite, OBJ_SIZE_64X32, 1, 1, 100, 90);
	PA_CreateSprite(0, 104, (void*)buttonright_Sprite, OBJ_SIZE_32X32, 1, 1, 164, 90); 
	PA_CreateSprite(0, 105, (void*)buttonleft_Sprite, OBJ_SIZE_32X32, 1, 1, 68, 90);  


	for (x=-30; x < 1; x = x + 2)
		{
		   PA_SetBrightness(0,x);
		   PA_SetBrightness(1,x);
		   PA_WaitForVBL();
		}  		

		


}


