/*
Chocobo World Deluxe

Created with HAM software from http://www.ngine.de/

Copyright (C) 2008 David Galvez Roca AKA: Davgav
Contact me at: davgav21@hotmail.com, Subject: CHOCOBO

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <hel2.h>
#include "funciones.h"
#include "pintarfondos.h"
#include "menu.h"
#include "eventos.h"
#include "musica.h"
#include "tres.h"
#include "ResourceData.h"

#include "defGraficos.h"

#include "modules.h"
// -----------------------------------------------------------------------------
// Defines
// -----------------------------------------------------------------------------
#define OBJ_COUNT 3
#define CUADRO 5
// -----------------------------------------------------------------------------
// Structures
// -----------------------------------------------------------------------------
typedef struct TRotationObject
{
	THandle ObjNo;       // Handle of Object
	THandle RotNo;  // Handle of Rotation Set
	u16 Angle;      // Helper variable for angle
	s16 Zoom;       // Helper variable for zoom
}TRotationObject;

// -----------------------------------------------------------------------------
// Global Variables
// -----------------------------------------------------------------------------
TRotationObject ATTR_EWRAM g_Obj[OBJ_COUNT];
u8 ATTR_EWRAM ATTR_ALIGNED(4) g_ObjSystemBuffer[HEL_SUBSYSTEM_OBJ_REQUIREDMEMORY];

volatile u8 ATTR_EWRAM g_NewFrame=TRUE;
u8 ATTR_EWRAM ATTR_ALIGNED(4) g_MapSystemBuffer[HEL_SUBSYSTEM_MAP_REQUIREDMEMORY];

enum direcciones { IZQ, ABA, DER, ARR };
int direccion=IZQ;

enum estado { TITULO, MAPA, JUEGO, ENDING };
int gamestat=TITULO;

#define VELOCIDADRAPIDA 2
#define VELOCIDADLENTA 1

int velocidad=1;

int fondoX=0;
int hora=0;
int minuto=0;
int segundo=0;
u8 tiempo=0;

int nivel=1;

s16 chocoX=7;//7
s16 chocoY=7;//7
s16 offsetX=0;
s16 offsetY=0;
int npartida=0;
// Reserve memory for the Object-Rotation/Scaling-System. This buffer
// is used to manage internal states of the Object-Rotation/Scaling-System.
// You can achieve a little performance increase when you
// store it in IWRAM, but keep in mind, IWRAM is very limited!
// The recommended memory location is EWRAM.
u8 ATTR_EWRAM ATTR_ALIGNED(4) g_ObjRotScaleSystemBuffer[HEL_SUBSYSTEM_OBJROTSCALE_REQUIREDMEMORY];


u16 frames;

struct malo
{
    int graf;
	u8 hp;
	u8 fuerza;
	u8 velocidad;
};
malo malos[4];
void cargarmalos(void)
{
    malos[0].graf=RES_MONSTER1_RAW;
    malos[0].hp=10;
    malos[0].fuerza=1;
    malos[0].velocidad=40;

    malos[1].graf=RES_MONSTER2_RAW;
    malos[1].hp=14;
    malos[1].fuerza=2;
    malos[1].velocidad=30;
}
int grfchoco[16];
void cargargraficos(void)
{
	grfchoco[0]=RES_CHOCO1_RAW;
	grfchoco[1]=RES_CHOCO2_RAW;
	grfchoco[2]=RES_CHOCO1_RAW;
	grfchoco[3]=RES_CHOCO3_RAW;
	grfchoco[4]=RES_CHOCO4_RAW;
	grfchoco[5]=RES_CHOCO5_RAW;
	grfchoco[6]=RES_CHOCO4_RAW;
	grfchoco[7]=RES_CHOCO6_RAW;
	grfchoco[8]=RES_CHOCO7_RAW;
	grfchoco[9]=RES_CHOCO8_RAW;
	grfchoco[10]=RES_CHOCO7_RAW;
	grfchoco[11]=RES_CHOCO9_RAW;
	grfchoco[12]=RES_CHOCO10_RAW;
	grfchoco[13]=RES_CHOCO11_RAW;
	grfchoco[14]=RES_CHOCO10_RAW;
	grfchoco[15]=RES_CHOCO12_RAW;
}
int grfflecha[4];
void cargarFlecha(void)
{
	grfflecha[0]=RES_FLECHAIZQUIERDA_RAW;
	grfflecha[1]=RES_FLECHAABAJO_RAW;
	grfflecha[2]=RES_FLECHADERECHA_RAW;
	grfflecha[3]=RES_FLECHAARRIBA_RAW;
}



ClsMenu menu;
ClsEventos eventos;
ClsTres tresenraya;
ClsMusica musica;
Module* modulos;
// -----------------------------------------------------------------------------
// Prototypes
// -----------------------------------------------------------------------------
void InitObjects(void);
void UpdateObjects(void);
void VBLInterruptHandler(void);

void cargarsave(void)
{
    if(ham_InitRAM(RAM_TYPE_SRAM_256K))
    {
	   ham_LoadIntFromRAM("segundo", &segundo);
	   ham_LoadIntFromRAM("minuto", &minuto);
	   ham_LoadIntFromRAM("hora", &hora);
	   ham_LoadIntFromRAM("nivel", &nivel);
	   ham_LoadIntFromRAM("neventos", &menu.neventos);
	   ham_LoadIntFromRAM("numeromapa", &menu.numeromapa);
	   ham_LoadRawFromRAM("mapa",&menu.mapa);
	   ham_LoadRawFromRAM("matriz",&tresenraya.matriz);
/*        //print a success message
        ham_DrawText(3,5,"Found initialized SRAM");
        //and load a previously stored integer
        ham_LoadIntFromRAM("groovy highscore",&highscore);
        //as well as a Raw piece of data, like a string
        ham_LoadRawFromRAM("saved name",my_Name);
        ham_LoadRawFromRAM("saved street",my_Street);
        ham_LoadRawFromRAM("saved city",my_City);*/
		//ham_DrawText(1, 3,"Cargada");
    }
}
void grabarsave(void)
{
	if (gamestat==JUEGO)
	{
		ham_InitRAM(RAM_TYPE_SRAM_256K);
	//	ham_ResetRAM();
		ham_SaveIntToRAM("segundo", segundo);
		ham_SaveIntToRAM("minuto", minuto);
		ham_SaveIntToRAM("hora", hora);
		ham_SaveIntToRAM("nivel", nivel);
  		ham_SaveIntToRAM("neventos", menu.neventos);
		ham_SaveIntToRAM("numeromapa", menu.numeromapa);
		ham_SaveRawToRAM("mapa",(void *)&menu.mapa,sizeof(menu.mapa));
		ham_SaveRawToRAM("matriz",(void *)&tresenraya.matriz,sizeof(tresenraya.matriz));
		
		//ham_DrawText(1, 3,"Guardada");
	}
/*
ham_SaveIntToRAM("groovy highscore",125644);
ham_SaveRawToRAM("saved name",my_Name,22);
*/
}
void nuevaPartida(void)
{
    ham_InitRAM(RAM_TYPE_SRAM_256K);
	ham_ResetRAM();
	hora=0;
	minuto=0;
	segundo=0;
    cargar_tiles(RES_STORY_RAW, RES_STORY_RAW_SIZE16, RES_STORY_MAP, RES_STORY_PAL);
    ham_SetTextCol(235,1);
	ham_DrawText(1, 0,"Our friend Mog");
	ham_DrawText(1, 1,"Has been kidnaped!");
	ham_DrawText(1, 3,"Let's go to rescue him!");
    fadeon();
    while (true)
    {
		hel_PadCapture();
		if (frames>1200)
		{
		    break;
  		}
		if(hel_PadQuery()->Pressed.A)
		{
			break;
		}
		hel_SwiVBlankIntrWait();
    }
    //fadeoff();
}
void juego(void);
// -----------------------------------------------------------------------------
// Program Entry Point
// -----------------------------------------------------------------------------
void titulo(void)
{
    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
	musica.musica=(Module*)&mod_chocotitle;
//	musica.musica=(Module*)&mod_victory;
	musica.play();
    cargar_tiles(RES_SPLASH_RAW, RES_SPLASH_RAW_SIZE16, RES_SPLASH_MAP, RES_SPLASH_PAL);
    fadeon();
    while (true)
    {
		hel_PadCapture();
		if (frames>300)
		{
		    break;
  		}
		if(hel_PadQuery()->Pressed.A)
		{
			break;
		}
		hel_SwiVBlankIntrWait();
    }
    fadeoff();
    cargar_tiles(RES_TITULO_RAW, RES_TITULO_RAW_SIZE16, RES_TITULO_MAP, RES_TITULO_PAL);
    ham_SetTextCol(246,2);
	//int i=0;
	ham_DrawText(9,15,"-NEW GAME");
	ham_DrawText(9,16," CONTINUE GAME");
	ham_DrawText(14,19,"DAVGAV.NO-IP.ORG");
	fadeon();
	bool continuar=false;
	while (true)
	{
		hel_PadCapture();
		if(hel_PadQuery()->Pressed.Up)
		{
			ham_DrawText(9,15,"-NEW GAME");
			ham_DrawText(9,16," CONTINUE GAME");
			continuar=false;
		}
		if(hel_PadQuery()->Pressed.Down)
		{
			ham_DrawText(9,15," NEW GAME");
			ham_DrawText(9,16,"-CONTINUE GAME");
			continuar=true;
		}
		if(hel_PadQuery()->Pressed.A)
		{
			break;
		}
		hel_SwiVBlankIntrWait();
	}
	fadeoff();
	musica.musica=(Module*)&mod_chocobo;
	musica.play();
	if (continuar==true)
	{
	    cargarsave();
 	}
 	else
 	{
 	    nuevaPartida();
  	}
  	gamestat=JUEGO;
	menu.chocoX=chocoX;
	menu.chocoY=chocoY;
}
void cargarjuego(void)
{
	frames=0;
	// Initialize Object-System
	hel_ObjInit(g_ObjSystemBuffer);
	// Init the Object Rotation/Scaling System
	hel_ObjRotScaleInit(g_ObjRotScaleSystemBuffer);
	// init objects
	InitObjects();
	// load object palette
	hel_PalObjLoad256(ResData16(RES_OBJ_PAL));
	cargargraficos();
	cargarFlecha();
	cargarmalos();
	hel_SwiVBlankIntrWait();//evita el parpadeo entre pantallas (cambiar por fades)
	cargar_fondo_tile();
}
int main(void)
{
	ham_Init();
	hel_SysSetPrefetch(TRUE);
	// Start VBL Interrupt
	hel_IntrStartHandler(INT_TYPE_VBL, (void*)VBLInterruptHandler);
	hel_PadInit();
	ham_SetBgMode(0);
	titulo();
	fadeoff();
	srand((unsigned)frames);
	cargarjuego();

	menu.iniciar();
	menu.numeromapa=1;
	eventos.iniciar();
	tresenraya.iniciar();

	//ham_DrawText(1, 1,"Chocobo World");
	fadeon();
	for(;;)
	{
		juego();
		// update object graphics
		UpdateObjects();//UNUSED
		hel_SwiVBlankIntrWait();
	}
	
	return 0;
}

// -----------------------------------------------------------------------------
// Create OBJ_COUNT objects and rotation/scaling sets
// -----------------------------------------------------------------------------
void InitObjects(void)
{
	// Create Object
	g_Obj[0].ObjNo = hel_ObjCreate(
	ResData(RES_CHOCO1_RAW), // Pointer to source graphic
	OBJ_SHAPE_SQUARE,       // Obj Shape
	2,                      // Obj Size, 1 means 16x16 pixels, if Shape is set to SQUARE
	OBJ_MODE_NORMAL,        // Obj Mode
	COLORS_256,              // Use 256 color mode
	0,                      // Palette number. Only neccessary in 16 color mode
	FALSE,                  // Don't use mosaic
	TRUE,                  // Don't flip the sprite horizontally
	TRUE,                  // Don't flip the object vertically
	0,                      // Priority against background. 0=higest
	TRUE,                  // Don't make the object double-sized
	90,              // X
	60                      // Y
	);

	// Create Rotation/Scaling Set
	g_Obj[0].RotNo = hel_ObjRotScaleCreate
	(
	0,                    // Angle in degree
	128,                // ZoomX (0x100 = no zoom)
	128                 // ZoomY (0x100 = no zoom)
	);
	
	// Enable Rotation/Scaling for the Object
	hel_ObjSetRotScale(g_Obj[0].ObjNo, TRUE);
	
	// Enable Double Size
	hel_ObjSetDblSize(g_Obj[0].ObjNo, TRUE);
	
	// Select the Rotation/Scaling Set for the Object
	hel_ObjSelectRotScale(g_Obj[0].ObjNo, g_Obj[0].RotNo);
			// Create Object
	g_Obj[1].ObjNo = hel_ObjCreate(
	ResData(RES_MONSTER1_RAW), // Pointer to source graphic
	OBJ_SHAPE_SQUARE,       // Obj Shape
	2,                      // Obj Size, 1 means 16x16 pixels, if Shape is set to SQUARE
	OBJ_MODE_NORMAL,        // Obj Mode
	COLORS_256,              // Use 256 color mode
	0,                      // Palette number. Only neccessary in 16 color mode
	FALSE,                  // Don't use mosaic
	TRUE,                  // Don't flip the sprite horizontally
	TRUE,                  // Don't flip the object vertically
	0,                      // Priority against background. 0=higest
	TRUE,                  // Don't make the object double-sized
	32,              // X
	60                      // Y
	);

	// Enable Rotation/Scaling for the Object
	hel_ObjSetRotScale(g_Obj[1].ObjNo, TRUE);
	
	// Enable Double Size
	hel_ObjSetDblSize(g_Obj[1].ObjNo, TRUE);
	
	// Select the Rotation/Scaling Set for the Object
	hel_ObjSelectRotScale(g_Obj[1].ObjNo, g_Obj[0].RotNo);
	hel_ObjSetVisible(g_Obj[1].ObjNo,false);
	
	g_Obj[2].ObjNo = hel_ObjCreate(
	ResData(RES_FLECHAABAJO_RAW), // Pointer to source graphic
	OBJ_SHAPE_SQUARE,       // Obj Shape
	2,                      // Obj Size, 1 means 16x16 pixels, if Shape is set to SQUARE
	OBJ_MODE_NORMAL,        // Obj Mode
	COLORS_256,              // Use 256 color mode
	0,                      // Palette number. Only neccessary in 16 color mode
	FALSE,                  // Don't use mosaic
	TRUE,                  // Don't flip the sprite horizontally
	TRUE,                  // Don't flip the object vertically
	0,                      // Priority against background. 0=higest
	TRUE,                  // Don't make the object double-sized
	156,              // X
	50                      // Y
	);

	// Enable Rotation/Scaling for the Object
	hel_ObjSetRotScale(g_Obj[2].ObjNo, TRUE);
	
	// Enable Double Size
	hel_ObjSetDblSize(g_Obj[2].ObjNo, TRUE);
	
	// Select the Rotation/Scaling Set for the Object
	hel_ObjSelectRotScale(g_Obj[2].ObjNo, g_Obj[0].RotNo);
	hel_ObjSetVisible(g_Obj[2].ObjNo,false);
}


// -----------------------------------------------------------------------------
// Update Objects, load new graphic into Vram.
// -----------------------------------------------------------------------------
void UpdateObjects(void)
{
}

void pintar(void)
{
    //actualizamos el grafico del choco
    hel_ObjUpdateGfx(g_Obj[0].ObjNo, ResData8(grfchoco[(direccion*4)+(frames/20)%4]));
	//hel_ObjUpdateGfx(g_Obj[1].ObjNo, ResData8(RES_MONSTER1_RAW));
    //movemos el fondo
	switch (direccion)
	{
	    case ARR:
	        ham_SetBgXY(2,fondoX,offsetY);
	        offsetY-=velocidad;
	        break;
		case ABA:
	        ham_SetBgXY(2,fondoX,offsetY);
	        offsetY+=velocidad;
			break;
		case IZQ:
			ham_SetBgXY(1,fondoX,0);
			ham_SetBgXY(2,fondoX,offsetY);
			fondoX-=velocidad;
			offsetX-=velocidad;
			break;
		case DER:
	        ham_SetBgXY(1,fondoX,0);
	        ham_SetBgXY(2,fondoX,offsetY);
	        fondoX+=velocidad;
	        offsetX+=velocidad;
			break;		
 	}
 	frames+=velocidad-VELOCIDADLENTA;
}

int j=0;
int malovida=0;
void batalla(void)
{
    int tipomalo=rand()%2;
    int tiempo=1;
    int chocovida=6*nivel*1.5;
    int ataquechoco=10;
    u8 ataquemalo=10;
    u8 botonantiguo=DER;
	hel_ObjUpdateGfx(g_Obj[1].ObjNo, ResData8(malos[tipomalo].graf));
	hel_ObjSetVisible(g_Obj[1].ObjNo,true);
	//ham_DrawText(1, 15,"tipomalo:%d   ", tipomalo);
	hel_ObjSetXY(g_Obj[0].ObjNo,144,60);
    hel_ObjUpdateGfx(g_Obj[0].ObjNo, ResData8(RES_CHOCO1_RAW));
	malovida=malos[tipomalo].hp;
	musica.musica=(Module*)&mod_battle;
	musica.play();
	while (malovida>0 && chocovida>0)
	{
		hel_ObjSetXY(g_Obj[0].ObjNo,144,60-(frames/6)%3);
		hel_ObjSetXY(g_Obj[1].ObjNo,32,60-(frames/8)%3);
	    hel_PadCapture();
        if(hel_PadQuery()->Pressed.Left && botonantiguo==DER)
        {
            ataquechoco--;
            botonantiguo=IZQ;
        }
        else if(hel_PadQuery()->Pressed.Right && botonantiguo==IZQ)
        {
            ataquechoco--;
            botonantiguo=DER;
        }
        if (tiempo%50==0)
        {
            ataquechoco--;
        }
		ham_DrawText(22, 18,"TTA: %d ", ataquechoco);
        if(ataquechoco<1)
        {
            for (int i=144;i>96;i-=3)
            {
			 	hel_ObjSetXY(g_Obj[0].ObjNo,i,60-(frames/6)%3);
				hel_ObjSetXY(g_Obj[1].ObjNo,32,60-(frames/8)%3);
			 	hel_SwiVBlankIntrWait();
            }
			malovida-=(int)(nivel*1.5);
            for (int i=96;i<144;i+=3)
            {
			 	hel_ObjSetXY(g_Obj[0].ObjNo,i,60-(frames/6)%3);
	 			hel_ObjSetXY(g_Obj[1].ObjNo,32,60-(frames/8)%3);
			 	hel_SwiVBlankIntrWait();
            }
            ataquechoco=10;
        }
        if (tiempo%malos[tipomalo].velocidad==0)
        {
            ataquemalo--;
        }
		ham_DrawText(1, 18,"TTA: %d ", ataquemalo);
        if (ataquemalo==0)
        {
            for (int i=32;i<96;i+=3)
            {
				hel_ObjSetXY(g_Obj[0].ObjNo,144,60-(frames/6)%3);
	 			hel_ObjSetXY(g_Obj[1].ObjNo,i,60-(frames/8)%3);
			 	hel_SwiVBlankIntrWait();
            }
			chocovida--;
	        for (int i=96;i>32;i-=3)
            {
				hel_ObjSetXY(g_Obj[0].ObjNo,144,60-(frames/6)%3);
				hel_ObjSetXY(g_Obj[1].ObjNo,i,60-(frames/8)%3);
			 	hel_SwiVBlankIntrWait();
            }
            ataquemalo=10;
        }
		ham_DrawText(1, 19,"HP: %d/%d   ", malovida, malos[tipomalo].hp);
		ham_DrawText(19, 19,"HP: %d/%d  ", chocovida, (int)(6*nivel*1.5));
		hel_SwiVBlankIntrWait();
		tiempo++;
	}
	if (chocovida<1)
	{
    	menu.iniciar();
	}
	else
	{
		hel_ObjUpdateGfx(g_Obj[1].ObjNo, ResData8(RES_WIN_RAW));
		ham_DrawText(1, 19,"Victory      ");
		musica.musica=(Module*)&mod_victory;
		musica.play();
		while(true)
		{
		    hel_PadCapture();
	        if(hel_PadQuery()->Pressed.A)
	        {
				break;
			}
		}
		hel_ObjSetVisible(g_Obj[0].ObjNo,false);
		hel_ObjSetVisible(g_Obj[1].ObjNo,false);
		tresenraya.mostrar();
		if (tresenraya.nuevonivel==true)
		{
		    tresenraya.iniciar();
		    nivel++;
		    ham_DrawText(1, 19,"LevelUP");
	 	}
	 	else
	 	{
	 	    ham_DrawText(1, 19,"       ");
		}
	}
	fadeoff();
	hel_ObjSetVisible(g_Obj[0].ObjNo,true);
	hel_ObjSetVisible(g_Obj[1].ObjNo,false);
	hel_ObjSetXY(g_Obj[0].ObjNo,90,60);
//	ham_DrawText(1, 19,"       ");
}
void evento(void)
{
    int tipoevento=rand()%10;
 /*    if (tipoevento<3)
    {
		if (tipoevento<2)
		{
		}
		else
		{
		}
	}
    else
    {*/
        batalla();
   // }
    cargar_fondo_tile();
}
void ending(void)
{
    fadeoff();
 	 hel_ObjSetVisible(g_Obj[0].ObjNo,false);
 	 cargar_tiles(RES_ENDING_RAW, RES_ENDING_RAW_SIZE16, RES_ENDING_MAP, RES_ENDING_PAL);
 	 gamestat=ENDING;
 	 fadeon();
 	 while(1)
 	 {
   	 }
}
void juego(void)
{
    // Call hel_PadCapture once per frame
    // to capture the current pad-state
    hel_PadCapture();

    // The hel_PadQuery function returns a pointer
    // to the pad information. It has a "Pressed"
    // and "Held" member.
    if (menu.visible==false)
    {
        if (hel_PadQuery()->Held.Up)
        {
            direccion=ARR;
            velocidad=VELOCIDADRAPIDA;
        }
        else if (hel_PadQuery()->Held.Down)
        {
            direccion=ABA;
            velocidad=VELOCIDADRAPIDA;
        }
        else if (hel_PadQuery()->Held.Left)
        {
            direccion=IZQ;
            velocidad=VELOCIDADRAPIDA;
        }
        else if (hel_PadQuery()->Held.Right)
        {
            direccion=DER;
            velocidad=VELOCIDADRAPIDA;
        }
        else
        {
            velocidad=VELOCIDADLENTA;
        }
        
        if(hel_PadQuery()->Pressed.A)
        {
            fadeoff();
            hel_ObjUpdateGfx(g_Obj[2].ObjNo, ResData8(grfflecha[direccion]));
           	menu.flecha=g_Obj[2].ObjNo;
           	menu.nivel=nivel;
           	hel_ObjSetVisible(g_Obj[2].ObjNo,true);
            hel_ObjSetVisible(g_Obj[0].ObjNo,false);
            menu.show();
            cargar_fondo_tile();
           	hel_ObjSetVisible(g_Obj[2].ObjNo,false);
            hel_ObjSetVisible(g_Obj[0].ObjNo,true);
        	pintar();
			//ham_DrawText(1, 1,"Chocobo World");
			
            fadeon();
        }
/*		if(hel_PadQuery()->Pressed.L)
		{
		    grabarsave();
		}
		if(hel_PadQuery()->Pressed.R)
		{
		    cargarsave();
   			ham_DrawText(1, 3,"Cargada");
 		}*/
 		if (offsetX>CUADRO*60 || offsetY>CUADRO*60 || offsetX<0 || offsetY<0)
 		{
			if (offsetX>CUADRO*60)
			{
			    chocoX++;
			    if (chocoX>13)
			    {
			        chocoX=0;
       			}
			    offsetX=0;
	  		}
			if (offsetX<0)
			{
			    chocoX--;
   			    if (chocoX<0)
			    {
			        chocoX=13;
       			}
			    offsetX=CUADRO*60;
	  		}
			if (offsetY>CUADRO*60)
			{
			    chocoY++;
			    if (chocoY>13)
			    {
			        chocoY=0;
       			}
			    offsetY=0;
	  		}
			if (offsetY<0)
			{
			    chocoY--;
   			    if (chocoY<0)
			    {
			        chocoY=13;
       			}
			    offsetY=CUADRO*60;
	  		}
	  		menu.chocoX=chocoX;
	  		menu.chocoY=chocoY;
	  		if (menu.event(chocoX,chocoY))
	  		{
	  		    flashon();
	  		    flashoff();
	  		    evento();
				musica.musica=(Module*)&mod_chocobo;
				musica.play();
	  		    //fadeoff();
	  		    fadeon();
			 //ham_DrawText(1, 5,"EVENTO");
	    	}
	    	else
	    	{
				ham_DrawText(1, 5,"         ");
  		    	hel_ObjSetVisible(g_Obj[1].ObjNo,false);
 	    	}

 		}
		//ham_DrawText(1, 3,"%d:%02d:%02d        ", hora, minuto, segundo);
		//ham_DrawText(1, 4,"CHOCOX=%d CHOCOY=%d NEVENTOS=%d   ", chocoX, chocoY,menu.neventos);
		if (menu.neventos==0)
		{
		    if (menu.numeromapa==5)
		    {
		        ending();
      		}
		    menu.numeromapa++;
		    menu.iniciar();
  		}
        pintar();
    }
}
// -----------------------------------------------------------------------------
// VBL Interupt Handler
// -----------------------------------------------------------------------------
void VBLInterruptHandler(void)
{
    kramWorker();
	frames++;
	tiempo++;
	if (tiempo>59)
	{
		menu.segundo=segundo;
		menu.minuto=minuto;
		menu.hora=hora;
		tiempo=0;
		segundo++;
	    grabarsave();
	}
	if (segundo>59)
	{
	    segundo=0;
	    minuto++;
	}
	if (minuto>59)
	{
	    minuto=0;
	    hora++;
	}
	
	// Transmit object attributes to hardware
	hel_ObjTransmit();
	
	// Transmit Object Rotation/Scaling Attributes to hardware
	hel_ObjRotScaleTransmit();
	hel_IntrAcknowledge(INT_TYPE_VBL);
}
