/*
Chocobo World Deluxe

Created with HAM software from http://www.ngine.de/

Copyright (C) 2008 David Galvez Roca AKA: Davgav
Contact me at: davgav21@hotmail.com, Subject: CHOCOBO

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <hel2.h>
#include "funciones.h"
#include "menu.h"
#include "pintarfondos.h"

ClsMenu::ClsMenu(void)
{
}
void ClsMenu::iniciar(void)
{
    visible=false;
    estadomenu=1;
    estadomenuanterior=1;
    chocoX=5;
    chocoY=5;
    neventos=0;
    crearmapa();
}
void ClsMenu::show(void)
{
    visible=true;
	cargarmapa();
    estadomenu=1;
    estadomenuanterior=1;
    ham_SetBgXY(1,0,0); 	
    fadeon();
    while(1)
    {
        //ham_DrawText(1, 1,"Estado menu %d",estadomenu);
        // Call hel_PadCapture once per frame
        // to capture the current pad-state
        hel_PadCapture();

        // The hel_PadQuery function returns a pointer
        // to the pad information. It has a "Pressed"
        // and "Held" member.
        if(hel_PadQuery()->Pressed.Left)
        {
            estadomenu--;
            if (estadomenu<1)
            estadomenu=5;

        }
        if(hel_PadQuery()->Pressed.Right)
        {
            estadomenu++;
            if (estadomenu>5)
            estadomenu=1;

        }
        if(hel_PadQuery()->Pressed.B)
        {
            break;
        }
        hel_SwiVBlankIntrWait();
        frames++;
        if (estadomenu!=estadomenuanterior)
        {
            estadomenuanterior=estadomenu;
            fadeoff();
            hel_ObjSetVisible(flecha,false);
            switch (estadomenu)
            {
                case 1:
                {
				    hel_ObjSetVisible(flecha,true);
                    cargarmapa();
                    break;
                }
                case 2:
                {
                    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
                    cargar_tiles(RES_MENUARMA_RAW, RES_MENUARMA_RAW_SIZE16, RES_MENUARMA_MAP, RES_MENU_PAL);
        			ham_DrawText(3, 16,"Level: %d", nivel);
        			ham_DrawText(3, 18,"Hp: %d/%d",(int)(6*nivel*1.5),(int)(6*nivel*1.5));
                    break;
                }
                case 3:
                {
                    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
                    cargar_tiles(RES_MENUOBJETOS_RAW, RES_MENUOBJETOS_RAW_SIZE16, RES_MENUOBJETOS_MAP, RES_MENU_PAL);
        			ham_DrawText(3, 5,"A: 4");
        			ham_DrawText(3, 7,"B: 7");
        			ham_DrawText(3, 9,"C: 9");
        			ham_DrawText(3, 11,"D:26");
                    break;
                }
                case 4:
                {
                    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
                    cargar_tiles(RES_MENUEVENTON_RAW, RES_MENUEVENTON_RAW_SIZE16, RES_MENUEVENTON_MAP, RES_MENU_PAL);
                    break;
                }
                case 5:
                {
                    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
                    cargar_tiles(RES_MENUMOVE1_RAW, RES_MENUMOVE1_RAW_SIZE16, RES_MENUMOVE1_MAP, RES_MENU_PAL);
                    break;
                }
            }
            fadeon();
        }
        
        switch (estadomenu)
        {
            case 1:
            {
                movermapa();
                break;
			}
		}

    }
    visible=false;
    fadeoff();
}
void ClsMenu::cargarmapa(void)
{
    //void cargar_tiles(int tiles, int tilesize, int map, int paleta)
    cargar_tiles(RES_MENUMAPA_RAW, RES_MENUMAPA_RAW_SIZE16, RES_MENUMAPA_MAP, RES_MENU_PAL);
	ham_DrawText(1, 18,"MAP %d", numeromapa);
	tileevent=ham_GetMapTile(1,0,0);
	tilechoco=ham_GetMapTile(1,1,0);
	tileblanco=ham_GetMapTile(1,2,0);
	ham_SetMapTile(1,0,0,tileblanco);
	ham_SetMapTile(1,1,0,tileblanco);
	for (int i=2;i<16;i++)
	{
		for (int j=2;j<16;j++)
		{
			ham_SetMapTile(1,i,j,tileblanco);
	 	}
 	}
	for (int i=0;i<14;i++)
	{
		for (int j=0;j<14;j++)
		{
		    if (mapa[i][j]==true)
		    {
				ham_SetMapTile(1,i+2,j+2,tileevent);
      		}
	 	}
 	}
}
void ClsMenu::movermapa(void)
{
	if (frames%20==0)
	{
		ham_SetMapTile(1,chocoX+2,chocoY+2,tilechoco);
	}
	if (frames%20==10)
	{
		ham_SetMapTile(1,chocoX+2,chocoY+2,tileblanco);
	}
	ham_DrawText(10, 18,"Time: %d:%02d:%02d        ", hora, minuto, segundo);
}
void ClsMenu::crearmapa(void)
{
    for (int i=0;i<14;i++)
	{
		for (int j=0;j<14;j++)
		{
		    if (mapa[i][j]=true)
		    {
				     mapa[i][j]=false;
      		}
	 	}
 	}
	for (int i=0;i<9;i++)
	{
		mapa[rand()%13][rand()%13]=true;
		neventos=i;
	}
}
bool ClsMenu::event(int x, int y)
{
    if (mapa[x][y]==true)
    {
        mapa[x][y]=false;
        neventos--;
        if (neventos==0)
        {
            crearmapa();
        }
        return true;
    }
    else
    {
        	return false;
    }
}

