#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include "main.h"

void generateFade(float a,float b,Image *image);

#define MAXCOLOR 256
static unsigned int color[256];
void generatePalette()
{
	if(color[0]==0) {
		int i;
		for(i=0;i<MAXCOLOR;i++) {
			unsigned int r,g,b;
			g=i<MAXCOLOR/2?0:(i-MAXCOLOR/2)*128/(MAXCOLOR/2)+16;
			b=i<MAXCOLOR/2?i*128/(MAXCOLOR/2)+16:128+16;
			r=g;
			color[i]=(r<<0)|(g<<8)|(b<<16)|(255<<24);
		}
	}
	color[0]=255<<24;
}
int oldId=-1;

void generateVisualization(float a,float b,Image *image,int id)
{
	switch(id%4) {
	case 0: generateWallpaper(a,b,image); break;
	case 1: generatePlasma(a,b,image); break;
	case 2: generateJulia(a,b,image); break;
	default: generateFade(a,b,image); break;
	}
}

/** Generates a Julia set based on the input a and b values.
 * \param image the image to draw into
 * \param a the real value of the julia region to draw
 * \param b the imaginary value of the julia region to draw
 */
void generateJulia(float a,float b,Image *image)
{
	// Lazy init of the Julia color palette.
	generatePalette();
	// run through every point on the screen, setting the m,n points
	int m,n;
	float x,y;
	unsigned int *data;
	a=-a;
	b-=1.5;
	//printf("julia a=%.6g; b=%.6g\n",a,b);
	for(n=0;n<image->imageHeight;n+=2) {
		data=image->data+n*image->textureWidth;
		for(m=0;m<image->imageWidth;m+=2) {
			// the initial z value is the current pixel,  
			// so x and y have to be set to m and n
			x=3*(m-image->imageWidth/2)/(float)image->imageWidth;
			y=3*(n-image->imageHeight/2)/(float)image->imageWidth;
			// look for the escape value
			float x0=x, y0=y;
			float x16=0,y16=0;
			int i;
			for(i=1;i<127;i++) {
				// exit the loop if the number goes to infinity, where infinity is defined as 2.
				if( x*x+y*y>4) break;
				// apply the formula
				float temp = x*x - y*y + a;
				y = 2*x*y + b;
				x = temp;
				// Detect loops, and short cut them.
				if(x==x0 && y==y0) i=250;
				if(i>16 && x==x16 && y==y16) i=250;
				if(i==16) { x16=x; y16=y; }
			}
			i*=9;
			// color the pixel using the number of iterations
			// to plot the point
			data[m]=color[i%MAXCOLOR];
			data[m+1]=color[i%MAXCOLOR];
			data[m+512]=color[i%MAXCOLOR];
			data[m+513]=color[i%MAXCOLOR];
		}
	}
}

/** Generates a wallaper fractal based on the input a and b values.
 * \param image the image to draw into
 * \param a the real value of the julia region to draw
 * \param b the imaginary value of the julia region to draw
 */
void generateWallpaper(float a,float b,Image *image)
{
	// Lazy init of the Julia color palette.
	generatePalette();
	a+=0.1f;
	b+=0.1f;
	// run through every point on the screen, setting the m,n points
	int m,n;
	float x,y;
	unsigned int *data;
	for(n=0;n<image->imageHeight;n+=1) {
		data=image->data+n*image->textureWidth;
		for(m=0;m<image->imageWidth;m+=1) {
			// the initial z value is the current pixel,  
			// so x and y have to be set to m and n
			x = 50*m*a;
			y = 50*n*b;
			// look for the escape value
			int i;
			i=a+b+fmodf(x*y,256);
			if(i<0) i=-i;
			// color the pixel using the number of iterations
			// to plot the point
			data[m]=color[i%MAXCOLOR];
		}
	}
}

struct Corner {
	int x,y,color;
};

void genPlasma(struct Corner *corner,Image *image)
{
	struct Corner next[4];

	// now plot the top left corner.
	if(corner[0].x<image->imageWidth && corner[0].y<image->imageHeight) {
		image->data[corner[0].x+corner[0].y*image->textureWidth]=color[corner[0].color];
		image->data[corner[0].x+corner[0].y*image->textureWidth+1]=color[corner[0].color];
		image->data[corner[0].x+(corner[0].y+1)*image->textureWidth]=color[corner[0].color];
		image->data[corner[0].x+(corner[0].y+1)*image->textureWidth+1]=color[corner[0].color];
	}

	next[3].x=(corner[0].x+corner[3].x)/2;
	next[3].y=(corner[0].y+corner[3].y)/2;
	// abort if stuck.
	if((next[3].x==corner[0].x || next[3].x==corner[3].x) && (next[3].y==corner[0].y || next[3].y==corner[3].y)) return;

	next[0]=corner[0];
	next[1].x=(corner[0].x+corner[1].x)/2;
	next[1].y=(corner[0].y+corner[1].y)/2;
	next[1].color=(corner[0].color+corner[1].color)/2;
	next[2].x=(corner[0].x+corner[2].x)/2;
	next[2].y=(corner[0].y+corner[2].y)/2;
	next[2].color=(corner[0].color+corner[2].color)/2;
	next[3].x=(corner[0].x+corner[3].x)/2;
	next[3].y=(corner[0].y+corner[3].y)/2;
	next[3].color=(corner[0].color+corner[3].color)/2+((rand()/4096)%32)-16;
	if(next[3].color>255) next[3].color=255;
	if(next[3].color<0) next[3].color=0;
	genPlasma(next,image);
	next[0]=corner[1];
	next[2].x=(corner[1].x+corner[3].x)/2;
	next[2].y=(corner[1].y+corner[3].y)/2;
	next[2].color=(corner[1].color+corner[3].color)/2;
	genPlasma(next,image);
	next[0]=corner[3];
	next[1].x=(corner[2].x+corner[3].x)/2;
	next[1].y=(corner[2].y+corner[3].y)/2;
	next[1].color=(corner[2].color+corner[3].color)/2;
	genPlasma(next,image);
	next[0]=corner[2];
	next[2].x=(corner[2].x+corner[0].x)/2;
	next[2].y=(corner[2].y+corner[0].y)/2;
	next[2].color=(corner[2].color+corner[0].color)/2;
	genPlasma(next,image);
}

/** Generates a plasma fractal based on the input a and b values.
 * \param image the image to draw into
 * \param a the real value of the julia region to draw
 * \param b the imaginary value of the julia region to draw
 */
void generatePlasma(float a,float b,Image *image)
{
	// Lazy init of the Julia color palette.
	generatePalette();

	srand(a);

	// Generate the plazma recursively.
	struct Corner corner[4];
	corner[0].x=0;
	corner[0].y=0;
	corner[0].color=(int)(255*a)%255;
	corner[1].x=image->textureWidth;
	corner[1].y=0;
	corner[1].color=(int)(255*b)%255;
	corner[2].x=0;
	corner[2].y=image->textureWidth;
	corner[2].color=(int)(255*b)%255;
	corner[3].x=image->textureWidth;
	corner[3].y=image->textureWidth;
	corner[3].color=(int)(255*a)%255;
	genPlasma(corner,image);
}

/** Generates a fade based on the input a and b values.
 * \param image the image to draw into
 * \param a the real value of the julia region to draw
 * \param b the imaginary value of the julia region to draw
 */
void generateFade(float a,float b,Image *image)
{
	// Lazy init of the Julia color palette.
	generatePalette();
	// run through every point on the screen, setting the m,n points
	int m,n;
	float x,y;
	unsigned int *data;
	for(n=0;n<image->imageHeight;n+=1) {
		data=image->data+n*image->textureWidth;
		for(m=0;m<image->imageWidth;m+=1) {
			int i;
			x=a+m;
			y=b+n;
			i=x*x+y*y;
			if(i<0) i=-i;
			// color the pixel using the number of iterations
			// to plot the point
			data[m]=color[i%MAXCOLOR];
		}
	}
}
