#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#include <pspkernel.h>
#include <pspthreadman.h>
#include <pspgu.h>
#include <pspgum.h>
#include <pspctrl.h>
#include <psprtc.h>
#include <psppower.h>
#include <pspdisplay.h>

#include "main.h"
#include "psprubik.h"

PSP_MODULE_INFO("Sushi Rubik", 0, 1, 1);
PSP_MAIN_THREAD_ATTR(THREAD_ATTR_USER);
//PSP_MAIN_THREAD_ATTR(0);
//PSP_MODULE_INFO("Sushi Rubik", 0x1000, 1, 1);
//PSP_MAIN_THREAD_ATTR(THREAD_ATTR_VFPU);

static unsigned int __attribute__((aligned(16))) gulist[262144];
void *drawBuffer;
int controlSet=1;

struct Vertex3DCNP {
	unsigned long color;
	float nx,ny,nz;
	float x,y,z;
};

static int exitRequest = 0;
int leftface=0;
int frontface=3;
int topface=4;
int cube[48];
Image *splash;
ScePspFVector3 from={15,15,15},to={0,0,0},up={0,1,0};

#define SCR_WIDTH 480
#define SCR_HEIGHT 272

ScePspFVector3 pos[48];
ScePspFVector3 right[6];
ScePspFVector3 down[6];
ScePspFVector3 norm[6];

ScePspFVector3 fromTarget={15,15,15};
int rotateTimer=0;
int menuItem=0;
enum GameMode { MENUMODE,GAMEMODE,FREESTYLEMODE,AUTOMODE,PAUSEMODE,SOLVEDMODE } gameMode=MENUMODE;
int freestyle=0;
char alertMessage[256];
time_t startTime,bestTime,lastTime;
float faceAngle[6];
void *solver;
int visual;
int movesRemaining=1000;

char *menuModeTextEN[]={
	"Timed Solve",
	"Free Style",
	"Load",
	"Visualization",
	"Controls",
	"Franais",
	"Quit"
};
char *menuModeTextFR[]={
 	"Contre la montre",
 	"Style Libre",
 	"Charger",
 	"Visualisation",
 	"Contrles",
	"English",
 	"Quitter"
};
char **menuModeText=menuModeTextEN;
 
char *pauseModeTextEN[]={
	"Continue",
	"Undo",
	"Redo",
	"Auto Solve",
	"Save",
	"Visualization",
	"Controls",
	"Main Menu"
};
char *pauseModeTextFR[]={
	"Continuer",
	"Dfaire",
	"Refaire",
	"Auto-rsoudre",
	"Sauver",
	"Visualisation",
	"Contrles",
	"Menu Principal"
};
char **pauseModeText=pauseModeTextEN;

char *visualTextEN[]={
	"Wallpaper for the mind",
	"Plasma",
	"Julia Set",
	"Squared Wallpaper",
};
char *visualTextFR[]={
	"Papier peint pour l'esprit",
	"Plasma",
	"Ensemble Fractal Julia",
	"Papier peint carr",
};
char **visualText=visualTextEN;

char *controlSetAlertEN[3]={
	"front, left, top/bottom",
	"front, sides, top, bottom",
	"clockwise, shift for ccw",
};
char *controlSetAlertFR[3]={
 	"devant, gauche, dessus/dessous",
	"devant, cotes, dessus, dessous",
	"sens des aiguilles, sens inverse",
};
char **controlSetAlert=controlSetAlertEN; 
 
char *summaryControlSetEN[]={
	"View: analog\nView: left/right\nView: square or O\nL: up\nL':down\nF: triangle\nF': X\nU, D': L-trigger\nU', D: R-trigger\npause: START",
	"L: left\nL': right\nR: square\nR': O\nU: up\nU': triangle\nD: down\nD': X\nF: L-trigger\nF': R-trigger\nView: analog\npause: START",
	"Rotate ccw: R-trigger\nL: left\nR: right\nU: up\nD: down\nF: X\nB: triangle\nundo: L-trigger\n\nView: analog\npause: START"
};
char *summaryControlSetFR[]={
	"Vue: analogue\nVue: gauche/droite\nVue: carr ou O\nL: haut\nL':bas\nF: triangle\nF': X\nU, D': Touche-L\nU', D: Touche-R\nPause: START",
	"L: gauche\nL': droite\nR: carr\nR': O\nU: haut\nU': triangle\nD: bas\nD': X\nF: Touche-L\nF': Touche-R\nVue: analogue\nPause: START",
	"Sens inverse: \nTouche-R\nL: gauche\nR: droite\nU: haut\nD: bas\nF: X\nB: triangle\ndfaire: Touche-L\n\nVue: analogue\nPause: START"
};
char **summaryControlSet=summaryControlSetEN;

enum StatusText { STXT_SOLVE,STXT_TIMEFMT,STXT_MOVEFMT,STXT_SOLUTION,STXT_SOLVED,STXT_YOURTIME,
STXT_YOURTIMEFMT,STXT_BESTTIME,STXT_BESTTIMEFMT,STXT_CONTINUE,STXT_SAVED };
char *statusTextEN[]={
	"Solve: ",
	"%d:%02d",
	"%d of %d",
	"%d move solution",
	"You solved it!",
	"Your time: ",
	"Your time: %d:%02d",
	"Best time: ",
	"Best time: %d:%02d",
	"Press X to continue",
	"Save complete.",
};
char *statusTextFR[]={
	"Rsoudre: ",
	"%d:%02d",
	"%d de %d",
	"%d de la solution",
	"Vous l'avez rsolu!",
	"Votre temps: ",
	"Votre temps: %d:%02d",
	"Meilleur temps: ",
	"Meilleur temps: %d:%02d",
	"Appuyer sur X pour continuer",
	"Sauvegarde reussie.",
};
char **statusText=statusTextEN;

unsigned long stickerColor[6]={
	GU_RGBA(255,0,0,255),	// 0 Red
	GU_RGBA(255,255,0,255),	// 1 Yellow
	GU_RGBA(0,255,0,255),	// 2 Green
	GU_RGBA(255,128,0,255),	// 3 Orange
	GU_RGBA(0,0,255,255),	// 4 Blue
	GU_RGBA(255,255,255,255),	// 5 White
};

struct Vertex3DCNP __attribute__((aligned(16))) cubeVert[48*4+6*4*2];	//=sceGuGetMemory(sizeof(struct Vertex3DCNP)*4);

enum Buttons {
	BT_UP,BT_DOWN,BT_LEFT,BT_RIGHT,
	BT_TRIANGLE,BT_CIRCLE,BT_SQUARE,BT_CROSS,
	BT_LTRIGGER,BT_RTRIGGER,
	BT_START,BT_SELECT,BT_HOLD,
};
int lastOffset=0;

int running()
{
	return !exitRequest;
}

int exitCallback(int arg1, int arg2, void *common)
{
	exitRequest = 1;
	return 0;
}

int callbackThread(SceSize args, void *argp)
{
	int cbid;

	cbid = sceKernelCreateCallback("Exit Callback", exitCallback, NULL);
	sceKernelRegisterExitCallback(cbid);

	sceKernelSleepThreadCB();

	return 0;
}

int setupCallbacks(void)
{
	int thid = 0;

	thid = sceKernelCreateThread("update_thread", callbackThread, 0x11, 0xFA0, 0, 0);
	if(thid >= 0)
	{
		sceKernelStartThread(thid, 0, 0);
	}

	return thid;
}

void drawSplash()
{
	if(!splash) splash=loadPng("data/splashscreen.png");
	if(!splash) {
		printf("Splash not found.\n");
		return;
	}
	sceGuStart(GU_DIRECT,gulist);
//	drawCell(0,0,"data/splashscreen.png");
	sceGuCopyImage(GU_PSM_8888, 0, 0, splash->imageWidth, splash->imageHeight, splash->textureWidth, splash->data, 0, 0, 512, (Color *)((unsigned int)drawBuffer+0x4000000));
	sceGuFinish();
	sceGuSync(0,0);
	sceDisplayWaitVblankStart();
	drawBuffer=sceGuSwapBuffers();
	pspDebugScreenSetOffset((int)drawBuffer);

	int i;
	for(i=0;i<90;i++) sceDisplayWaitVblankStart();
//	freeCells();
	freeImage(splash);
	splash=0;
}

void init()
{
	sceGuStart(GU_DIRECT,gulist);

	sceGuOffset(2048 - (SCR_WIDTH/2),2048 - (SCR_HEIGHT/2));
	sceGuViewport(2048,2048,SCR_WIDTH,SCR_HEIGHT);
	sceGuScissor(0,0,SCR_WIDTH,SCR_HEIGHT);
	sceGuEnable(GU_SCISSOR_TEST);
	sceGuDepthFunc(GU_GEQUAL);
	sceGuEnable(GU_DEPTH_TEST);
	sceGuFrontFace(GU_CCW);
	sceGuShadeModel(GU_SMOOTH);
	//sceGuEnable(GU_LINE_SMOOTH);
	sceGuEnable(GU_CULL_FACE);
	sceGuEnable(GU_CLIP_PLANES);
	//sceGuDisable(GU_CLIP_PLANES);

	sceGuTexMode(GU_PSM_8888,0,0,0);
	//sceGuEnable(GU_BLEND);
	sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
	sceGuTexFunc(GU_TFX_ADD,GU_TCC_RGB);
	//sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	sceGuTexEnvColor(0xffff00);
	sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	sceGuTexScale(1.0f,1.0f);

	sceGumMatrixMode(GU_PROJECTION);
	sceGumLoadIdentity();
	sceGumPerspective(45.0f,16.0f/9.0f,2.0f,100.0f);
	sceGumMatrixMode(GU_VIEW);	
	sceGumLoadIdentity();
	sceGumMatrixMode(GU_MODEL);
	sceGumLoadIdentity();
	sceGuDepthRange(65535,0);
	sceGuDepthFunc(GU_GEQUAL);

	sceGuDisable(GU_TEXTURE_2D);
	sceGuDisable(GU_BLEND);
	//sceGuEnable(GU_DEPTH_TEST);
	sceGuDisable(GU_DEPTH_TEST);
	//sceGuDisable(GU_CULL_FACE);
	sceGuDisable(GU_ALPHA_TEST);
	//sceGuDisable(GU_CLIP_PLANES);

	sceGuEnable(GU_LIGHTING);
	sceGuEnable(GU_LIGHT0);
	sceGuEnable(GU_LIGHT1);
	sceGuEnable(GU_LIGHT2);
	ScePspFVector3 key={-1,-1,-1},fill={1,0,-1},back={0,-1,1};
	sceGuLight( 0, GU_DIRECTIONAL, GU_DIFFUSE_AND_SPECULAR, &key);
	sceGuLightColor( 0, GU_DIFFUSE, 0xffffffff);
	sceGuLightColor( 0, GU_SPECULAR, 0xffffffff);
	sceGuLightAtt(0,0.0f,1.0f,0.0f);
	sceGuLight( 1, GU_DIRECTIONAL, GU_DIFFUSE_AND_SPECULAR, &fill);
	sceGuLightColor( 1, GU_DIFFUSE, 0xff202020);
	sceGuLightColor( 1, GU_SPECULAR, 0xff000000);
	sceGuLightAtt(1,0.0f,1.0f,0.0f);
	sceGuLight( 2, GU_DIRECTIONAL, GU_DIFFUSE_AND_SPECULAR, &back);
	sceGuLightColor( 1, GU_DIFFUSE, 0xff808080);
	sceGuLightColor( 1, GU_SPECULAR, 0xff000000);
	sceGuLightAtt(2,0.0f,1.0f,0.0f);
	sceGuSpecular(12.0f);
	sceGuAmbient(0xff202020);
	sceGuAmbientColor(0xffffffff);
	sceGuFinish();
	sceGuSync(0,0);
}

void drawSprite(int sx, int sy, int width, int height, Image* source, int dx, int dy)
{
	sceGuTexFunc(GU_TFX_REPLACE,GU_TCC_RGBA);
	sceGuTexMode(GU_PSM_8888, 0, 0, source->isSwizzled);
	sceGuTexImage(0, source->textureWidth, source->textureHeight, source->textureWidth, source->data);

	float u = 1.0f / ((float)source->textureWidth);
	float v = 1.0f / ((float)source->textureHeight);
	sceGuTexScale(u, v);
	
	sceGuDisable(GU_DEPTH_TEST);
	int j = 0;
	while (j < width) {
		struct BlitVertex {
        unsigned short u,v;
        short x,y,z;
		} *vertices = (struct BlitVertex*) sceGuGetMemory(2 * sizeof(struct BlitVertex));
		int sliceWidth = 64;
		if (j + sliceWidth > width) sliceWidth = width - j;
		vertices[0].u = sx + j;
		vertices[0].v = sy;
		vertices[0].x = dx + j;
		vertices[0].y = dy;
		vertices[0].z = 1;
		vertices[1].u = sx + j + sliceWidth;
		vertices[1].v = sy + height;
		vertices[1].x = dx + j + sliceWidth;
		vertices[1].y = dy + height;
		vertices[1].z = 1;
		sceGuDrawArray(GU_SPRITES, GU_TEXTURE_16BIT | GU_VERTEX_16BIT | GU_TRANSFORM_2D, 2, 0, vertices);
		j += sliceWidth;
	}
	sceGuEnable(GU_DEPTH_TEST);
	sceGuTexScale(1.0f, 1.0f);
}

void drawFilledRect(int x, int y, int width, int height, unsigned color) {
    struct RectVertex {
		unsigned int color;
		short x,y,z;
	} *vert = sceGuGetMemory(2 * sizeof(struct RectVertex));
    vert[0].x = x;
    vert[0].y = y;
    vert[0].z = 0;
    vert[0].color = color;
    vert[1].x = x+width;
    vert[1].y = y+height;
    vert[1].z = 0;
    vert[1].color = color;
    sceGuDisable(GU_TEXTURE_2D);
    sceGuEnable(GU_BLEND);
    sceGuDisable(GU_DEPTH_TEST);
    sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
    sceGuDrawArray(GU_SPRITES, GU_COLOR_8888 | GU_VERTEX_16BIT | GU_TRANSFORM_2D, 2,0,vert);
    sceGuEnable(GU_TEXTURE_2D);
}	

void inline setVertScale(int face,struct Vertex3DCNP *vert,int i,float x,float y,float z,float scale)
{
	int n=i/8;

	int v;
	for(v=0;v<4;v++) {	
		vert[v].color=stickerColor[face];
		vert[v].nx=norm[n].x;
		vert[v].ny=norm[n].y;
		vert[v].nz=norm[n].z;
		vert[v].x=x+norm[n].x*1.5f/scale;
		vert[v].y=y+norm[n].y*1.5f/scale;
		vert[v].z=z+norm[n].z*1.5f/scale;
		if(v==1 || v==3) {
			vert[v].x+=right[n].x/2*scale;
			vert[v].y+=right[n].y/2*scale;
			vert[v].z+=right[n].z/2*scale;
		} else {
			vert[v].x-=right[n].x/2*scale;
			vert[v].y-=right[n].y/2*scale;
			vert[v].z-=right[n].z/2*scale;
		}			
		if(v==2 || v==3) {
			vert[v].x+=down[n].x/2*scale;
			vert[v].y+=down[n].y/2*scale;
			vert[v].z+=down[n].z/2*scale;
		} else {
			vert[v].x-=down[n].x/2*scale;
			vert[v].y-=down[n].y/2*scale;
			vert[v].z-=down[n].z/2*scale;
		}
	}
//	printf("0x%08x: 0x%08x,(%g,%g,%g),(%.3g,%.3g,%.3g)\n",(int)vert,vert->color,vert->nx,vert->ny,vert->nz,vert->x,vert->y,vert->z);
}

void setVert(int face,struct Vertex3DCNP *vert,int i,float x,float y,float z)
{
	setVertScale(face,vert,i,x,y,z,1.0f);
}


void initCubeVert()
{
	struct Face *face=build_positions();
	int i,j=0;
	for(i=0;i<8*6;i++) {
		pos[j*8+i].x=face[j*8+i].x*3;
		pos[j*8+i].y=face[j*8+i].y*3;
		pos[j*8+i].z=face[j*8+i].z*3;
		//printf("pos[%d*8+%d]=<%g,%g,%g>\n",j,i,pos[j*8+i].x,pos[j*8+i].y,pos[j*8+i].z);
	}
	for(i=0;i<6;i++) {
		right[i].x=(pos[i*8+1].x-pos[i*8].x)*0.90f;
		down[i].x=(pos[i*8+2].x-pos[i*8+1].x)*0.90f;
		right[i].y=(pos[i*8+1].y-pos[i*8].y)*0.90f;
		down[i].y=(pos[i*8+2].y-pos[i*8+1].y)*0.90f;
		right[i].z=(pos[i*8+1].z-pos[i*8].z)*0.90f;
		down[i].z=(pos[i*8+2].z-pos[i*8+1].z)*0.90f;
		norm[i].x=face[i*8].nx;
		norm[i].y=face[i*8].ny;
		norm[i].z=face[i*8].nz;
		setVert(i,cubeVert+48*4+i*4,i*8,pos[i*8+0].x+down[i].x*(1/0.90f),pos[i*8+0].y+down[i].y*(1/0.90f),pos[i*8+0].z+down[i].z*(1/0.90f));
		setVertScale(i,cubeVert+48*4+6*4+i*4,i*8,pos[i*8+0].x+down[i].x*(1/0.90f),pos[i*8+0].y+down[i].y*(1/0.90f),pos[i*8+0].z+down[i].z*(1/0.90f),1/0.9f);
		cubeVert[48*4+6*4+i*4].color=GU_RGBA(32,32,32,255);
		cubeVert[48*4+6*4+i*4+1].color=GU_RGBA(32,32,32,255);
		cubeVert[48*4+6*4+i*4+2].color=GU_RGBA(32,32,32,255);
		cubeVert[48*4+6*4+i*4+3].color=GU_RGBA(32,32,32,255);
	}
	FILE *file=fopen("data/besttime","r");
	if(file) {
		fread(&bestTime,sizeof(time_t),1,file);
		fclose(file);
	}
}

int oppositeface(int face)
{
	switch(face) {
	case 0: return 5;
	case 1: return 3;
	case 2: return 4;
	case 3: return 1;
	case 4: return 2;
	}
	return 0;
}

void fixfacing()
{
	int xp=fromTarget.x<0?4:0;	// camera x is positive
	int zp=fromTarget.z<0?2:0;	// camera z is positive
	int yp=fromTarget.y<0?1:0;	// camera y is positive
	int facing=xp+yp+zp;
	switch(facing) {
	case 0: topface=1; leftface=0; frontface=2; break;
	case 1: topface=3; leftface=0; frontface=2; break;
	case 2: topface=1; leftface=2; frontface=5; break;
	case 3: topface=3; leftface=2; frontface=5; break;
	case 4: topface=1; leftface=4; frontface=0; break;
	case 5: topface=3; leftface=4; frontface=0; break;
	case 6: topface=1; leftface=5; frontface=4; break;
	case 7: topface=3; leftface=5; frontface=4; break;
	}
	//printf("from=%g,%g,%g; facing (%d): t=%d, l=%d, f=%d\n",fromTarget.x,fromTarget.y,fromTarget.z,facing,topface,leftface,frontface);
}

Image *background;
Image *bg[2];
int nextBg;
#define adj(x) (adjoin_table[(x)])
extern int adjoin_table[48];

Image *newImage(int width,int height)
{
	Image *image=calloc(sizeof(Image),1);
	image->imageWidth=width;
	image->textureWidth=512;
	while((image->textureWidth>>1)>width) image->textureWidth>>=1;
	image->imageHeight=height;
	image->textureHeight=512;
	while((image->textureHeight>>1)>height) image->textureHeight>>=1;

	image->data=malloc(image->textureHeight*image->textureWidth*4);

	return image;
}

float juliaA=1/6.0f,juliaB=1/3.0f;
SceUID visualThreadId;
int visualRequestId;
int visualFulfillId;

int visualThread(SceSize args,void *argp)
{
	while(running()) {
		if(visualRequestId==visualFulfillId) {
			sceKernelDelayThread(1000000/60);	// delay 1/60th of second
		} else {
			visualFulfillId=visualRequestId;
			
			generateVisualization(juliaA,juliaB,bg[nextBg],visual);
			background=bg[nextBg];
			nextBg=(nextBg+1)&1;
		}
	}
	return 0;
}

void draw()
{
	pspDebugScreenSetXY(0,1);
	sceGuStart(GU_DIRECT,gulist);
	// clear screen
	sceGuClearColor(GU_RGBA(0,0,64,255));
	sceGuClearDepth(0);
	sceGuClear(GU_COLOR_BUFFER_BIT|GU_DEPTH_BUFFER_BIT);
	if(!background) {
		background=newImage(480,272);
		generateVisualization(juliaA,juliaB,background,visual);
		bg[0]=background;
		bg[1]=newImage(480,272);
		nextBg=1;
		visualThreadId=sceKernelCreateThread("visualization",visualThread,0x28,0x10000,0,NULL);
		if(visualThreadId >= 0) sceKernelStartThread(visualThreadId, 0, 0);
	}
	sceGuCopyImage(GU_PSM_8888, 0, 0, background->imageWidth, background->imageHeight, background->textureWidth, background->data, 0, 0, 512, (Color *)((unsigned int)drawBuffer+0x4000000));

	if(gameMode==FREESTYLEMODE || gameMode==GAMEMODE) {
		static int bg=0;
		bg=(bg+1)&255;
		int g=bg;
		if(bg&32) g=31-(bg&31);
		drawFilledRect(0,0,128,272,GU_RGBA(192|(255-g),192|g,192|(255-g),0xc0));
		char buf[256];
		sprintf(buf,"%s\n",summaryControlSet[controlSet]);
		drawMessageFormat(0,0,FONT_SMALL,buf);
	}

	sceGumMatrixMode(GU_VIEW);
	sceGumLoadIdentity();
	sceGumLookAt((ScePspFVector3 *)&from,(ScePspFVector3 *)&to,(ScePspFVector3 *)&up);
	sceGumMatrixMode(GU_MODEL);
	sceGumLoadIdentity();
	sceGuFrontFace(GU_CCW);
	//sceGuFrontFace(GU_CW);

	sceGuDisable(GU_TEXTURE_2D);
	sceGuEnable(GU_DEPTH_TEST);
	int i;
#if 1
	int max=48;
	sceGuFrontFace(GU_CW);
	for(i=0;i<max;i++) {
//		printf("Drawing item %d\n",i);
		sceGumMatrixMode(GU_MODEL);
		sceGumPushMatrix();
		int j;
		for(j=0;j<6;j++) {
			float a=faceAngle[j];
			if(i/8==j || adj(i)/8==j || adj(adj(i))/8==j) {
				ScePspFVector3 rot={a*norm[j].x,a*norm[j].y,a*norm[j].z};
				sceGumRotateXYZ(&rot);
			}
		}
		//sceGumMultMatrix((ScePspFMatrix4 *)faceMatrix[i]);
		struct Vertex3DCNP *vertBlack=sceGuGetMemory(sizeof(struct Vertex3DCNP)*4);
		setVertScale(cube[i],&vertBlack[0],i,pos[i].x,pos[i].y,pos[i].z,1.0f/0.9f);
		vertBlack[0].color=GU_RGBA(32,32,32,255);
		vertBlack[1].color=GU_RGBA(32,32,32,255);
		vertBlack[2].color=GU_RGBA(32,32,32,255);
		vertBlack[3].color=GU_RGBA(32,32,32,255);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vertBlack);
		sceGuFrontFace(GU_CCW);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vertBlack);
		sceGuFrontFace(GU_CW);

		struct Vertex3DCNP *vert=sceGuGetMemory(sizeof(struct Vertex3DCNP)*4);
		//struct Vertex3DCNP *vert=&cubeVert[i*4];
		setVert(cube[i],&vert[0],i,pos[i].x,pos[i].y,pos[i].z);

		//sceKernelDcacheWritebackAll();	
//		sceGuDisable(GU_LIGHTING);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vert);
//		sceGuFrontFace(GU_CCW);
//		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vert);
//		sceGuEnable(GU_LIGHTING);
		sceGumPopMatrix();
	}
#endif
	struct Vertex3DCNP *vert=&cubeVert[48*4];
	struct Vertex3DCNP *vertBlack=&cubeVert[48*4+6*4];
	for(i=0;i<6;i++) {
		sceGumMatrixMode(GU_MODEL);
		sceGumPushMatrix();
		float a=faceAngle[i];
		ScePspFVector3 rot={a*norm[i].x,a*norm[i].y,a*norm[i].z};
		sceGumRotateXYZ(&rot);
		struct Vertex3DCNP *v=sceGuGetMemory(sizeof(struct Vertex3DCNP)*4);
		struct Vertex3DCNP *vBlack=sceGuGetMemory(sizeof(struct Vertex3DCNP)*4);
		memcpy(vBlack,vertBlack,sizeof(struct Vertex3DCNP)*4);
		memcpy(v,vert,sizeof(struct Vertex3DCNP)*4);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vBlack);
		sceGuFrontFace(GU_CCW);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,vBlack);
		sceGuFrontFace(GU_CW);
		sceGumDrawArray(GU_TRIANGLE_STRIP,GU_VERTEX_32BITF|GU_COLOR_8888|GU_NORMAL_32BITF|GU_TRANSFORM_3D,4,0,v);
		sceGumPopMatrix();
		vert+=4;
		vertBlack+=4;
	}
//	sceGuFrontFace(GU_CCW);
	sceGuDisable(GU_LIGHTING);
	sceGuFrontFace(GU_CW);
	sceGuEnable(GU_TEXTURE_2D);
	sceGuEnable(GU_BLEND);

	if(gameMode==MENUMODE || gameMode==PAUSEMODE) {
		int i;
		int x=0,y=0,w=0,h=0;
		char **text=gameMode==MENUMODE?menuModeText:pauseModeText;
		int max=gameMode==MENUMODE?7:8;
		for(i=0;i<max;i++) {
			extentMessage(&x,&y,FONT_BODY,text[i]);
			h+=y-4;
			if(w<x) w=x;
		}
		if(strlen(alertMessage)>0) {
			extentMessage(&x,&y,FONT_SMALL,alertMessage);
			h+=y;
			if(w<x) w=x;
		} else {
			h+=4;
		}
		w+=10;
		h+=10;
		x=480/2-w/2;
		y=272/2-h/2;
		// Text box
		drawFilledRect(x-5,y-5,w,h,GU_RGBA(0xc0,0xc0,0xc0,0xc0));
		// Shadow
		drawFilledRect(x-5+w,y+5,10,h,GU_RGBA(0,0,0,0x80));
		drawFilledRect(x+5,y-5+h,w,10,GU_RGBA(0,0,0,0x80));
		// Outline
		drawFilledRect(x-5,y-5,1,h,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5,y-5,w,1,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5+w,y-5,1,h,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5,y-5+h,w,1,GU_RGBA(0,64,16,0xff));
		
		for(i=0;i<max;i++) {
			int xx=0,yy=0;
			int highlight=(i==menuItem);
			extentMessage(&xx,&yy,FONT_BODY,text[i]);
			drawMessage(480/2-xx/2,y,highlight==0?FONT_BODY:FONT_BODYHIGHLIGHT,text[i]);
			y+=yy-4;
		}
		if(strlen(alertMessage)>0) {
			int xx=0,yy=0;
			extentMessage(&xx,&yy,FONT_SMALL,alertMessage);
			drawMessage(480/2-xx/2,y,FONT_SMALL,alertMessage);
		}
	}

	if(gameMode==GAMEMODE || gameMode==SOLVEDMODE) {
		time_t currentTime=time(0);
		currentTime=currentTime-startTime;
		if(gameMode==SOLVEDMODE) currentTime=lastTime;
		char msg[64]="";
		if(gameMode==SOLVEDMODE) strcpy(msg,statusText[STXT_SOLVE]);
		strcat(msg,statusText[STXT_TIMEFMT]);
		char buf[256];
		sprintf(buf,msg,(int)currentTime/60,(int)currentTime%60);
		int x,y;
		extentMessage(&x,&y,FONT_MESSAGE,buf);
		drawMessage(480-x-2,2,FONT_MESSAGE,buf);
	}
	if(gameMode==GAMEMODE || gameMode==SOLVEDMODE || gameMode==FREESTYLEMODE || gameMode==AUTOMODE) {
		int x,y;
		char buf[256];
		sprintf(buf,statusText[STXT_SOLUTION],movesRemaining);
		extentMessage(&x,&y,FONT_MESSAGE,buf);
		drawMessage(480-x-2,272-y-2,FONT_MESSAGE,buf);
		int yy=272-y-2;
		sprintf(buf,statusText[STXT_MOVEFMT],undo_length(),undo_length()+redo_length());
		extentMessage(&x,&y,FONT_MESSAGE,buf);
		drawMessage(480-x-2,yy-y-2,FONT_MESSAGE,buf);
	}
	if(gameMode==SOLVEDMODE) {
		int x,y,w,h;
		char *solve=statusText[STXT_SOLVED];
		extentMessage(&w,&h,FONT_MESSAGE,solve);
		y=100;
		x=480/2-w;	// A generous size.
		w*=2;
		// Text box
		drawFilledRect(x-5,y-5,w,h*5,GU_RGBA(0xc0,0xc0,0xc0,0xe0));
		// Shadow
		drawFilledRect(x-5+w,y+5,10,h*5,GU_RGBA(0,0,0,0x80));
		drawFilledRect(x+5,y-5+h*5,w,10,GU_RGBA(0,0,0,0x80));
		// Outline
		drawFilledRect(x-5,y-5,1,h*5,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5,y-5,w,1,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5+w,y-5,1,h*5,GU_RGBA(0,64,16,0xff));
		drawFilledRect(x-5,y-5+h*5,w,1,GU_RGBA(0,64,16,0xff));
		w/=2;

		drawMessage(480/2-w/2,y,FONT_MESSAGE,solve);
		y+=h;
		char buf[256];
		sprintf(buf,statusText[STXT_YOURTIME]);
		extentMessage(&w,&h,FONT_MESSAGE,buf);
		sprintf(buf,statusText[STXT_YOURTIMEFMT],(int)lastTime/60,(int)lastTime%60);
		drawMessage(480/2-w,y,FONT_MESSAGE,buf);
		y+=h;
		sprintf(buf,statusText[STXT_BESTTIME]);
		extentMessage(&w,&h,FONT_MESSAGE,buf);
		sprintf(buf,statusText[STXT_BESTTIMEFMT],(int)bestTime/60,(int)bestTime%60);
		drawMessage(480/2-w,y,FONT_MESSAGE,buf);
		y+=h;
		solve=statusText[STXT_CONTINUE];
		extentMessage(&w,&h,FONT_SMALL,solve);
		drawFilledRect(480/2-w/2,y,w,h,GU_RGBA(255,255,255,255));
		drawMessage(480/2-w/2,y,FONT_SMALL,solve);
		y+=h;
	}
	
	sceGuFinish();
	sceGuSync(0,0);
	
	sceDisplayWaitVblankStart();
	drawBuffer=sceGuSwapBuffers();
	pspDebugScreenSetOffset((int)drawBuffer);
	//printf("Draw buffer = %d\n",(int)drawBuffer);
}

void setMode(enum GameMode mode)
{
	//printf("Set mode to i%d->%d\n",gameMode,mode);
	if(mode==GAMEMODE && gameMode!=PAUSEMODE) {
		printf("startTime was %d\n",(int)startTime);
		time(&startTime);
		printf("startTime is %d\n",(int)startTime);
	}
	gameMode=mode;
	menuItem=0;
	alertMessage[0]=0;
	if(gameMode==GAMEMODE) {
		freestyle=0;
	}
	if(gameMode==FREESTYLEMODE) freestyle=1;
}

void anim_ccw(int cube[],int face)
{
	int i;
	for(i=0;i<6;i++) faceAngle[i]=0;
	faceAngle[face]=-GU_PI/2;
	turn_ccw(cube,face);	
	visualRequestId++;
	//generateVisualization(juliaA,juliaB,background,visual);
	if(gameMode!=AUTOMODE) {
		int moves=moves_remaining(init_solver(cube));
		if(moves>movesRemaining) movesRemaining++;
		else movesRemaining=moves;
	}
}

void anim_cw(int cube[],int face)
{
	int i;
	for(i=0;i<6;i++) faceAngle[i]=0;
	faceAngle[face]=GU_PI/2;
	turn_cw(cube,face);
	//generateVisualization(juliaA,juliaB,background,visual);
	visualRequestId++;
	if(gameMode!=AUTOMODE) {
		int moves=moves_remaining(init_solver(cube));
		if(moves>movesRemaining) movesRemaining++;
		else movesRemaining=moves;
	}
}

void update(unsigned long elapsed)
{
	// Do any pending animation.
	from.x=from.x*0.95f+fromTarget.x*0.05f;
	from.y=from.y*0.95f+fromTarget.y*0.05f;
	from.z=from.z*0.95f+fromTarget.z*0.05f;
	if(rotateTimer>0) {
		rotateTimer-=elapsed;
		if(rotateTimer<0) rotateTimer=0;
	}
	int i;
	float max=0;
	for(i=0;i<6;i++) {
		faceAngle[i]=faceAngle[i]*0.80f;
		if(faceAngle[i]>0 && max<faceAngle[i]) max=faceAngle[i];
		if(faceAngle[i]<0 && max<-faceAngle[i]) max=-faceAngle[i];
	}
	
	if(gameMode==AUTOMODE && max<0.01f) {
		int face=solver_next(solver);
		if(face>=0) {
			setMode(AUTOMODE);
			if(face&32)
				anim_ccw(cube,face&31);
			else
				anim_cw(cube,face);
			movesRemaining=moves_remaining(solver);
		} else {
			setMode(FREESTYLEMODE);
		}
	}
	float a=0,b=0;
	for(i=0;i<8;i++) {
		a=a+cube[i+leftface*8]/(i+1.0f);
		b=b+cube[i+frontface*8]/(i+1.0f);
	}
	juliaA=a*0.25f;
	juliaB=b*0.25f;
	//juliaA=juliaA*0.80f+a*0.20f;
	//juliaB=juliaB*0.80f+b*0.20f;
}

int shift=1;
int handleJoyGame(enum Buttons button,int up)
{
	float x,z;
	int offset=-1;
	
	if(controlSet==2 && up==1 && button==BT_RTRIGGER) shift=0;
	if(up==1) return 0;
	switch(controlSet) {
	case 0:	// front left top/bottom
		switch(button) {
		case BT_DOWN:
			anim_ccw(cube,leftface);
			break;
		case BT_UP:
			anim_cw(cube,leftface);
			break;
		case BT_SQUARE:
		case BT_LEFT:
			offset=1;
			// fall through
		case BT_RIGHT:
		case BT_CIRCLE:
			fixfacing();
			//printf("from leftface: %d + offset %d\n",leftface,offset);
			x=fromTarget.z*offset;
			z=-fromTarget.x*offset;
			fromTarget.x=x;
			fromTarget.z=z;
			//printf("rotate to: target %g,%g,%g\n",fromTarget.x,fromTarget.y,fromTarget.z);
			fixfacing();
			rotateTimer=350;
			lastOffset=offset;
			break;
		case BT_TRIANGLE:
			anim_cw(cube,frontface);
			break;
		case BT_CROSS:
			anim_ccw(cube,frontface);
			break;
		case BT_LTRIGGER:
			if(fromTarget.y>0) anim_cw(cube,topface);
			else anim_ccw(cube,topface);
			break;
		case BT_RTRIGGER:
			if(fromTarget.y>0) anim_ccw(cube,topface);
			else anim_cw(cube,topface);
			break;
		default:
			break;
		}
		break;
	case 1:	// top bottom left right front
		switch(button) {
		case BT_LTRIGGER:
			anim_ccw(cube,frontface);
			break;
		case BT_RTRIGGER:
			anim_cw(cube,frontface);
			break;
		case BT_SQUARE:
			anim_ccw(cube,oppositeface(leftface));
			break;
		case BT_CIRCLE:
			anim_cw(cube,oppositeface(leftface));
			break;
		case BT_UP:
			anim_ccw(cube,1);
			break;
		case BT_TRIANGLE:
			anim_cw(cube,1);
			break;
		case BT_DOWN:
			anim_ccw(cube,3);
			break;
		case BT_CROSS:
			anim_cw(cube,3);
			break;
		case BT_LEFT:
			anim_ccw(cube,leftface);
			break;
		case BT_RIGHT:
			anim_cw(cube,leftface);
			break;
		default:
			break;
		}
		break;
	case 2:	// Meta key
		switch(button) {
		case BT_RTRIGGER: shift=1; break;
		case BT_DOWN:
			if(shift==0) 
				anim_cw(cube,3);
			else
				anim_ccw(cube,3);
			break;
		case BT_UP:
			if(shift==0) 
				anim_cw(cube,1);
			else
				anim_ccw(cube,1);
			break;
		case BT_TRIANGLE:
			if(shift==0) 
				anim_cw(cube,oppositeface(frontface));
			else
				anim_ccw(cube,oppositeface(frontface));
			break;
		case BT_CROSS:
			if(shift==0) 
				anim_cw(cube,frontface);
			else
				anim_ccw(cube,frontface);
			break;
		case BT_RIGHT:
			if(shift==0) 
				anim_cw(cube,oppositeface(leftface));
			else
				anim_ccw(cube,oppositeface(leftface));
			break;
		case BT_LEFT:
			if(shift==0) 
				anim_cw(cube,leftface);
			else
				anim_ccw(cube,leftface);
			break;
		case BT_LTRIGGER:
			undo(cube);
			visualRequestId++;
			break;
		case BT_SQUARE:
			redo(cube);
			visualRequestId++;
			break;
		default:
			break;
		}
		break;
	}
	if(gameMode==GAMEMODE && is_solved(cube)) {
		gameMode=SOLVEDMODE;
		time_t currentTime=time(0);
		lastTime=currentTime-startTime;
		if(lastTime<bestTime || bestTime==0) {
			bestTime=lastTime;
			FILE *file=fopen("data/besttime","w");
			if(file) {
				fwrite(&bestTime,sizeof(time_t),1,file);
				fclose(file);
			}
		}
	}
	if(button==BT_START) setMode(PAUSEMODE);
	return 0;
}

int menuMax;

int handleMenu(int menuItem)
{
	int i;
	int max;
	
	switch(menuItem) {
	case 0:	// Timed solve
		// scrable the cube
		max=128;
		init_cube(cube);
		while(max-->0) {
			i=(rand()/4096)%12;
			if(i<6) {
				turn_cw(cube,i);
			} else {
				turn_ccw(cube,i%6);
			}
		}
		reset_undo();
		movesRemaining=moves_remaining(init_solver(cube));
		setMode(GAMEMODE);
		break;
	case 1: // Free Style
		init_cube(cube);
		reset_undo();
		movesRemaining=moves_remaining(init_solver(cube));
		setMode(FREESTYLEMODE);
		break;
	case 2:	// Load
		load_cube(cube);
		setMode(FREESTYLEMODE);
		break;
	case 3: // Visualization
		visual++;
		visualRequestId++;
		//generateVisualization(juliaA,juliaB,background,visual);
		strcpy(alertMessage,visualText[visual%4]);
		break;
	case 4:	// control set
		controlSet=(controlSet+1)%3;
		strcpy(alertMessage,controlSetAlert[controlSet]);
		break;
	case 5: // language
		if(visualText==visualTextEN) {
			menuModeText=menuModeTextFR;
			pauseModeText=pauseModeTextFR;
			visualText=visualTextFR;
			controlSetAlert=controlSetAlertFR;
			summaryControlSet=summaryControlSetFR;
			statusText=statusTextFR;
		} else {
			menuModeText=menuModeTextEN;
			pauseModeText=pauseModeTextEN;
			visualText=visualTextEN;
			controlSetAlert=controlSetAlertEN;
			summaryControlSet=summaryControlSetEN;
			statusText=statusTextEN;
		}
		alertMessage[0]=0;
		break;
	case 6:	// quit
		exitRequest=1;
		return 1;
	}
	return 0;
}

int handlePause(int menuItem)
{
	switch(menuItem) {
	case 0: // continue
		setMode(freestyle?FREESTYLEMODE:GAMEMODE);
		break;
	case 1:	// undo
		undo(cube);
		visualRequestId++;
		setMode(freestyle?FREESTYLEMODE:GAMEMODE);
		break;
	case 2:	// redo
		redo(cube);
		visualRequestId++;
		setMode(freestyle?FREESTYLEMODE:GAMEMODE);
		break;
	case 3:	// Auto solve
#if 0	
		init_cube(cube);
		reset_undo();
		setMode(FREESTYLEMODE);
#else
		reset_undo();
		movesRemaining=moves_remaining(init_solver(cube));
		solver=init_solver(cube);
		int face=solver_next(solver);
		if(face>=0) {
			setMode(AUTOMODE);
			if(face&32)
				anim_ccw(cube,face&31);
			else
				anim_cw(cube,face);
		} else {
			setMode(FREESTYLEMODE);
		}
#endif
		break;
	case 4:	// Save
		save_cube(cube);
		strcpy(alertMessage,statusText[STXT_SAVED]);
		break;		
	case 5: // Visualization
		visual++;
		visualRequestId++;
		//generateVisualization(juliaA,juliaB,background,visual);
		strcpy(alertMessage,visualText[visual%4]);
		break;
	case 6:	// Controls
		controlSet=(controlSet+1)%3;
		strcpy(alertMessage,controlSetAlert[controlSet]);
		break;
	case 7:	// Main menu
		setMode(MENUMODE);
		break;
	}
	return 0;
}

int handleJoy(enum Buttons button,int up)
{
	if(gameMode==GAMEMODE || gameMode==FREESTYLEMODE) {
		return handleJoyGame(button,up);
	}
	// MENUMODE or PAUSEMODE
	if(gameMode==MENUMODE) menuMax=7;
	if(gameMode==PAUSEMODE) menuMax=8;
	if(up==1) return 0;
	switch(button) {
	case BT_UP:
		if(menuItem>0) menuItem--;
		break;
	case BT_DOWN:
		if(menuItem+1<menuMax) menuItem++;
		break;
	case BT_RIGHT:
	case BT_CROSS:
	case BT_START:
		if(gameMode==MENUMODE) return handleMenu(menuItem);
		else if(gameMode==PAUSEMODE) return handlePause(menuItem);
		else if(gameMode==AUTOMODE) setMode(FREESTYLEMODE);
		else setMode(MENUMODE);
		break;
	default:
		break;
	}
	return 0;
}

int handleAnalog(int lx,int ly)
{
	int offset=0;
	if(ly<64) {
		// View top face
		fromTarget.y=15;
		fixfacing();
	} else if(ly>192) {
		// View bottom face
		fromTarget.y=-15;
		fixfacing();
	}
	if(lx<64) {
		offset=1;
	} else if(lx>192) {
		offset=-1;
	}
	if(offset!=lastOffset && offset!=0) {
		lastOffset=0;
		rotateTimer=0;
	}
	if(offset!=0 && rotateTimer==0) {
		float x,z;
		fixfacing();
		//printf("from leftface: %d + offset %d\n",leftface,offset);
		x=fromTarget.z*offset;
		z=-fromTarget.x*offset;
		fromTarget.x=x;
		fromTarget.z=z;
		//printf("rotate to: target %g,%g,%g\n",fromTarget.x,fromTarget.y,fromTarget.z);
		fixfacing();
		rotateTimer=350;
		lastOffset=offset;
	}

	return 0;
}

int main (int argc, char *argv[])
{
    int done;   
	SceCtrlData pad;
    SceCtrlData oldpad;
    oldpad.Buttons=0;
    oldpad.Lx=-1;
    oldpad.Ly=-1;
	srand(time(NULL));

	// Register callbacks.
	setupCallbacks();

	pspDebugScreenInit();
	//pspDebugScreenPrintf("Welcome.\n");

    /* Initialize GU */
	sceGuInit();

	sceGuStart(GU_DIRECT,gulist);
	sceGuDrawBuffer(GU_PSM_8888,0,512);
	sceGuDispBuffer(480,272,(void *)0x88000,512);
	sceGuDepthBuffer((void *)0x110000,512);
	sceGuFinish();
	sceGuSync(0,0);
	sceGuDisplay(GU_TRUE);
	pspDebugScreenSetOffset((int)drawBuffer);
//	pspDebugScreenPrintf("cleared the screen.\n");
	
    init();
    
    sceCtrlSetSamplingCycle(0);
    sceCtrlSetSamplingMode(PSP_CTRL_MODE_ANALOG);

	drawSplash();
//	drawSplash();
//	pspDebugScreenPrintf("drew the splash.\n");
    
	Image *title=loadPng("data/title.png");
    
	if(title) {
		int i;
		for(i=254;i>=0;i-=2) {
			sceGuStart(GU_DIRECT,gulist);
			drawSprite(0,0,480,272,title,0,0);
			drawFilledRect(0,0,480,272,i<<24);
			sceGuFinish();
			sceGuSync(0,0);
			drawBuffer=sceGuSwapBuffers();
			pspDebugScreenSetOffset((int)drawBuffer);
			if(!running()) return 0;
		}
		freeImage(title);
		title=0;
	}

	u64 oldTick;
	u64 newTick;
	sceRtcGetCurrentTick(&newTick);
     
//	printf("Displayed the title (%dx%d; %dx%d)\n",title->imageWidth,title->imageHeight,title->textureWidth,title->textureHeight);

	initFastFont();
	initSound();
	
	printf("event loop\n");
    done = 0;
	sceCtrlReadBufferPositive(&pad,1);
	sceRtcGetCurrentTick(&newTick);
	initCubeVert();
	init_cube(cube);
	fixfacing();
    while (running())
    {
		int changedButtons;
		
		oldpad.Buttons=pad.Buttons;
		oldpad.Lx=pad.Lx;
		oldpad.Ly=pad.Ly;
		sceCtrlReadBufferPositive(&pad,1);
		changedButtons=pad.Buttons^oldpad.Buttons;

#define handleJoyChange(from,to) if(changedButtons&from) done+=handleJoy(to,(pad.Buttons&from)==0?1:0)
		handleJoyChange(PSP_CTRL_UP,BT_UP);
		handleJoyChange(PSP_CTRL_DOWN,BT_DOWN);
		handleJoyChange(PSP_CTRL_LEFT,BT_LEFT);
		handleJoyChange(PSP_CTRL_RIGHT,BT_RIGHT);
		handleJoyChange(PSP_CTRL_TRIANGLE,BT_TRIANGLE);
		handleJoyChange(PSP_CTRL_SQUARE,BT_SQUARE);
		handleJoyChange(PSP_CTRL_CIRCLE,BT_CIRCLE);
		handleJoyChange(PSP_CTRL_CROSS,BT_CROSS);
		handleJoyChange(PSP_CTRL_LTRIGGER,BT_LTRIGGER);
		handleJoyChange(PSP_CTRL_RTRIGGER,BT_RTRIGGER);
		handleJoyChange(PSP_CTRL_START,BT_START);
		handleJoyChange(PSP_CTRL_SELECT,BT_SELECT);
		handleJoyChange(PSP_CTRL_HOLD,BT_HOLD);
		if(pad.Buttons & PSP_CTRL_SELECT && changedButtons & PSP_CTRL_SELECT) {
			char buf[64];
			static int cap=1;
			sprintf(buf,"sushirubik%d.png",cap++);
			saveImagePng(buf,(u32 *)(0x04000000),480,272,512,0);
		}

		if(pad.Lx!=oldpad.Lx) handleAnalog(pad.Lx,pad.Ly);
		if(pad.Ly!=oldpad.Ly) handleAnalog(pad.Lx,pad.Ly);

		/* Draw to screen */
		draw();
#ifdef VID_CAPTURE
		{
			unsigned long now=timeGetTime();
			static int shotNo=0;
			char fname[256];
			shotNo++;
			sprintf(fname,"cap%04d.tga",shotNo);
			saveImageTarga(fname,(Color *)(0x04000000+(char *)drawBuffer),480,272,512,0);
			frozenTime+=timeGetTime()-now;
		}
#endif
	
		oldTick=newTick;	
		sceRtcGetCurrentTick(&newTick);

		updateSound();

		// Now update the game state.
		int elapsed=(newTick-oldTick)/1000;
		//scePowerSetClockFrequency(333, 333, 166);
		update(elapsed);
		//scePowerSetClockFrequency(222, 222, 166);
		
		//if(game.mode==GAME_QUIT) break;
    }
    printf("quit requested.\n");
    sceGuTerm();
    
    sceKernelExitGame();
    return 0;
}
