/* Main */

// image.c
typedef unsigned int Color;
typedef struct Image
{
        int textureWidth;  // the real width of data, 2^n with n>=0
        int textureHeight;  // the real height of data, 2^n with n>=0
        int imageWidth;  // the image width
        int imageHeight;	// the image height
        int isSwizzled;	// Is the image swizzled?
        int vram;		// Is the image in vram or not?
        Color* data;
} Image;
Image *loadPng(const char *filename);
void freeImage(Image *image);
void resetVRam();
extern int swizzleToVRam;
void swizzleFast(Image *source);
void saveImagePng(const char* filename, Color* data, int width, int height, int lineSize, int saveAlpha);
void saveImageTarga(const char* filename, Color* data, int width, int height, int lineSize, int saveAlpha);
enum FontId {
	FONT_HEADLINE,FONT_BODY,FONT_BODYHIGHLIGHT,FONT_MESSAGE,FONT_SMALL,FONT_SMALLHIGHLIGHT
};
void initFastFont();
void extentMessage(int *w,int *h, enum FontId fontId, const char *message);
void drawMessage(int x,int y, enum FontId fontId, const char *message);
void drawMessageFormat(int x,int y,enum FontId fontId, const char *message);
void drawCell(int x,int y,const char *fname);
void freeCells();

// sound.c
enum Sfx {
	SFX_OPENING,SFX_MENUNEXT,SFX_MENUSELECT,SFX_TURN,SFX_ROTATE,SFX_WIN,MAX_SFX	
};
void initSound();
void updateSound();
void playSfx(enum Sfx id);
void playSound(int id);
void playWav(const char *fname);
void freeWavs();

// main.c
void drawSprite(int sx, int sy, int width, int height, Image* source, int dx, int dy);

// julia.c
void generateVisualization(float a,float b,Image *image,int id);
void generateJulia(float a,float b,Image *image);
void generateWallpaper(float a,float b,Image *image);
void generatePlasma(float a,float b,Image *image);
