/* psprubik.h
 */

struct Face {
	float x,y,z;	// position
	float nx,ny,nz;	// normal
};
 
void init_cube( int cube[]);
/** turns around face counterclockwise
 * \param cube the 48 elements of the screen
 * \param face which face to turn about
 */
void turn_ccw( int cube[], int face);
/** turns around the face clockwise
 * \param cube the 48 elements of the screen
 * \param face which face to turn about the screen
 */
void turn_cw( int cube[], int face);
/** 
 * \returns 1 if the cube is in solved state.
 */
int is_solved( int cube[]);
/** build the grid of face orientations
 * \returns the list of faces
 */
struct Face *build_positions();
/**  redo the moves if there are 
 * \param cube the 48 moveable squares
 */
void undo(int cube[]);
/**  redo the moves if there are 
 * \param cube the 48 moveable squares
 */
void redo(int cube[]);
/** undo a move length
 * \returns the number of moves that can be undone
 */
int undo_length();
/** redo a move length
 * \returns the number of moves that can be redone
 */
int redo_length();
/** clears the moves in the undo/redo buffer.
 */
void reset_undo();
/** solves the cube from the current state
 * \param cube the cube state to start from
 * \returns context handle to change
 */
void *init_solver(const int cube[]);
/** returns the next move to make to solve the cube
 * \param context is the state infromation returned by init.
 * \returns face to rotate 0 to 5 for cw or 32 to 37 for ccw, or -1 if solved.
 */
int solver_next(void *context);
/** moves that are remaining for a solution
 * \param context the object returned by init_solver.
 * \returns an estimate of how many moves it would take the solver to complete.
 */
int moves_remaining(void *context);
void save_cube(int cube[]);
void load_cube(int cube[]);
